(use-modules (gtk gtk) (gtk gdk))

(define (arc-drawer-new width height start-adj extent-adj)
  (let ((widget (gtk-drawing-area-new))
	(pixmap #f) (window #f)
	(fore-gc #f) (back-gc #f) (handle-gc #f)
	(start #f) (extent #f) (need-update #t)
	(dx 5) (dy 5) (w (- width 10)) (h (- height 10))
	(pi (* 2 (acos 0))))

    (define (realize)
      (set! window (gtk-widget-window widget))
      (set! pixmap (gdk-pixmap-new window width height))
      (let ((style (gtk-widget-style widget)))
	(set! fore-gc (gtk-style-fg-gc style 'normal))
	(set! back-gc (gtk-style-bg-gc style 'normal))
	(set! handle-gc (gdk-gc-new pixmap))
	(gdk-gc-set-foreground handle-gc "red3")))
      
    (define (expose ev)
      (if need-update (update))
      (gdk-draw-pixmap window back-gc pixmap 0 0 0 0 width height))

    (define (update)
      (set! start (inexact->exact (* (gtk-adjustment-value start-adj) 64)))
      (set! extent (inexact->exact (* (gtk-adjustment-value extent-adj) 64)))
      (cond (window
	     (define (->rad x)
	       (* x (/ pi (* 180 64))))
	     (define (draw-handle angle)
	       (let ((x (inexact->exact (* 0.5 w (cos (->rad angle)))))
		     (y (inexact->exact (* -0.5 h (sin (->rad angle))))))
		 (gdk-draw-rectangle pixmap handle-gc #t
				     (+ x dx (/ w 2) -2)
				     (+ y dy (/ w 2) -2)
				     4 4)))
	     (gdk-draw-rectangle pixmap back-gc #t 0 0 width height)
	     (gdk-draw-arc pixmap fore-gc #f
			   dx dy w h (remainder start (* 360 64)) extent)
	     (draw-handle start)
	     (draw-handle (+ start extent))
	     (set! need-update #f)
	     (expose #f))))

    (define (pk-event ev)
      (pk (gdk-event-type ev) (gdk-event-x ev) (gdk-event-y ev)))

    (gtk-signal-connect widget "motion_notify_event"
			(lambda (ev)
			  (let ((x (inexact->exact (gdk-event-x ev)))
				(y (inexact->exact (gdk-event-y ev))))
			    (gdk-draw-rectangle window handle-gc #t
						(- x 2) (- y 2)
						4 4))))
    (gtk-signal-connect widget "realize" realize)
    (gtk-signal-connect widget "expose_event" expose)
    (gtk-signal-connect start-adj "value_changed" update)
    (gtk-signal-connect extent-adj "value_changed" update)
    (gtk-drawing-area-size widget width height)
    (gtk-widget-set-events widget '(exposure-mask button1-motion-mask
				    key-press-mask))
    widget))

(let* ((window (gtk-window-new 'toplevel))
       (vbox   (gtk-vbox-new #f 5))
       (start-adj (gtk-adjustment-new 360.0 0.0 721.0 1.0 1.0 1.0))
       (start-scl (gtk-hscale-new start-adj))
       (extent-adj (gtk-adjustment-new 180.0 0.0 361.0 1.0 1.0 1.0))
       (extent-scl (gtk-hscale-new extent-adj))
       (arc    (arc-drawer-new 150 150 start-adj extent-adj))
       (close  (gtk-button-new-with-label "close")))

  (gtk-signal-connect start-scl "key_press_event"
		      (lambda (ev)
			(pk 'keyval (gdk-event-string ev))))
  (gtk-container-add window vbox)
  (gtk-box-pack-start vbox arc #f #f 0)
  (gtk-box-pack-start vbox start-scl #f #f 0)
  (gtk-box-pack-start vbox extent-scl #f #f 0)
  (gtk-box-pack-start vbox close #f #f 0)
  (gtk-signal-connect close "clicked" (lambda () (gtk-widget-destroy window)))
  (gtk-scale-set-draw-value start-scl #f)
  (gtk-scale-set-draw-value extent-scl #f)
  (gtk-widget-show-all window)
  (gtk-standalone-main window))
