
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesong.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsemathsignal.h>
#include <bse/bsesong.h>
#include <bse/bsebus.h>
#include <bse/bsepart.h>
#include <bse/bsetrack.h>
#include "bsemidireceiver.h"
#include "bseundostack.h"
#include "bseproject.h"
#include "gslcommon.h"
#include "bseengine.h"
#include <string.h>

#line 35 "bsesong.proc"

/* --- create-bus --- */
static void
create_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 36 "bsesong.proc"
 {
#line 38 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 42 "bsesong.proc"
}  }
static BseErrorType
#line 42 "bsesong.proc"
create_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 45 "bsesong.proc"
{
#line 46 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseUndoStack *ustack;
  BseItem *child = NULL;

#line 52 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 56 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      ustack = bse_item_undo_open (self, "create-bus");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_BUS, NULL);
      bse_item_push_undo_proc (self, "remove-bus", child);
      bse_item_undo_close (ustack);
    }

#line 67 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-bus --- */
static void
remove_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 73 "bsesong.proc"
 {
#line 75 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 79 "bsesong.proc"
}  }
static BseErrorType
#line 79 "bsesong.proc"
remove_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 82 "bsesong.proc"
{
#line 83 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 88 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_BUS (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 92 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 98 "bsesong.proc"
      
      bse_item_set (child, "master-output", FALSE, NULL);
#line 100 "bsesong.proc"
      
#line 101 "bsesong.proc"
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);     
#line 102 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-bus", child);
#line 104 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 106 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- ensure-master-bus --- */
static void
ensure_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 113 "bsesong.proc"
 {
#line 115 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 119 "bsesong.proc"
}  }
static BseErrorType
#line 119 "bsesong.proc"
ensure_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 122 "bsesong.proc"
{
#line 123 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseSource *child;

#line 127 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 131 "bsesong.proc"
  
  child = bse_song_ensure_master (self);

#line 134 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- get-master-bus --- */
static void
get_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 140 "bsesong.proc"
 {
#line 142 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 146 "bsesong.proc"
}  }
static BseErrorType
#line 146 "bsesong.proc"
get_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 149 "bsesong.proc"
{
#line 150 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);

#line 153 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 157 "bsesong.proc"
  
  BseBus *bus = bse_song_find_master (self);

#line 160 "bsesong.proc"
  
  bse_value_set_object (out_values++, bus);
  
  return BSE_ERROR_NONE;
}

static const gchar*
orphans_track_name (void)
{
#line 169 "bsesong.proc"
  
  return _("Orphan Parts");
}

static BseTrack*
bse_song_ensure_orphans_track_noundo (BseSong *self)
{
  SfiRing *ring;
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = ring->data;
      gboolean muted = FALSE;
      g_object_get (track, "muted", &muted, NULL);
#line 184 "bsesong.proc"
      if (muted && g_object_get_data (track, "BseSong-orphan-track") == bse_song_ensure_orphans_track_noundo) 
        return track;
    }
  gpointer child = bse_container_new_child_bname (BSE_CONTAINER (self), BSE_TYPE_TRACK, orphans_track_name(), NULL);
#line 188 "bsesong.proc"
  g_object_set (child, "muted", TRUE, NULL); 
#line 189 "bsesong.proc"
  g_object_set_data (child, "BseSong-orphan-track", bse_song_ensure_orphans_track_noundo); 
  return child;
}

static BseTrack*
bse_song_find_first_track (BseSong *self,
                           BsePart *part)
{
  SfiRing *ring;
#line 198 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = ring->data;
      guint start;
      if (bse_track_find_part (track, part, &start))
        return track;
    }
  return NULL;
}

/* --- ensure-track-links --- */
static void
ensure_track_links_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 209 "bsesong.proc"
 {
#line 211 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
#line 213 "bsesong.proc"
}  }
static BseErrorType
#line 213 "bsesong.proc"
ensure_track_links_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 216 "bsesong.proc"
{
#line 217 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);

#line 220 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 224 "bsesong.proc"
  
  gboolean clear_undo = FALSE;
  SfiRing *ring;
  for (ring = self->parts; ring; ring = sfi_ring_walk (ring, self->parts))
    if (!bse_song_find_first_track (self, ring->data))
      {
        BseTrack *track = bse_song_ensure_orphans_track_noundo (self);
        bse_item_exec_void (track, "insert-part", bse_track_get_last_tick (track), ring->data);
        clear_undo = TRUE;
      }
  if (clear_undo)
    {
      BseProject *project = bse_item_get_project (BSE_ITEM (self));
      if (project)
        bse_project_clear_undo (project);
    }
  
  return BSE_ERROR_NONE;
}

/* --- create-part --- */
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 244 "bsesong.proc"
 {
#line 246 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("part", NULL, NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 250 "bsesong.proc"
}  }
static BseErrorType
#line 250 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 253 "bsesong.proc"
{
#line 254 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 259 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 263 "bsesong.proc"
  
  ustack = bse_item_undo_open (self, "create-part");
  child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_PART, NULL);
  bse_item_push_undo_proc (self, "remove-part", child);
  bse_item_undo_close (ustack);
  
#line 269 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-part --- */
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 275 "bsesong.proc"
 {
#line 277 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 281 "bsesong.proc"
}  }
static BseErrorType
#line 281 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 284 "bsesong.proc"
{
#line 285 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 290 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 294 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 300 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 302 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-part", child);
#line 304 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 306 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- create-track --- */
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 313 "bsesong.proc"
 {
#line 315 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 319 "bsesong.proc"
}  }
static BseErrorType
#line 319 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 322 "bsesong.proc"
{
#line 323 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseItem *child = NULL;

#line 328 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 332 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "create-track");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);
      bse_item_push_undo_proc (self, "remove-track", child);
      bse_item_undo_close (ustack);
    }

#line 343 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-track --- */
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 349 "bsesong.proc"
 {
#line 351 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 355 "bsesong.proc"
}  }
static BseErrorType
#line 355 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 358 "bsesong.proc"
{
#line 359 "bsesong.proc"
  
  BseSong *self  = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 364 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (child) ||
      BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 369 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 375 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 377 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-track", child);
#line 379 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 381 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- find-track-for-part --- */
static void
find_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 388 "bsesong.proc"
 {
#line 390 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 396 "bsesong.proc"
}  }
static BseErrorType
#line 396 "bsesong.proc"
find_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 399 "bsesong.proc"
{
#line 400 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);
  BseTrack *track = NULL;
  guint tick = 0;
  SfiRing *ring;

#line 407 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 412 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *test_track = ring->data;
      guint start;
      if (bse_track_find_part (test_track, part, &start) &&
	  (!track || start < tick))
	{
	  track = test_track;
	  tick = start;
	}
    }

#line 425 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  
  return BSE_ERROR_NONE;
}

/* --- find-any-track-for-part --- */
static void
find_any_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 431 "bsesong.proc"
 {
#line 433 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 439 "bsesong.proc"
}  }
static BseErrorType
#line 439 "bsesong.proc"
find_any_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 442 "bsesong.proc"
{
#line 443 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);

#line 447 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 452 "bsesong.proc"
  
  bse_value_set_object (out_values++, bse_song_find_first_track (self, part));
  
  return BSE_ERROR_NONE;
}

/* --- synthesize-note --- */
static void
synthesize_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 458 "bsesong.proc"
 {
#line 460 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++)    = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
#line 472 "bsesong.proc"
}  }
static BseErrorType
#line 472 "bsesong.proc"
synthesize_note_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 475 "bsesong.proc"
{
#line 476 "bsesong.proc"
  
  BseSong *self      = bse_value_get_object (in_values++);
  BseTrack *track    = bse_value_get_object (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note      = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  
#line 484 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 489 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self) && self->midi_receiver_SL)
    {
      gfloat freq = BSE_KAMMER_FREQUENCY *
		    BSE_SEMITONE_FACTOR (note) *
		    BSE_FINE_TUNE_FACTOR (fine_tune);
      SfiTime tstamp = gsl_tick_stamp () + bse_engine_block_size () * 2;
      BseMidiEvent *eon, *eoff;
      eon  = bse_midi_event_note_on (track->midi_channel_SL, tstamp, freq, velocity);
      eoff = bse_midi_event_note_off (track->midi_channel_SL, tstamp + duration, freq);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eon);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eoff);
      bse_midi_receiver_process_events (self->midi_receiver_SL, tstamp + duration);
      bse_project_keep_activated (BSE_PROJECT (BSE_ITEM (self)->parent), tstamp + duration);
    }
  
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 508 "bsesong.proc"
 {
#line 510 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL, BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 513 "bsesong.proc"
}  }
static BseErrorType
#line 513 "bsesong.proc"
get_timing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 516 "bsesong.proc"
{
#line 517 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseSongTiming timing = { 0, };

#line 522 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 526 "bsesong.proc"
  
  bse_song_get_timing (self, tick, &timing);

#line 529 "bsesong.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new mixer bus for a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 37;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_bus = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSong+create-bus", 
    NULL,
    "/Methods/BseSong/General/Create Bus",
    NULL,
    __enode_create_bus__fill_strings,
  },
  0, create_bus_setup, create_bus_exec, 
};
static void
__enode_remove_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a mixer bus from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 74;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_bus = {
  { (BseExportNode*) &__enode_create_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-bus", 
    NULL,
    "/Methods/BseSong/General/Remove Bus",
    NULL,
    __enode_remove_bus__fill_strings,
  },
  0, remove_bus_setup, remove_bus_exec, 
};
static void
__enode_ensure_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song, will create one if it doesn't exist.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 114;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_master_bus = {
  { (BseExportNode*) &__enode_remove_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-master-bus", 
    NULL,
    "/Methods/BseSong/General/Ensure Master Bus",
    NULL,
    __enode_ensure_master_bus__fill_strings,
  },
  0, ensure_master_bus_setup, ensure_master_bus_exec, 
};
static void
__enode_get_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song if it exists.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 141;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_master_bus = {
  { (BseExportNode*) &__enode_ensure_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+get-master-bus", 
    NULL,
    "/Methods/BseSong/General/Get Master Bus",
    NULL,
    __enode_get_master_bus__fill_strings,
  },
  0, get_master_bus_setup, get_master_bus_exec, 
};
static void
__enode_ensure_track_links__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Ensure that each part in a song is inserted into at least one track.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 210;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_track_links = {
  { (BseExportNode*) &__enode_get_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-track-links", 
    NULL,
    "/Methods/BseSong/General/Ensure Track Links",
    NULL,
    __enode_ensure_track_links__fill_strings,
  },
  0, ensure_track_links_setup, ensure_track_links_exec, 
};
static void
__enode_create_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Part in a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 245;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_part = {
  { (BseExportNode*) &__enode_ensure_track_links, BSE_EXPORT_NODE_PROC,
    "BseSong+create-part", 
    NULL,
    "/Methods/BseSong/General/Create Part",
    NULL,
    __enode_create_part__fill_strings,
  },
  0, create_part_setup, create_part_exec, 
};
static void
__enode_remove_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Part from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 276;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_part = {
  { (BseExportNode*) &__enode_create_part, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-part", 
    NULL,
    "/Methods/BseSong/General/Remove Part",
    NULL,
    __enode_remove_part__fill_strings,
  },
  0, remove_part_setup, remove_part_exec, 
};
static void
__enode_create_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Track for a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 314;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_track = {
  { (BseExportNode*) &__enode_remove_part, BSE_EXPORT_NODE_PROC,
    "BseSong+create-track", 
    NULL,
    "/Methods/BseSong/General/Create Track",
    NULL,
    __enode_create_track__fill_strings,
  },
  0, create_track_setup, create_track_exec, 
};
static void
__enode_remove_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Track from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 350;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_track = {
  { (BseExportNode*) &__enode_create_track, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-track", 
    NULL,
    "/Methods/BseSong/General/Remove Track",
    NULL,
    __enode_remove_track__fill_strings,
  },
  0, remove_track_setup, remove_track_exec, 
};
static void
__enode_find_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find a track suitable for playing notes of a given part.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 389;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_track_for_part = {
  { (BseExportNode*) &__enode_remove_track, BSE_EXPORT_NODE_PROC,
    "BseSong+find-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Track For Part",
    NULL,
    __enode_find_track_for_part__fill_strings,
  },
  0, find_track_for_part_setup, find_track_for_part_exec, 
};
static void
__enode_find_any_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find the first track that contains part, suitable to check for orphan parts.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 432;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_any_track_for_part = {
  { (BseExportNode*) &__enode_find_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+find-any-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Any Track For Part",
    NULL,
    __enode_find_any_track_for_part__fill_strings,
  },
  0, find_any_track_for_part_setup, find_any_track_for_part_exec, 
};
static void
__enode_synthesize_note__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Synthesize a note on a song of an active project.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 459;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_synthesize_note = {
  { (BseExportNode*) &__enode_find_any_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+synthesize-note", 
    NULL,
    "/Methods/BseSong/General/Synthesize Note",
    NULL,
    __enode_synthesize_note__fill_strings,
  },
  0, synthesize_note_setup, synthesize_note_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve song timing information at a specific tick.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 509;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_synthesize_note, BSE_EXPORT_NODE_PROC,
    "BseSong+get-timing", 
    NULL,
    "/Methods/BseSong/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
BseExportNode* bse__builtin_init_bsesong_genprc_c (void);
BseExportNode* bse__builtin_init_bsesong_genprc_c (void)
{
  return (BseExportNode*) &__enode_get_timing;
}

/*
 * Generated data ends here
 */
