/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_PARSER_PRIV_H__
#define __BSE_PARSER_PRIV_H__

#include	<bse/bseparser.h>
#include	<bse/bsesample.h>
#include	<bse/bsesong.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */




/* --- defines --- */
#define	PDATA(scanner)				((BseParserData*)((GScanner*)scanner)->user_data)
#define	bse_parser_should_abort(scanner)	(g_scanner_eof ((scanner)) || (scanner)->parse_errors >= (scanner)->max_parse_errors)
#define	bse_parser_unexp_token(t,e)		g_scanner_unexp_token ((t), (e), "identifier", "keyword", NULL, NULL, 1)
#define	bse_parser_unexp_token_skip(t,e)	g_scanner_unexp_token ((t), (e), "identifier", "keyword", NULL, "skipping...", 1)
#define	bse_parser_unexp_symbol(t,e,s)		g_scanner_unexp_token ((t), (e), "identifier", "keyword", (s), NULL, 1)
#define	bse_parser_unexp_symbol_skip(t,e,s)	g_scanner_unexp_token ((t), (e), "identifier", "keyword", (s), NULL, 1)

/* --- typedefs --- */
typedef struct	_BseParserData		BseParserData;
typedef	struct	_BseParserSymbol	BseParserSymbol;
typedef	struct	_BseParserEntry		BseParserEntry;
typedef struct	_BseParserMunk		BseParserMunk;
typedef struct	_BseParserBlock		BseParserBlock;
typedef	guint	(*BseParserFunc)	(GScanner		*scanner,
					 BseParserSymbol	*symbol,
					 guint			job_id,
					 gpointer		struct_data);


/* --- value block types --- */
enum
{
  BSE_BLOCK_ZERO,
  BSE_BLOCK_BINARY_APPENDIX,
  BSE_BLOCK_TYPES_LAST
};


/* --- parser structures --- */
struct	_BseParserData
{
  GSList	*valid_song_names;
  GSList	*valid_sample_names;
  GSList	*pblock_list;
  GSList	*binary_pblock_list;
  GSList	*new_songs;
  GSList	*new_samples;
  guint		 pattern_cntr_row;
  guint		 pattern_cntr_channel;
  guint		 in_appendix_definition : 1;
  guint		 parse_all_songs : 1;
  guint		 parse_all_samples : 1;
  guint		 skip_song_dups : 1;
  guint		 skip_sample_dups : 1;
};
struct	_BseParserSymbol
{
  gchar			*name;
  BseParserFunc		 func;
  guint			job_id;
  guint			group;
};
struct	_BseParserEntry
{
  BseParserSymbol	*symbols;
  guint			n_symbols;
};


/* --- temporary parser representations --- */
struct _BseParserMunk
{
  BseSample	 *sample;
  guint		  note;
  guint		  loop_begin;
  guint		  loop_end;
  guint		  block_offset;
  guint		  n_values;
  BseParserBlock *pblock;
  BseParserMunk	 *next;
};
struct _BseParserBlock
{
  guint block_type;
  guint	nth_appendix;
  guint recording_note;
  guint n_values;
  guint byte_size;
  guint big_endian : 1;
  BseValueBlock *vblock;
  gchar *identifier;
  guint possible_loop_begin;
  guint possible_loop_end;
};


/* --- prototypes --- */
static gchar*	parser_check_song_name	(GScanner	*scanner,
					 const gchar	*template);
static gchar*	parser_check_sample_name(GScanner	*scanner,
					 const gchar	*template);
static guint	parser_scan_note	(GScanner	*scanner,
					 guint		*note,
					 gchar		**err_string);
static void	parser_skip_statement	(GScanner	*scanner,
					 guint		 starting_level);
static guint	parser_parse_symbol	(GScanner	*scanner,
					 guint		 symbol_group,
					 gpointer	 struct_data);
static guint	parser_parse_rest	(GScanner	*scanner,
					 BseParserSymbol*symbol_group_member,
					 gpointer	 struct_data);


/* --- job id's for generic parser functions --- */
enum	/* job id's */
{
  JOB_ID_NONE,

  /* sample types
   */
  JOB_ID_NOTE_MUNKS,
  JOB_ID_EFFECT_MUNKS,

  /* note values
   */
  JOB_ID_REC_NOTE,
  
  /* strings
   */
  JOB_ID_SAMPLE_BLURB,
  JOB_ID_SAMPLE_TYPE_BLURB,
  JOB_ID_PATTERN_BLURB,
  JOB_ID_PATTERN_NAME,
  JOB_ID_INSTRUMENT_BLURB,
  JOB_ID_INSTRUMENT_NAME,
  JOB_ID_INSTRUMENT_DSAMPLE_PATH,
  JOB_ID_SONG_BLURB,
  JOB_ID_SONG_AUTHOR,
  JOB_ID_SONG_COPYRIGHT,
  JOB_ID_SONG_BSE_VER,

  /* numbers
   */
  JOB_ID_OCTAVE_SHIFT,
  JOB_ID_BLOCK_BYTE_SIZE,
  JOB_ID_BLOCK_N_VALUES,
  JOB_ID_SAMPLE_N_CHANNELS,
  JOB_ID_SAMPLE_REC_FREQ,
  JOB_ID_SONG_BPM,
  JOB_ID_SONG_VOLUME,
  JOB_ID_INSTRUMENT_VOLUME,
  JOB_ID_INSTRUMENT_BALANCE,
  JOB_ID_INSTRUMENT_TRANSPOSE,
  JOB_ID_INSTRUMENT_FINE_TUNE,
  JOB_ID_INSTRUMENT_DELAY_TIME,
  JOB_ID_INSTRUMENT_ATTACK_TIME,
  JOB_ID_INSTRUMENT_ATTACK_LEVEL,
  JOB_ID_INSTRUMENT_DECAY_TIME,
  JOB_ID_INSTRUMENT_SUSTAIN_LEVEL,
  JOB_ID_INSTRUMENT_SUSTAIN_TIME,
  JOB_ID_INSTRUMENT_RELEASE_LEVEL,
  JOB_ID_INSTRUMENT_RELEASE_TIME,

  /* flags
   */
  JOB_ID_LITTLE_ENDIAN,
  JOB_ID_BIG_ENDIAN,
  JOB_ID_INSTRUMENT_INTERPOLATION_ON,
  JOB_ID_INSTRUMENT_INTERPOLATION_OFF,
  JOB_ID_INSTRUMENT_POLYPHONY_ON,
  JOB_ID_INSTRUMENT_POLYPHONY_OFF,

  /* dates
   */
  JOB_ID_SONG_CREATED,
  JOB_ID_SONG_MODIFIED,
  JOB_ID_SAMPLE_CREATED,
  JOB_ID_SAMPLE_MODIFIED,

  /* pattern specifics
   */
  JOB_ID_PATTERN_SET_ROW,
  JOB_ID_PATTERN_SET_CHANNEL,
  JOB_ID_PATTERN_STEP_ROW,

  JOB_ID_LAST
};


/* --- generic parser functions --- */
static guint parse_string	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_note		(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_number	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_flag		(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_date		(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);


/* --- bseparsersong.c prototypes --- */
static guint parse_song		(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_instrument	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_pattern	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_pattern_cntr	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_pattern_note	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);


/* --- bseparsersample.c prototypes --- */
static BseErrorType 	read_block	(int		 fd,
					 BseParserBlock	*pblock);
static guint parse_binary_appendix (GScanner		*scanner,
				    BseParserSymbol	*symbol,
				    guint		job_id,
				    gpointer		struct_data);
static guint parse_value_block	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_sample	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_munk		(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_loop		(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);
static guint parse_block	(GScanner		*scanner,
				 BseParserSymbol	*symbol,
				 guint			job_id,
				 gpointer		struct_data);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_PARSER_PRIV_H__ */
