/*
  File:	MakeLinearMap.c
  Authors: James Painter,
           K.R. Sloan
  Last Modified: 10 July 1989
  Purpose: Fill a colormap with a linear wash
  */

#include <stdio.h>
#include "ColorMap.h"

static char *RoutineName = (char *)0;
static char *InputFile   = (char *)0;
static int val1, val2, r1, g1, b1, r2, g2, b2;

static void usage()
 {
  fprintf( stderr, "Usage is\n");
  fprintf( stderr, "\t%s [-f oldfile] startpixval [endpixval] ", RoutineName);
  fprintf( stderr, "r g b [r g b]]\n");
 }

void
FillMap( theMap )
 ColorMapType *theMap;
 {
  int v;

  if (val1 == val2)
   {
    theMap->map[val1][0] = r1;
    theMap->map[val1][1] = g1;
    theMap->map[val1][2] = b1;
    return;
   }

  for(v=val1; v<=val2; v++) 
   {
    theMap->map[v][0] = r1 + (v-val1)*(r2-r1)/(val2-val1);
    theMap->map[v][1] = g1 + (v-val1)*(g2-g1)/(val2-val1);
    theMap->map[v][2] = b1 + (v-val1)*(b2-b1)/(val2-val1);
   }
 }

static int GetArg(str)
 char *str;
 {
  int i;
  
  i = atoi(str);
  if (i > 255)
   {
    fprintf(stderr, "%s: arg too big!\n", RoutineName);
    exit (-1);
   }
  return i;
 }


void
ParseCommandLine(argc,argv)
int argc;
 char *argv[];
 {
  int ArgsParsed = 0;

  RoutineName = argv[ArgsParsed++];
  if (argc < 2) { usage(); exit (-1); }
  
  if(strcmp(argv[ArgsParsed],"-f") == 0)
   {
    ArgsParsed++;
    if (argc <= ArgsParsed) { usage(); exit(-1); }
    InputFile = argv[ArgsParsed++];
fprintf(stderr,"InputFile = %s\n",InputFile);
   }
  
  switch(argc-ArgsParsed)
   {
    case 4: 
fprintf(stderr,"case 4\n");
      val1 = val2 = GetArg(argv[ArgsParsed++]);
      r1   = r2   = GetArg(argv[ArgsParsed++]);
      g1   = g2   = GetArg(argv[ArgsParsed++]);
      b1   = b2   = GetArg(argv[ArgsParsed++]);
      break;
      
    case 5: 
fprintf(stderr,"case 5\n");
     val1 =        GetArg(argv[ArgsParsed++]);
     val2 =        GetArg(argv[ArgsParsed++]);
     r1   = r2   = GetArg(argv[ArgsParsed++]);
     g1   = g2   = GetArg(argv[ArgsParsed++]);
     b1   = b2   = GetArg(argv[ArgsParsed++]);
     break;
	
    case 8:
fprintf(stderr,"case 8\n");
     val1 =        GetArg(argv[ArgsParsed++]);
     val2 =        GetArg(argv[ArgsParsed++]);
     r1   =        GetArg(argv[ArgsParsed++]);
     g1   =        GetArg(argv[ArgsParsed++]);
     b1   =        GetArg(argv[ArgsParsed++]);
     r2   =        GetArg(argv[ArgsParsed++]);
     g2   =        GetArg(argv[ArgsParsed++]);
     b2   =        GetArg(argv[ArgsParsed++]);
     break;
    default:
fprintf(stderr,"default\n");
     usage();
     exit (-1);
   }
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  FILE *in;
  ColorMapType *map;

  ParseCommandLine(argc,argv);
  if (InputFile) 
   {
    if (strcmp(InputFile,"-") == 0) 
     in = stdin;
    else if ( (in = fopen(InputFile,"r")) == 0) 
     {
      fprintf( stderr, "Unable to open input file\n" );
      usage();
      exit(-1);
     }
    fprintf(stderr,"%s: Reading color map from %s\n", RoutineName,InputFile);
    map = ReadColorMap( in );
    if ((ColorMapType *)0 == map)
     {
      fprintf(stderr,"%s: ReadColorMap failed\n",RoutineName);
      exit(-1);
     }
   } 
  else 
   {
    fprintf(stderr,"%s: Creating new color map\n", RoutineName);
    map = CreateColorMap( 3, 8, 8 );
    if ((ColorMapType *)0 == map)
     {
      fprintf(stderr,"%s: CreateColorMap failed\n",RoutineName);
      exit(-1);
     }
   }

  if (  (3 != map->NBands)
      ||(8 != map->BitsIn)
      ||(8 != map->BitsOut) ) 
   {
    fprintf(stderr,"%s: Color Map is (%d,%d,%d) - should be (3,8,8)\n",
            RoutineName, map->NBands, map->BitsIn, map->BitsOut);
    exit(-1);
   }
  FillMap(map);
  WriteColorMap(map, stdout);
 }
