#ifndef RANDSTATE_H
#define RANDSTATE_H

/* 
 * The random number generator state consists of the following:
 *    1) a seed it was initialized with
 *    2) a distribution that describes the numbers it generates
 *    3) parameters describing the distribution:
 *       - mean  
 *       - variance = half-width for uniform distribution
 *                  = variance for normal distribution
 *    4) support for both integer and double-precision return values
 *
 * Currently the only distributions supported are uniform (default)
 * and normal or Gaussian.
 *
 * 12/21/94 Greg Wolodkin
 */

class Rand {
public:
	Rand();
	virtual ~Rand();

	double GetNumber(void);
	void SetSeed(unsigned int s) {seed = s; srand(s);}
	int GetSeed(void) const {return (seed);}
	void SetDist(int d) {normal = (d != 0);}
	int GetDist(void) const {return (normal);}
	void SetType(int i) {integer = (i != 0);}
	int GetType(void) const {return (integer);}
	void SetMean(double m) {mean = m;}
	double GetMean(void) const {return (mean);}
	void SetVariance(double v) {variance = v;}
	double GetVariance(void) const {return (variance);}
	void SetError(const char *err);

private:
	char *error;
	int normal, seed, integer;
	double mean, variance;
};
#endif
