/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-11-06

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/

#ifndef	_sam_enc_h_
#define	_sam_enc_h_

#include "common.h"
#include "bitstream.h"
#include "tf_main.h"
#include "nok_ltp_enc.h"

#ifdef __cplusplus
extern "C" {
#endif

int sam_encode_frame(
		int id,
		int common_window,
		WINDOW_TYPE block_type,
		Window_shape	window_shape,
		int swb_offset[],
		int num_window_groups,
		int window_group_length[],
		int	quant[][1024],
		int	scfacs[][112],
		BsBitStream *fixed_stream,
		BsBitBuffer **gcBitBuf,
		int i_ch,
		int w_flag,
		int avr_bits);

int sam_encode_data(int common_window,
		int	windowSequence[],
		int scaleFactors[][112],
		int groupInfo[][8],
		int quant[][1024],
		int maxSfb[],
		int swb_offset[][112],
		int	stereo_mode,
		int	stereo_info[],
		int	ubits,
		int abits,
		int i_ch,
		int nch,
		int w_flag);

int sam_i2cb(int ch, int i);

int sam_encode_bsac(int common_window,
	int	windowSequence[],
	int	sample[][1024],
	int	band_snf[][200],
	int	scalefactors[][112],
	int	maxSfb[],
	int	num_window_group[],
	int	swb_offset[][112],
	int	which_model[][200],
	int	stereo_mode,
	int	stereo_info[],
	int ubits,
	int abits,
	int i_ch,
	int nch,
	int wflag);

void sam_start_encoding(int ubits, int tbits);

int sam_encode_symbol(
	int symbol,
	int armodel[],
	double *est_len,
	int wflag);

int sam_done_encoding(int wflag);

void sam_init_bs(void);
int sam_putbits2bs(int val, int N);
void sam_frame_length_rewrite2bs(int framesize, int pos, int len);
void sam_bsflush(BsBitStream *fixed_steam, int len);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef	_sam_enc_h_ */
