/*
This software module was originally developed by
Naoya Tanaka (Matsushita Communication Industrial Co., Ltd.)
and edited by
Toshiyuki Nomura (NEC Corporation)
in the course of development of the
MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.
This software module is an implementation of a part of one or more
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio
standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards
free license to this software module or modifications thereof for use in
hardware or software products claiming conformance to the MPEG-2 NBC/
MPEG-4 Audio  standards. Those intending to use this software module in
hardware or software products are advised that this use may infringe
existing patents. The original developer of this software module and
his/her company, the subsequent editors and their companies, and ISO/IEC
have no liability for use of this software module or modifications
thereof in an implementation. Copyright is not released for non
MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer
retains full right to use the code for his/her  own purpose, assign or
donate the code to a third party and to inhibit third party from using
the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.
This copyright notice must be included in all copies or derivative works.
Copyright (c)1996.
*/
/*----------------------------------------------------------------------*
 *    MPEG-4 Audio Verification Model (VM)                              * 
 *                                                                      *
 *	LPC-abs based coder                                             *
 * 	  Module: nec_abs_bitstream.c                                   *
 *                                                                      *
 *  Last modified: Dec. 16, 1996                                        *
 *----------------------------------------------------------------------*/
#include	<stdio.h>
#include	<stdlib.h>
/* #include	"libtsp.h" */ 	 /* HP 971117 */

#include	"nec_abs_proto.h"

void pan_nec_abs_bitstream_mux(
			   long signal_mode,		/* input */
			   long frame_bit_allocation[],	/* input */
			   long lpc_indices[],		/* input */
			   long num_lpc_indices,	/* input */
			   long rms_index,		/* input */
			   long shape_indices[],	/* input */
			   long gain_indices[],		/* input */
			   long num_shape_cbks,		/* input */
			   long num_gain_cbks,		/* input */
			   long n_subframes,		/* input */
			   long n_enhstages,		/* input */
			   BITSTREAM *p_bitstream	/* output */
			   )
{
   long		i, j, k, l, m, n;
   short	*cod;
   
   /* Memory allocation */
   if((cod=(short *)calloc (p_bitstream->buffer_length*8, sizeof(short)))==NULL) {
      printf("\n Memory allocation error in nec_abs_bitstream_mux\n");
      exit(1);
   }

   j = l = 0;
   /* Coding mode */
   for(i=0;i<frame_bit_allocation[l];i++) cod[j++] = (signal_mode>>i)&0x1;
   l++;
   /* LPC */
   for(k=0;k<num_lpc_indices;k++) {
      for(i=0;i<frame_bit_allocation[l];i++)
	 cod[j++] = (lpc_indices[k]>>i)&0x1;
      l++;
   }
   /* RMS */
   for(i=0;i<frame_bit_allocation[l];i++) cod[j++] = (rms_index>>i)&0x1;
   l++;
   /* Excitation(Shape & Gain ) */
   for(n=0;n<=n_enhstages;n++) {
      for(k=0;k<n_subframes;k++) {
	 for ( m = 0; m < num_shape_cbks; m++ ) {
	    for(i=0;i<frame_bit_allocation[l];i++)
	       cod[j++] = (shape_indices[(n*n_subframes+k)*num_shape_cbks+m]>>i)&0x1;
	    l++;
	 }
	 for ( m = 0; m < num_gain_cbks; m++ ) {
	    for(i=0;i<frame_bit_allocation[l];i++)
	       cod[j++] = (gain_indices[(n*n_subframes+k)*num_gain_cbks+m]>>i)&0x1;
	    l++;
	 }
      }
   }

   /* pad bits */
   while(j<p_bitstream->valid_bits) cod[j++] = 0;

   /* pad bits */
   while(j<p_bitstream->buffer_length*8) cod[j++] = 0;
   
   for(i=0;i<p_bitstream->buffer_length;i++) {
      *(p_bitstream->p_bitstream_buffer_start+i) = 0;
      for(k=0;k<8;k++) {
	 *(p_bitstream->p_bitstream_buffer_start+i) 
	    = (*(p_bitstream->p_bitstream_buffer_start+i)<<1)|cod[i*8+k];
      }
   }
   
   free(cod);
}
      
void pan_nec_abs_bitstream_demux(
			     BITSTREAM *p_bitstream,	/* intput */
			     long *signal_mode,		/* output */
			     long frame_bit_allocation[],/* input */
			     long lpc_indices[],	/* output */
			     long num_lpc_indices,	/* input */
			     long *rms_index,		/* output */
			     long shape_indices[],	/* output */
			     long gain_indices[],	/* output */
			     long num_shape_cbks,	/* input */
			     long num_gain_cbks,	/* input */
			     long n_subframes,		/* input */
			     long d_enhstages		/* input */
			     )
{
   long   i, j, k, l, m, n;
   short	*cod;

   /* Memory allocation */
   if((cod=(short *)calloc (p_bitstream->buffer_length*8, sizeof(short)))==NULL) {
      printf("\n Memory allocation error in nec_abs_bitstream_demux\n");
      exit(1);
   }

   j = 0;
   for(i=0;i<p_bitstream->buffer_length;i++) {
      for(k=8-1;k>=0;k--)
	 cod[j++] = ((*(p_bitstream->p_bitstream_buffer_start+i))>>k)&0x1;
   }

   j = l = 0;
   /* Coding mode */
   *signal_mode = 0;
   for(i=0;i<frame_bit_allocation[l];i++)
      *signal_mode |= (long)(cod[j++]&0x1)<<i;
   l++;
   /* LPC */
   for(k=0;k<num_lpc_indices;k++) {
      lpc_indices[k] = 0;
      for(i=0;i<frame_bit_allocation[l];i++)
	 lpc_indices[k] |= (long)(cod[j++]&0x1)<<i;
      l++;
   }
   /* RMS */
   *rms_index = 0;
   for(i=0;i<frame_bit_allocation[l];i++)
      *rms_index |= (long)(cod[j++]&0x1)<<i;
   l++;
   /* Excitation(Shape & Gain ) */
   for(n=0;n<=d_enhstages;n++) {
      for(k=0;k<n_subframes;k++) {
	 /* Shape */
	 for ( m = 0; m < num_shape_cbks; m++ ) {
	    shape_indices[(n*n_subframes+k)*num_shape_cbks+m] = 0;
	    for(i=0;i<frame_bit_allocation[l];i++)
	       shape_indices[(n*n_subframes+k)*num_shape_cbks+m] |= (long)(cod[j++]&0x1)<<i;
	    l++;
	 }
	 /* Gain */
	 for ( m = 0; m < num_gain_cbks; m++ ) {
	    gain_indices[(n*n_subframes+k)*num_gain_cbks+m] = 0;
	    for(i=0;i<frame_bit_allocation[l];i++)
	       gain_indices[(n*n_subframes+k)*num_gain_cbks+m] |= (long)(cod[j++]&0x1)<<i;
	    l++;
	 }
      }
   }
   free(cod);
}
