/**********************************************************************
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: encode.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
 *
 * $Log: encode.c,v $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
 **********************************************************************/

/**********************************************************************
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
 *   date   programmers         comment                               *
 * 3/01/91  Douglas Wong,       start of version 1.1 records          *
 *          Davis Pan                                                 *
 * 3/06/91  Douglas Wong        rename: setup.h to endef.h            *
 *                                      efilter to enfilter           *
 *                                      ewindow to enwindow           *
 *                              integrated "quantizer", "scalefactor",*
 *                              and "transmission" files              *
 *                              update routine "window_subband"       *
 * 3/31/91  Bill Aspromonte     replaced read_filter by               *
 *                              create_an_filter                      *
 * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         *
 *                              Incorporated Jean-Georges Fritsch's   *
 *                              "bitstream.c" package.                *
 *                              Incorporated Bill Aspromonte's        *
 *                              filterbank coefficient matrix         *
 *                              calculation routines and added        *
 *                              roundoff to coincide with specs.      *
 *                              Modified to strictly adhere to        *
 *                              encoded bitstream specs, including    *
 *                              "Berlin changes".                     *
 *                              Modified PCM sound file handling to   *
 *                              process all incoming samples and fill *
 *                              out last encoded frame with zeros     *
 *                              (silence) if needed.                  *
 *                              Located and fixed numerous software   *
 *                              bugs and table data errors.           *
 * 19jun91  dpwe (Aware)        moved "alloc_*" reader to common.c    *
 *                              Globals sblimit, alloc replaced by new*
 *                              struct 'frame_params' passed as arg.  *
 *                              Added JOINT STEREO coding, layers I,II*
 *                              Affects: *_bit_allocation,            *
 *                              subband_quantization, encode_bit_alloc*
 *                              sample_encoding                       *
 * 6/10/91  Earle Jennings      modified II_subband_quantization to   *
 *                              resolve type cast problem for MS_DOS  *
 * 6/11/91  Earle Jennings      modified to avoid overflow on MS_DOS  *
 *                              in routine filter_subband             *
 * 7/10/91  Earle Jennings      port to MsDos from MacIntosh version  *
 * 8/ 8/91  Jens Spille         Change for MS-C6.00                   *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced function encode_CRC  *
 *11/ 8/91  Kathy Wang          Documentation of code                 *
 *                              All variablenames are referred to     *
 *                              with surrounding pound (#) signs      *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 * 92-08-11 Soren H. Nielsen    Fixed bug: allocation of space in the *
 *                              bitstream for the CRC-word. Fixed     *
 *                              reading of window from file.          *
 * 92-11-06 Soren H. Nielsen	Fixed scalefactor calculation.        *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *  8/10/93        changed matricing to 7 channels                    *
 *	           added void matricing_fft                           *
 *  8/12/93        added int required_bits,                           *
 *                       int max_alloc                                *
 *                 implemented the new mc_header (third working draft)*
 *  8/13/93        added channel-switching in required_bits and       *
 *                 II_subband_quantisation, II_encode_scale,          *
 *                 II_encode_bit_alloc, II_encode_sample,             *
 *                 encode_info                                        *
 *                 all channels normalized                            *
 *  9/20/93        channel-switching is only performed at a           *
 *                 certain limit of TC_ALLOC dB, which is included    *
 *                 in encoder.h                                       *
 *  1/04/94        get out some rubbish                               *
 *                                                                    *
 * 01/05/94        implemented the Committee Draft header             *
 *                                                                    *
 * 01/12/94        changed matricing procedure according to           *
 *                 Committee Draft                                    *
 *                                                                    *
 *  Version 1.0 Shareware                                             *
 *                                                                    *
 *  07/12/94       Susanne Ritscher,  IRT Munich                      *
 *                 Tel: +49 89 32399 458                              *
 *                 Fax: +49 89 32399 415                              *
 *                                                                    *
 *  Version 1.1 Shareware                                             *
 *                                                                    *
 *  02/23/95	   Susanne Ritscher,  IRT Munich                      *
 *                 corrected some bugs                                *
 *                 extension bitstream is working                     *
 *                                                                    *
 **********************************************************************/
#define VERY_FAST_FILTER  1	/* JMZ 08/03/1995 FILTER */


#include "common.h"
#include "encoder.h"
 
/*=======================================================================\
|                                                                       |
| This segment contains all the core routines of the encoder,           |
| except for the psychoacoustic models.                                 |
|                                                                       |
| The user can select either one of the two psychoacoustic              |
| models. Model I is a simple tonal and noise masking threshold         |
| generator, and Model II is a more sophisticated cochlear masking      |
| threshold generator. Model I is recommended for lower complexity      |
| applications whereas Model II gives better subjective quality at low  |
| bit rates.                                                            |
|                                                                       |
| Layers I and II of mono, stereo, and joint stereo modes are supported.|
| Routines associated with a given layer are prefixed by "I_" for layer |
| 1 and "II_" for layer 2.                                              |
\=======================================================================*/
 
/************************************************************************/
/*
/* read_samples()
/*
/* PURPOSE:  reads the PCM samples from a file to the buffer
/*
/*  SEMANTICS:
/* Reads #samples_read# number of shorts from #musicin# filepointer
/* into #sample_buffer[]#.  Returns the number of samples read.
/*
/************************************************************************/

unsigned long read_samples(FILE *musicin, long int *sample_buffer, long unsigned int num_samples, long unsigned int frame_size, int *byte_per_sample, int *aiff)
{
unsigned long samples_read;
static unsigned long samples_to_read;
static char init = TRUE;
short pcm_sample_buffer[5760];        /*for correct reading of pcm-data*/
int i;

   if (init) {
        samples_to_read = num_samples;
        init = FALSE;
   }
   if (samples_to_read >= frame_size)
        samples_read = frame_size;
   else
		  samples_read = samples_to_read;

	if((*aiff==1) &&(*byte_per_sample !=2)){
	 
            if ((samples_read =
		  fread(sample_buffer, *byte_per_sample, (int)samples_read, musicin)) == 0)
		  printf("Hit end of audio data\n");
	   
	}
	else{
	 if ((samples_read =
		  fread(pcm_sample_buffer, sizeof(short), (int)samples_read, musicin)) == 0)
		  printf("Hit end of audio data\n");
            for(i = 0; i < 5760; ++i) sample_buffer[i] = pcm_sample_buffer[i];
        }

   samples_to_read -= samples_read;
   if (samples_read < frame_size && samples_read > 0) {
        printf("Insufficient PCM input for one frame - fillout with zeros\n");
        for (; samples_read < frame_size; sample_buffer[samples_read++] = 0);
        samples_to_read = 0;
   }
   return(samples_read);
}

/************************************************************************/
/*
/* get_audio()
/*
/* PURPOSE:  reads a frame of audio data from a file to the buffer,
/*   aligns the data for future processing, and separates the
/*   left and right channels
/*
/*  SEMANTICS:
/* Calls read_samples() to read a frame of audio data from filepointer
/* #musicin# to #insampl[]#.  The data is shifted to make sure the data
/* is centered for the 1024pt window to be used by the psychoacoustic model,
/* and to compensate for the 256 sample delay from the filter bank. For
/* stereo, the channels are also demultiplexed into #buffer[0][]# and
/* #buffer[1][]#
/*
/* 21/03/1995 JMZ Multimode adaptations
/************************************************************************/
 
unsigned long
get_audio(
	FILE *musicin,
	double (*buffer)[1152],
	long unsigned int num_samples,
	int stereo,
	IFF_AIFF *aiff_ptr,
	int stereomc,
	frame_params *fr_ps,
	int *aiff,
	int *byte_per_sample,
	double (*buffer_matr)[1152]
) {
	int j, i;
	long insamp[5760];
	unsigned long samples_read;
	int lay;
	layer *info = fr_ps->header;
	
	lay = info->lay;
 
if (lay == 1)
	{
	if(stereo == 2)
		{ /* layer 1, stereo */
		samples_read = read_samples(musicin, insamp, num_samples,
			(unsigned long) 768, byte_per_sample, aiff);
		for(j=0;j<448;j++) 
			{
			if(j<64) 
				{
				buffer[0][j] = buffer[0][j+384];
				buffer[1][j] = buffer[1][j+384];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			else 
				{
				buffer[0][j] = insamp[2*j-128];
				buffer[1][j] = insamp[2*j-127];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		}
	else 
		{ /* layer 1, mono */
		samples_read = read_samples(musicin, insamp, num_samples,
			(unsigned long) 384, byte_per_sample, aiff);
		for(j=0;j<448;j++)
			{
			if(j<64) 
				{
				buffer[0][j] = buffer[0][j+384];
				buffer[1][j] = 0;
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			else 
				{
				buffer[0][j] = insamp[j-64];
				buffer[1][j] = 0;
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		}
	}
else 
	{
	if( *aiff == 1)
		{
		if(((stereo + stereomc) == 5) && (aiff_ptr->numChannels == 5))
			{
			info->center = 1;
			info->surround = 2;
                        
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 5760, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[5*j];
				buffer[1][j] = insamp[5*j+1];
				buffer[2][j] = insamp[5*j+2];
				buffer[3][j] = insamp[5*j+3];
				buffer[4][j] = insamp[5*j+4];
				}
			
			matricing_fft(buffer, buffer_matr, fr_ps);
			}
		else if(( stereo == 0) && ( aiff_ptr->numChannels == 5))
			{

			info->center = 1;
			info->surround = 2;
                        
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 5760,byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = 0;
				buffer[1][j] = 0;
				buffer[2][j] = insamp[5*j+2];
				buffer[3][j] = insamp[5*j+3];
				buffer[4][j] = insamp[5*j+4];
				}
			}
		else if(( stereomc == 0) && ( aiff_ptr->numChannels == 5))
			{

			info->center = 0;
			info->surround = 0;
                        
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 5760, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[5*j];
				buffer[1][j] = insamp[5*j+1];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		else if(aiff_ptr->numChannels == 4)
			{

			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152*4, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[4*j];
				buffer[1][j] = insamp[4*j+1];
				buffer[2][j] = insamp[4*j+2];
				buffer[3][j] = insamp[4*j+3];
				buffer[4][j] = 0;
				}
			}
		else if(aiff_ptr->numChannels == 3)
			{

			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152*3, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[3*j];
				buffer[1][j] = insamp[3*j+1];
				buffer[2][j] = insamp[3*j+2];
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		else if(aiff_ptr->numChannels == 2)
			{

			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152*2, byte_per_sample, aiff);
			for(j=0; j<1152; j++) 
				{
				buffer[0][j] = insamp[2*j];
				buffer[1][j] = insamp[2*j+1];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}
		}
	else 
		{  /* layerII, stereo */
		if( stereo == 2)
			{
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 2304, byte_per_sample, aiff);
			for( j = 0; j < 1152; j++)
				{ /* fixed bug 28.6.93 S.R. */
				buffer[0][j] = insamp[2*j];
				buffer[1][j] = insamp[2*j+1];
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}
			}

		else
			{ /* layer 2 (or 3), mono */
			samples_read = read_samples(musicin, insamp, num_samples,
				(unsigned long) 1152, byte_per_sample, aiff);
			for(j=0;j<1152;j++)
				{
				buffer[0][j] = insamp[j];
				buffer[1][j] = 0;
				buffer[2][j] = 0;
				buffer[3][j] = 0;
				buffer[4][j] = 0;
				}        
			}
		}
	}
return(samples_read);
}

/*************************************************************************
/*
/* matricing()
/*
/* The five-channel signal must be matricied to guarantee
/* the compatibility to the stereo-decoder.
/* There must be something of the surround information in the
/* two front channels. In a five-channel decoder there will
/* be a dematricing.
/* There must be 7 channels for channel switching 8/10/93, SR
/* 
/* Channel 5 and 6 are the not matriced signals L and R
/*                                                                         */
/***************************************************************************/

void matricing_old(double (*sb_sample)[3][12][32], frame_params *fr_ps)
                                     	/* 08/03/1995 JMZ Multilingual */
                    

{
  double matr1;   /* factor for center */
  double matr2;   /* factor for surrounds */
  double matr3;   /* factor for surrounds */
  int i, j, k, l;
  
  layer *info = fr_ps->header;
  switch(info->matrix)
  {
      /* Changed the factors according to Draft International Standard   */
      
      case 0: matr1 = 0.411865234375;        /* normalizing */
	      matr2 = 0.7060546875;          /* matricing   */
	      break;
      case 1: matr1 = 1/(1.5 + 0.5*sqrt(2)); /* normalizing */
              matr2 = 0.7060546875;          /* matricing C */ 
	      matr3 = 0.5;                   /* matricing Ls, Rs */
	      break;
      case 2: matr1 = 0.411865234375;  
	      matr2 = 0.7060546875;
 	      printf("NOT DONE YET!!!\n");
	      exit(0);
	      break;
      case 3: matr1 = 1.0;
              matr2 = 1.0;
	      break;
  }


	for( j = 0; j < 3; ++j)
	{
	    for(l = 0; l < 12; l ++)
	    {
		for(k = 0; k < SBLIMIT; k ++)
		{
	 	 sb_sample[5][j][l][k] =  sb_sample[0][j][l][k] * matr1;
		 sb_sample[6][j][l][k] =  sb_sample[1][j][l][k] * matr1;
		
		 sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matr1 * matr2; 
		 
		 if(info->matrix != 1)
		 {
		    sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matr1 * matr2; 
		    sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr2; 
		 }
		 else
		 {
		    sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matr1 * matr3; 
		    sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr3; 
		 }
		
		 if(info->matrix == 0 || info->matrix == 1)
		 {
		    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];
		    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[4][j][l][k];
		 }   
		}
	    }
	}
 }
 
 /*******************************************************************/
 /* JMZ 08/03/1995 MULTILINGUAL */
 
void matricing(double (*sb_sample)[3][12][32], frame_params *fr_ps)
                                      /* 24/02/1995 JMZ Multilingual */
                    

{
  double matr1;   /* factor for normalizing JMZ */
  double matr2;   /* factor for center JMZ */
  double matr3;   /* factor for surrounds */
  int i, j, k, l, n_ml_ch;
  
  layer *info = fr_ps->header;
  n_ml_ch = info->multiling_ch;

  switch(info->matrix)
  {
      /* Changed the factors according to Committee Draft and Telefax */
      /* 10/20/93 by E. Schroeder, DTB Hannover                       */
      
	case 0: matr1 = 0.411865234375;	/* normalizing */
	      matr2 = 0.7060546875;	/* matricing   C*/
	      matr3 = matr2;          	/* matricing   Ls, Rs JMZ*/
	      break;
	case 1: matr1 = 1/(1.5 + 0.5*sqrt(2)); /* normalizing */
              matr2 = 0.7060546875;          /* matricing C */ 
	      matr3 = 0.5;                   /* matricing Ls, Rs */
	      break;
	case 2: matr1 = 0.411865234375;  
		matr2 = 0.7060546875;
		matr3 = matr2;		/* matricing   Ls, Rs JMZ*/
		printf("NOT DONE YET!!!\n");
		exit(0);
		break;
	case 3: matr1 = 1.0;
              matr2 = 1.0;
	      matr3 = matr2;          	/* matricing   Ls, Rs JMZ*/
	      break;
  }


for( j = 0; j < 3; ++j)
{
	for(l = 0; l < 12; l ++)
	{
		for(k = 0; k < SBLIMIT; k ++)
		{
			sb_sample[5][j][l][k] =  sb_sample[0][j][l][k] * matr1;
			sb_sample[6][j][l][k] =  sb_sample[1][j][l][k] * matr1;
		
			sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matr1 * matr2;
			sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matr1 * matr3; 
			sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matr1 * matr3; 
		 	if(info->matrix == 0 || info->matrix == 1)
			{
				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];
				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[4][j][l][k];
			}
			if (n_ml_ch > 0)
			{
			sb_sample[7][j][l][k] =  sb_sample[7][j][l][k] * matr1;
			sb_sample[8][j][l][k] =  sb_sample[8][j][l][k] * matr1;
			sb_sample[9][j][l][k] =  sb_sample[9][j][l][k] * matr1;
			sb_sample[10][j][l][k] =  sb_sample[10][j][l][k] * matr1;
			sb_sample[11][j][l][k] =  sb_sample[11][j][l][k] * matr1;
			sb_sample[12][j][l][k] =  sb_sample[12][j][l][k] * matr1;
			sb_sample[13][j][l][k] =  sb_sample[13][j][l][k] * matr1;
		/* Remplacer et mettre un for (i=0; i<n_ml_ch;...)*/
		/* sb_sample[7+i][j][l][k] =  sb_sample[7+i][j][l][k] * matr1;*/
			}
		}
	}
}
}
 /* JMZ 08/03/1995 MULTILINGUAL */
 /*******************************************************************/


/*************************************************************************
/*
/* matricing_fft()
/*
/* To get the best results in psychoacoustics there must be both,
/* the matriced and the not matriced signal. This matricing
/* may be in full bandwith.
/* 8/10/93 SR
/* Channel 5 and 6 are the not matriced signals L and R
/*                                                                         */
/***************************************************************************/

void
matricing_fft(
	double (*buffer)[1152],
	double (*buffer_matr)[1152],
	frame_params *fr_ps
) {
  double matr1;   /* factor for normalizing */
  double matr2;   /* factor for matricing   */
  double matr3;   /* factor for matricing   */
  int i, j, k, l;
  double dummy;
  
  layer *info = fr_ps->header;
  switch(info->matrix)
  {
	/* factors according to Draft International Standard */
      case 0: matr1 = 0.411865234375;     /* normalizing factor */
	      matr2 = 0.7060546875;       /* matricing factor   */
	      break;
      case 1: matr1 = 1/(1 + sqrt(2));    /* normalizing factor */
	      matr2 = 0.7060546875;       /* matricing C        */
	      matr3 = 0.5;                /* matricing Ls, Rs   */
	      break;
      case 2: matr1 = 0.411865234375;     /* normalizing factor */
	      matr2 = 0.7060546875;       /* matricing factor   */
	      printf(" NOT DONE YET !\n");
              exit(0);
	      break;
      case 3: matr1 = 1.0;
              matr2 = matr1;
	      break;
  }

/* no normalizing until now!!!! 01/14/94, SR */
   for(i = 0; i < 1152; ++i)
   {
     buffer_matr[5][i] = buffer[0][i];
     buffer_matr[6][i] = buffer[1][i];
     buffer_matr[2][i] = buffer[2][i];
     buffer_matr[3][i] = buffer[3][i];
     buffer_matr[4][i] = buffer[4][i];
     
    if(info->matrix != 3)
    {
     if(info->matrix != 1)
     {
        buffer_matr[0][i] = buffer[0][i] + matr2*buffer[2][i] + matr2*buffer[3][i];
	buffer_matr[1][i] = buffer[1][i] + matr2*buffer[2][i] + matr2*buffer[4][i];
     }
     else
     {
	buffer_matr[0][i] = buffer[0][i] + matr2*buffer[2][i] + matr3*buffer[3][i];
	buffer_matr[1][i] = buffer[1][i] + matr2*buffer[2][i] + matr3*buffer[4][i];
     }
    } 
    else
    {
	buffer_matr[0][i] = buffer[0][i];
	buffer_matr[1][i] = buffer[1][i]; 
    }	
   }
        
 }




 
/************************************************************************/
/*
/* read_ana_window()
/*
/* PURPOSE:  Reads encoder window file "enwindow" into array #ana_win#
/*
/************************************************************************/
 
void read_ana_window(double *ana_win)
       /*far*/                   
{
    int i,j[4];
    FILE *fp;
    double f[4];
    char t[150];
 
    if (!(fp = OpenTableFile("enwindow") ) ) {
       printf("Please check analysis window table 'enwindow'\n");
       exit(1);
    }
    for (i=0;i<512;i+=4) {
       fgets(t, 80, fp); /* changed from 150, 92-08-11 shn */
       sscanf(t,"C[%d] = %lf C[%d] = %lf C[%d] = %lf C[%d] = %lf\n",
              j, f,j+1,f+1,j+2,f+2,j+3,f+3);
       if (i==j[0]) {
          ana_win[i] = f[0];
          ana_win[i+1] = f[1];
          ana_win[i+2] = f[2];
          ana_win[i+3] = f[3];
       }
       else {
          printf("Check index in analysis window table\n");
          exit(1);
       }
       fgets(t,80,fp); /* changed from 150, 92-08-11 shn */
    }
    fclose(fp);
}

/************************************************************************/
/*
/* window_subband()
/*
/* PURPOSE:  Overlapping window on PCM samples
/*
/* SEMANTICS:
/* 32 16-bit pcm samples are scaled to fractional 2's complement and
/* concatenated to the end of the window buffer #x#. The updated window
/* buffer #x# is then windowed by the analysis window #c# to produce the
/* windowed sample #z#
/*
/************************************************************************/
 
void
window_subband(
	double **buffer,
	double *z,
	int k
) {
typedef double XX[14][HAN_SIZE];	/* 08/03/1995 JMZ Multilingual */
static XX *x;
int i, j;
static off[14]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0};/* 08/03/1995 JMZ Multilingual */
static char init = 0;
static double *c;
 
   if (!init) {
      c = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "window");
      read_ana_window(c);
      x = (XX *) mem_alloc(sizeof(XX),"x");
      for (i = 0; i < 5; i++)
         for (j = 0; j < HAN_SIZE; j++)
               (*x)[i][j] = 0;
      init = 1;
   }
 
   for (i=0;i<32;i++) (*x)[k][31-i+off[k]] = (double) *(*buffer)++/SCALE;
   for (i=0;i<HAN_SIZE;i++) z[i] = (*x)[k][(i+off[k])&HAN_SIZE-1] * c[i];
   off[k] += 480; /*offset is modulo (HAN_SIZE-1)*/
   off[k] &= HAN_SIZE-1;

}
 
/************************************************************************/
/*
/* create_ana_filter()
/*
/* PURPOSE:  Calculates the analysis filter bank coefficients
/*
/* SEMANTICS:
/* Calculates the analysis filterbank coefficients and rounds to the
/* 9th decimal place accuracy of the filterbank tables in the ISO
/* document.  The coefficients are stored in #filter#
/*
/************************************************************************/
 
void create_ana_filter(double (*filter)[64])
       /*far*/                     
{
   register int i,k;
 
   for (i = 0; i < 32; i++)
      for (k = 0; k < 64; k++) {
          if ((filter[i][k] = 1e9*cos((double)((2*i+1)*(16-k)*PI64))) >= 0)
             modf(filter[i][k]+0.5, &filter[i][k]);
          else
             modf(filter[i][k]-0.5, &filter[i][k]);
          filter[i][k] *= 1e-9;
   }
}

/************************************************************************/
/*
/* filter_subband()
/*
/* PURPOSE:  Calculates the analysis filter bank coefficients
/*
/* SEMANTICS:
/*      The windowed samples #z# is filtered by the digital filter matrix #m#
/* to produce the subband samples #s#. This done by first selectively
/* picking out values from the windowed samples, and then multiplying
/* them by the filter matrix, producing 32 subband samples.
/*
/************************************************************************/
 
void filter_subband_old(double *z, double *s)
       /*far*/                         
{
   double y[64];
   int i,j, k;
static char init = 0;
   typedef double MM[SBLIMIT][64];
static MM /*far*/ *m;
   double sum1, sum2;
   
#ifdef MS_DOS
   long    SIZE_OF_MM;
   SIZE_OF_MM      = SBLIMIT*64;
   SIZE_OF_MM      *= 8;
   if (!init) {
       m = (MM /*far*/ *) mem_alloc(SIZE_OF_MM, "filter");
       create_ana_filter(*m);
       init = 1;
   }
#else
   if (!init) {
       m = (MM /*far*/ *) mem_alloc(sizeof(MM), "filter");
       create_ana_filter(*m);
       init = 1;
   }
#endif
   /* Window */
   for (i=0; i<64; i++)
   {
      for (k=0, sum1 = 0.0; k<8; k++)
         sum1 += z[i+64*k];
      y[i] = sum1;
   }

   /* Filter */
   for (i=0;i<SBLIMIT;i++)
   {
       for (k=0, sum1=0.0 ;k<64;k++)
          sum1 += (*m)[i][k] * y[k];
       s[i] = sum1;
   }

/*   for (i=0;i<64;i++) for (j=0, y[i] = 0;j<8;j++) y[i] += z[i+64*j];*/
/*   for (i=0;i<SBLIMIT;i++)*/
/*       for (j=0, s[i]= 0;j<64;j++) s[i] += (*m)[i][j] * y[j];*/

}

/************************************************************************/
/* JMZ 08/03/1995 FILTER */

void filter_subband(double *z, double *s)
       /*far*/                         
{
   double y[64];
   int i,j, k;
static char init = 0;
   typedef double MM[SBLIMIT][64];
static MM /*far*/ *m;
   double sum1, sum2;
  
   if (!init) {
       m = (MM /*far*/ *) mem_alloc(sizeof(MM), "filter");
       create_ana_filter(*m);
       init = 1;
   }
   /* Window */
   for (i=0; i<64; i++)
   {
      for (k=0, sum1 = 0.0; k<8; k++)
         sum1 += z[i+64*k];
      y[i] = sum1;
   }

   /* Filter */
#if VERY_FAST_FILTER 
   for (i=0; i<SBLIMIT/2; i++)
   {
       for (k=0, sum1=0.0, sum2=0.0; k<16;)
       {
	sum1 += (*m)[i][k] * (y[k]+y[32-k]); 
	sum2 += (*m)[i][k+1] * (y[k+1]+y[31-k]); 
	sum2 += (*m)[i][k+33] * (y[k+33]-y[63-k]); 
	sum1 += (*m)[i][k+34] * (y[k+34]-y[62-k]); 
	k+=2;
       }
	sum1 += (*m)[i][16]*y[16] - (*m)[i][48]*y[48]; 

	s[i]    = sum1 + sum2;
	s[31-i] = sum1 - sum2;
   }
#else
   for (i=0;i<SBLIMIT;i++)
   {
       for (k=0, sum1=0.0 ;k<64;k++)
          sum1 += (*m)[i][k] * y[k];
       s[i] = sum1;
   }
#endif VERY_FAST_FILTER
}

/* JMZ 08/03/1995 FILTER */
/************************************************************************/

/************************************************************************/
/*
/* encode_info()
/* encode_infomc1() SR
/* encode_infomc2() SR
/*
/* PURPOSE:  Puts the syncword and header information on the output
/* bitstream.
/*
/************************************************************************/
 
void encode_info(frame_params *fr_ps, Bit_stream_struc *bs)
{
        layer *info = fr_ps->header;
 
        putbits(bs,0xfff,12);                    /* syncword 12 bits */
        put1bit(bs,info->version);               /* ID        1 bit  */
        putbits(bs,4-info->lay,2);               /* layer     2 bits */
        put1bit(bs,!info->error_protection);     /* bit set => no err prot */
        putbits(bs,info->bitrate_index,4);
        putbits(bs,info->sampling_frequency,2);
        put1bit(bs,info->padding);
        put1bit(bs,info->extension);             /* private_bit */
        putbits(bs,info->mode,2);
        putbits(bs,info->mode_ext,2);
        put1bit(bs,info->copyright);
        put1bit(bs,info->original);
        putbits(bs,info->emphasis,2);
}


void encode_infomc1(frame_params *fr_ps, Bit_stream_struc *bs)
{
        
        layer *info = fr_ps->header;
	
        
 
		  put1bit(bs,info->ext_bit_stream_present);
		  if(info->ext_bit_stream_present == 1) 
		    putbits(bs,info->n_ad_bytes, 8); 
		  putbits(bs,info->center, 2); 
		  putbits(bs,info->surround, 2);
		  put1bit(bs,info->lfe);
		  put1bit(bs,info->audio_mix);
		  putbits(bs,info->matrix, 2);
		  putbits(bs,info->multiling_ch, 3);
		  put1bit(bs,info->multiling_fs);
		  put1bit(bs,info->multiling_lay);
		  put1bit(bs,info->copy_ident_bit);
		  put1bit(bs,info->copy_ident_start);
}



void encode_infomc2(frame_params *fr_ps, Bit_stream_struc *bs)
{
    layer *info = fr_ps->header;
    int i, j;       
    
    
		  
		  put1bit(bs, info->tc_sbgr_select);
		  put1bit(bs, info->dyn_cross_on);
		  put1bit(bs, info->mc_prediction_on);
		  if(info->tc_sbgr_select == 1)
		    putbits(bs, info->tc_allocation, 3);
		  else
		  {
		    for(i = 0; i < 12; i++)
		         putbits(bs, info->tc_alloc[i], 3);
		  }

		  if(info->dyn_cross_on == 1)
		  {
		    fprintf(stderr, "WARNING! Not done yet Dynamic Crosstalk!!!\n");
		    put1bit(bs, info->dyn_cross_LR);
		    for(i = 0; i < 12; i++)
		    {
		        putbits(bs, info->dyn_cross[i], 4);
			if(info->surround == 3)
			    put1bit(bs, info->dyn_second_stereo[i]);
		    }	    
		  }

                  if(info->mc_prediction_on == 1)
		  {
		    fprintf(stderr, "WARNING! Not done yet Prediction!!!\n");
		     for(i = 0; i < 8; i++)
         	     {
			put1bit(bs, info->mc_pred[i]);  
			if(info->mc_pred[i] == 1)
			{
		         for(j = 0; j < n_pred_coef[info->dyn_cross[i]]; j++)
			    putbits(bs, info->predsi[i][j], 2);
			}
	             }  
		   }
}			  
    
void encode_infomc_ext1(frame_params *fr_ps, Bit_stream_struc *bs_ext)
{
        
        layer *info = fr_ps->header;
	
	    info->ext_sync = 0x7ff;
	    
		  putbits(bs_ext,info->ext_sync, 12); 
}

void encode_infomc_ext2(frame_params *fr_ps, Bit_stream_struc *bs_ext, unsigned int crc)
{
        
        layer *info = fr_ps->header;
	

		  putbits(bs_ext, crc, 16);
		  putbits(bs_ext,info->ext_length, 11);
		  put1bit(bs_ext,info->ext_bit);
}

    
 
/************************************************************************/
/*
/* mod()
/*
/* PURPOSE:  Returns the absolute value of its argument
/*
/************************************************************************/
 
double mod(double a)
{
    return (a > 0) ? a : -a;
}
 
/************************************************************************/
/*
/* I_combine_LR    (Layer I)
/* II_combine_LR	 (Layer II)
/*
/* PURPOSE:Combines left and right channels into a mono channel
/*
/* SEMANTICS:  The average of left and right subband samples is put into
/* #joint_sample#
/*
/* Layer I and II differ in frame length and # subbands used
/*
/************************************************************************/
 
void I_combine_LR(double (*sb_sample)[3][12][32], double (*joint_sample)[3][12][32])
       /*far*/                                       
       /*far*/                                          
{   /* make a filtered mono for joint stereo */
    int sb, smp;
 
   for(sb = 0; sb<SBLIMIT; ++sb)
      for(smp = 0; smp<SCALE_BLOCK; ++smp)
		  joint_sample[0][0][smp][sb] = .5 *
                    (sb_sample[0][0][smp][sb] + sb_sample[1][0][smp][sb]);
}
 
void II_combine_LR(double (*sb_sample)[3][12][32], double (*joint_sample)[3][12][32], int sblimit)
       /*far*/                                       
       /*far*/                                          
            
{  /* make a filtered mono for joint stereo */
   int sb, smp, sufr;
 
   for(sb = 0; sb<sblimit; ++sb)
      for(smp = 0; smp<SCALE_BLOCK; ++smp)
         for(sufr = 0; sufr<3; ++sufr)
		joint_sample[0][sufr][smp][sb] = .5 * (sb_sample[0][sufr][smp][sb]
                                          + sb_sample[1][sufr][smp][sb]);
}


/************************************************************************
/*
/* I_scale_factor_calc     (Layer I)
/* II_scale_factor_calc    (Layer II)
/*
/* PURPOSE:For each subband, calculate the scale factor for each set
/* of the 12 subband samples
/*
/* SEMANTICS:  Pick the scalefactor #multiple[]# just larger than the
/* absolute value of the peak subband sample of 12 samples,
/* and store the corresponding scalefactor index in #scalar#.
/*
/* Layer II has three sets of 12-subband samples for a given
/* subband.
/*
/************************************************************************/
 
void I_scale_factor_calc(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int stereo)
       /*far*/                                       
                                   
           
{
   int i,j, k;
   double s[SBLIMIT];
 
   for (k=0;k<stereo;k++) {
     for (i=0;i<SBLIMIT;i++)
       for (j=1, s[i] = mod(sb_sample[k][0][0][i]);j<SCALE_BLOCK;j++)
         if (mod(sb_sample[k][0][j][i]) > s[i])
            s[i] = mod(sb_sample[k][0][j][i]);
 
     for (i=0;i<SBLIMIT;i++)
       for (j=SCALE_RANGE-1,scalar[k][0][i]=0;j>=0;j--)
         if (s[i] < multiple[j]) { /* <= changed to <, 1992-11-06 shn */
            scalar[k][0][i] = j;
            break;
         }
   }
}

/******************************** Layer II ******************************/
 
void II_scale_factor_calc(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int l, int m)
                                              /* 08/03/1995 JMZ Multilingual */
                                    		/* 08/03/1995 JMZ Multilingual */
            
         
{
  int i,j, k,t;
  double s[SBLIMIT];
 
  for (k = l; k< m; k++) for (t=0;t<3;t++) 
  {
    for (i=0;i<sblimit;i++)
	for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<SCALE_BLOCK;j++)
		  if (mod(sb_sample[k][t][j][i]) > s[i])
			 s[i] = mod(sb_sample[k][t][j][i]);
 
    for (i=0;i<sblimit;i++)
        for (j=SCALE_RANGE-1,scalar[k][t][i]=0;j>=0;j--)
		if (s[i] < multiple[j]) 
		{                       /* <= changed to <, 1992-11-06 shn*/
                   scalar[k][t][i] = j;
                   break;
                }
        for (i=sblimit;i<SBLIMIT;i++) scalar[k][t][i] = SCALE_RANGE-1;
   }
} 

/***************************************************************************
/* void II_scale_factor_calc1(sb_sample, scalar, stereo, sblimit)
/*
/* in case of any joint stereo the scalefactor must be computed
/* a second time for the combind samples
/*
/***************************************************************************/

void II_scale_factor_calc1(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int dim)
       /*far*/                                       
                                   
            
        
{
  int i,j, k,t;
  double s[SBLIMIT];

	for (t=0;t<3;t++) {
	 for (i=0;i<sblimit;i++)
		for (j=1, s[i] = mod(sb_sample[dim][t][0][i]);j<SCALE_BLOCK;j++)
		  if (mod(sb_sample[dim][t][j][i]) > s[i])
				 s[i] = mod(sb_sample[dim][t][j][i]);

  for (i=0;i<sblimit;i++)
	 for (j=SCALE_RANGE-1,scalar[dim][t][i]=0;j>=0;j--)
		if (s[i] < multiple[j]) { /* <= changed to <, 1992-11-06 shn */
			scalar[dim][t][i] = j;
			break;
		}
		for (i=sblimit;i<SBLIMIT;i++) scalar[dim][t][i] = SCALE_RANGE-1;
	 }
}



/************************************************************************
/*
/* pick_scale  (Layer II)
/*
/* PURPOSE:For each subband, puts the smallest scalefactor of the 3
/* associated with a frame into #max_sc#.  This is used
/* used by Psychoacoustic Model I.
/* (I would recommend changin max_sc to min_sc)
/*
/************************************************************************/
 
void pick_scale(unsigned int (*scalar)[3][32], frame_params *fr_ps, double (*max_sc)[32], int cha_sw, int aiff)
                                    	/* 08/03/1995 JMZ Multilingual */
                    
       /*far*/                     		/* 08/03/1995 JMZ Multilingual */
           
         
{
  int i,j,k,l,m;
  int max;
  int stereo  = fr_ps->stereo;
  int stereomc = fr_ps->stereomc;
  int sblimit = fr_ps->sblimit;
  int n_ml_ch = fr_ps->header->multiling_ch; /* 08/03/1995 JMZ Multilingual */
 

  if(aiff != 1)
  {
     l = 0; m = 2;
  }
  else
  {   
     l = 0;
     m = 7;
  }

  for (k = l; k < m; k++)
    for (i=0;i<sblimit;max_sc[k][i] = multiple[max], i++)
      for (j=1, max = scalar[k][0][i];j<3;j++)
         if (max > scalar[k][j][i]) max = scalar[k][j][i];
  for (i=sblimit;i<SBLIMIT;i++) max_sc[0][i] = max_sc[1][i] = 1E-20;
  

 if(aiff == 1)
 {
  if((fr_ps->header->matrix == 3) || (cha_sw == 0))
        fr_ps->header->tc_sbgr_select = 1;
  else  tc_alloc(fr_ps, max_sc);
 }
/********************************************************/
/* JMZ 08/03/1995 Multilingual */

 if (n_ml_ch >0)
 {
  for (k = 7; k < 7+n_ml_ch; k++)
    for (i=0;i<sblimit;max_sc[k][i] = multiple[max], i++)
      for (j=1, max = scalar[k][0][i];j<3;j++)
         if (max > scalar[k][j][i]) max = scalar[k][j][i];
  for (i=sblimit;i<SBLIMIT;i++) 
	{
	max_sc[7+0][i] =1E-20; 
	if (n_ml_ch >1) max_sc[7+1][i] =1E-20;
	if (n_ml_ch >2) max_sc[7+2][i] =1E-20;
	if (n_ml_ch >3) max_sc[7+3][i] =1E-20;
	if (n_ml_ch >4) max_sc[7+4][i] =1E-20;
	if (n_ml_ch >5) max_sc[7+5][i] =1E-20;
	if (n_ml_ch >6) max_sc[7+6][i] =1E-20;
	}
  }
/* JMZ 08/03/1995 Multilingual */
/********************************************************/

}

/***************************************************************************
/*
/* tc_alloc  (Layer II, multichannel)
/*
/* PURPOSE: For each subbandgroup the three transmissionchannels are
/*          determined by taking the channel with the lowest level
/*          according to the tabel tc_allocation in the draft
/*  8/10/93, SR          
/* 
/*           changed to a certain limit of TC_ALLOC which must be stepped
/*           beyond, before there is channel-switching
/*           9/20/93 SR
/**************************************************************************/

void tc_alloc_old(frame_params *fr_ps, double (*max_sc)[32])
{
    int i, l, k;
    int min;
    double min1;
    double min2[7][12];
    
    for(i = 0; i < 8; i++)
    {
       if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
       {
           if(max_sc[6][i] < max_sc[5][i])
              min = 6;
	   else if(max_sc[6][i] == max_sc[5][i])
	   {
	       if(max_sc[3][i] <= max_sc[5][i])
	           min = 5;
	       else min = 6;	          
	   }
	   else min = 5;
       }  
       else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
       {
           if(max_sc[5][i] < max_sc[6][i])
              min = 5;
	   else if(max_sc[6][i] == max_sc[5][i])
	   {
	       if(max_sc[3][i] <= max_sc[5][i])
	           min = 5;
	       else min = 6;	          
	   }
	   else min = 6;
       }  
       else   	  	    
       {
	      min = 2;
       }
	
	switch(min)
	{
	    case 5: if(max_sc[4][i] <= max_sc[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(max_sc[3][i] <= max_sc[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;		    
	    case 2: if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	            {
	               if(max_sc[4][i] <= max_sc[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
  }


 for(i = 8; i < 12; i++)   
   for(k = 2; k < 7; k++)
        min2[k][i] = 0.0;	 
 
 
 for(i = 8; i < 12; i++)    /*taking the average scalefactor of each sb-group*/
 {
   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }




    if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
    {
        if(min2[6][i] < min2[5][i])
           min = 6;
        else if(min2[6][i] == min2[5][i])
	{
	       if(min2[3][i] <= min2[5][i])
	           min = 5;
	       else min = 6;	          
	}
        else min = 5;
    }  
    else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
    {
        if(min2[5][i] < min2[6][i])
           min = 5;
	else if(min2[6][i] == min2[5][i])
	{
	       if(min2[3][i] <= min2[5][i])
	           min = 5;
	       else min = 6;	          
	}
        else min = 6;
    }  
    else   	  	    
    {
           min = 2;
    }
	




	
	switch(min)
	{
	    case 5: if(min2[4][i] <= min2[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(min2[3][i] <= min2[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;
	    case 2: if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	            {
	               if(min2[4][i] <= min2[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
       
 }


     
    if(fr_ps->header->tc_alloc[0] == fr_ps->header->tc_alloc[1] &&
       fr_ps->header->tc_alloc[1] == fr_ps->header->tc_alloc[2] &&
       fr_ps->header->tc_alloc[2] == fr_ps->header->tc_alloc[3] &&
       fr_ps->header->tc_alloc[3] == fr_ps->header->tc_alloc[4] &&
       fr_ps->header->tc_alloc[4] == fr_ps->header->tc_alloc[5] &&
       fr_ps->header->tc_alloc[5] == fr_ps->header->tc_alloc[6] &&
       fr_ps->header->tc_alloc[6] == fr_ps->header->tc_alloc[7] &&
       fr_ps->header->tc_alloc[7] == fr_ps->header->tc_alloc[8] &&
       fr_ps->header->tc_alloc[8] == fr_ps->header->tc_alloc[9] &&
       fr_ps->header->tc_alloc[9] == fr_ps->header->tc_alloc[10] &&
       fr_ps->header->tc_alloc[10] == fr_ps->header->tc_alloc[11])
       {
          fr_ps->header->tc_sbgr_select = 1;
          fr_ps->header->tc_allocation = fr_ps->header->tc_alloc[0];
       }
      else fr_ps->header->tc_sbgr_select = 0; /* added 8/20/93,SR*/ 
}







/************************************************************************
/*
/* put_scale   (Layer I)
/*
/* PURPOSE:Sets #max_sc# to the scalefactor index in #scalar.
/* This is used by Psychoacoustic Model I
/*
/************************************************************************/
 
void put_scale(unsigned int (*scalar)[3][32], frame_params *fr_ps, double (*max_sc)[32])
                                   
                    
       /*far*/                    
{
   int i,j,k, max;
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
 
	for (k = 0; k < stereo+stereomc+2; k++) for (i = 0; i < SBLIMIT; i++)
        max_sc[k][i] = multiple[scalar[k][0][i]];
}
 
/************************************************************************
/*
/* II_transmission_pattern (Layer II only)
/*
/* PURPOSE:For a given subband, determines whether to send 1, 2, or
/* all 3 of the scalefactors, and fills in the scalefactor
/* select information accordingly
/*
/* SEMANTICS:  The subbands and channels are classified based on how much
/* the scalefactors changes over its three values (corresponding
/* to the 3 sets of 12 samples per subband).  The classification
/* will send 1 or 2 scalefactors instead of three if the scalefactors
/* do not change much.  The scalefactor select information,
/* #scfsi#, is filled in accordingly.
/*
/************************************************************************/
 
void II_transmission_pattern(unsigned int (*scalar)[3][32], unsigned int (*scfsi)[32], frame_params *fr_ps)
                                    	/* JMZ 08/03/1995 Multilingual */
                                		/* JMZ 08/03/1995 Multilingual */
                    
                                    	/* JMZ 08/03/1995 Multilingual */

{
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int n_ml_ch = fr_ps->header->multiling_ch;/* JMZ 10/03/1995 Multilingual */

	int dscf[2];
	int class[2],i,j,k;
static int pattern[5][5] = {0x123, 0x122, 0x122, 0x133, 0x123,
                            0x113, 0x111, 0x111, 0x444, 0x113,
                            0x111, 0x111, 0x111, 0x333, 0x113,
                            0x222, 0x222, 0x222, 0x333, 0x123,
                            0x123, 0x122, 0x122, 0x133, 0x123};
 
  for (k = 0; k < stereo+stereomc+2; k++)
     for (i=0;i<sblimit;i++) 
     {
       dscf[0] =  (scalar[k][0][i]-scalar[k][1][i]);
       dscf[1] =  (scalar[k][1][i]-scalar[k][2][i]);
       for (j=0;j<2;j++)
       {
         if (dscf[j]<=-3) class[j] = 0;
         else if (dscf[j] > -3 && dscf[j] <0) class[j] = 1;
              else if (dscf[j] == 0) class[j] = 2;
                   else if (dscf[j] > 0 && dscf[j] < 3) class[j] = 3;
                        else class[j] = 4;
       }
       switch (pattern[class[0]][class[1]]) 
       {
         case 0x123 :    scfsi[k][i] = 0;
                         break;
         case 0x122 :    scfsi[k][i] = 3;
                         scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x133 :    scfsi[k][i] = 3;
                         scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x113 :    scfsi[k][i] = 1;
                         scalar[k][1][i] = scalar[k][0][i];
                         break;
         case 0x111 :    scfsi[k][i] = 2;
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
                         break;
         case 0x222 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x333 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x444 :    scfsi[k][i] = 2;
                         if (scalar[k][0][i] > scalar[k][2][i])
                              scalar[k][0][i] = scalar[k][2][i];
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
   
   
       } /* switch */
    } /* subband */

if (n_ml_ch >0)
{
 for (k = 7; k < 7+n_ml_ch; k++)
     for (i=0;i<sblimit;i++) 
     {
       dscf[0] =  (scalar[k][0][i]-scalar[k][1][i]);
       dscf[1] =  (scalar[k][1][i]-scalar[k][2][i]);
       for (j=0;j<2;j++)
       {
         if (dscf[j]<=-3) class[j] = 0;
         else if (dscf[j] > -3 && dscf[j] <0) class[j] = 1;
              else if (dscf[j] == 0) class[j] = 2;
                   else if (dscf[j] > 0 && dscf[j] < 3) class[j] = 3;
                        else class[j] = 4;
       }
       switch (pattern[class[0]][class[1]]) 
       {
         case 0x123 :    scfsi[k][i] = 0;
                         break;
         case 0x122 :    scfsi[k][i] = 3;
                         scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x133 :    scfsi[k][i] = 3;
                         scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x113 :    scfsi[k][i] = 1;
                         scalar[k][1][i] = scalar[k][0][i];
                         break;
         case 0x111 :    scfsi[k][i] = 2;
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
                         break;
         case 0x222 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];
                         break;
         case 0x333 :    scfsi[k][i] = 2;
                         scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];
                         break;
         case 0x444 :    scfsi[k][i] = 2;
                         if (scalar[k][0][i] > scalar[k][2][i])
                              scalar[k][0][i] = scalar[k][2][i];
                         scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];
     } /* subband */
   } /* channel */
}

}
 
/************************************************************************
/*
/* I_encode_scale  (Layer I)
/* II_encode_scale (Layer II)
/*
/* PURPOSE:The encoded scalar factor information is arranged and
/* queued into the output fifo to be transmitted.
/*
/* For Layer II, the three scale factors associated with
/* a given subband and channel are transmitted in accordance
/* with the scfsi, which is transmitted first.
/*
/************************************************************************/
 
void I_encode_scale(unsigned int (*scalar)[3][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
{
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int i,j;
 
   for (i=0;i<SBLIMIT;i++) for (j=0;j<stereo;j++)
      if (bit_alloc[j][i]) putbits(bs,scalar[j][0][i],6);
}
 
/***************************** Layer II  ********************************/

void
II_encode_scale(
	unsigned int (*bit_alloc)[32],
	unsigned int (*scfsi)[32],
	unsigned int (*scalar)[3][32], /* JMZ 08/03/1995 Multilingual */
	frame_params *fr_ps,
	Bit_stream_struc *bs,
	int *l,
	int *z
) {
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int i,j,k, m, n, pci;
   int pred;

	for (i=0;i<sblimit;i++)
	 for (m = *l; m < *z; m++)
	 {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     { 
	        if(i == 0) k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	        else
		{
                   for(n = 1; n < 12; n++)
                   {
	              if((sb_groups[n-1] < i) && (i <= sb_groups[n])) 
	              {
                          k = transmission_channel[fr_ps->header->tc_alloc[n]][m];
		          break;
	              }
                   }
		 }  
	      } 


	 
		if (bit_alloc[k][i]) 
			{ 
           	putbits(bs,scfsi[k][i],2);

           	}
          }
 
 
 pred = 0;
       if( *l == 2)
       {
	if(fr_ps->header->mc_prediction_on == 1)
	{
	   for(i = 0; i < 8; i++)
	   {
	       if(fr_ps->header->mc_pred[i] == 1)
	       {
		   for(m = 0; m < n_pred_coef[fr_ps->header->dyn_cross[i]]; m++)
		   {
		       if(fr_ps->header->predsi[i][m] != 0)
		       {
		          putbits(bs, fr_ps->header->delay_comp[i][m], 3);
			  pred += 3;
			  for(pci = 0; pci < fr_ps->header->predsi[i][m]; pci++)
			  {
			    putbits(bs, pred_coef[i][m][pci], 8);
			    pred += 8;			      
			  }
		       }    
		   }
	       }
	   }
	 }  
	}  
 
	for (i=0;i<sblimit;i++)
	 for (m = *l;m < *z; m++)
	 {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     {
	       if(i == 0)  k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	       else
	       {
                  for(n = 1; n < 12; n++)
                  {
	              if((sb_groups[n-1] < i) && (i <= sb_groups[n])) /*bug!! 8/21/93,SR*/
	              {
                          k = transmission_channel[fr_ps->header->tc_alloc[n]][m];
	                 break;
	              }
                   }
                } 
	      }	
	     
	     
	 
           if (bit_alloc[k][i])  
	   switch (scfsi[k][i]) 
	   {
			case 0: for (j=0;j<3;j++)
                        putbits(bs,scalar[k][j][i],6);

					break;
			case 1:
			case 3:	putbits(bs,scalar[k][0][i],6);
					putbits(bs,scalar[k][2][i],6);

					break;
			case 2: putbits(bs,scalar[k][0][i],6);

          }
       }	
}
 
/*JMZ 24/2/95 Multilingual */
void II_encode_scale_ml(unsigned int (*bit_alloc)[32], unsigned int (*scfsi)[32], unsigned int (*scalar)[3][32], frame_params *fr_ps, Bit_stream_struc *bs, int *l, int *z)
                                                         	/*JMZ 24/2/95 Multilingual */
                                    		/*JMZ 24/2/95 Multilingual */
                    
                     
       
       
{
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int i,j,k, m, n, pci;

 
for (i=0;i<sblimit;i++)
for (m = *l; m < *z; m++)	/* JMZ 10/03/1995 Multilingual */
	{
	k=m;
	if (bit_alloc[k][i])  
		{
		putbits(bs,scfsi[k][i],2);

		}
	}
 
for (i=0;i<sblimit;i++)
for (m = *l;m < *z; m++)	/* JMZ 10/03/1995 Multilingual */
	{
	k=m;
	if (bit_alloc[k][i])  
		switch (scfsi[k][i]) 
		{
			case 0: for (j=0;j<3;j++)
				putbits(bs,scalar[k][j][i],6);

				break;
			case 1:
			case 3: putbits(bs,scalar[k][0][i],6);
				putbits(bs,scalar[k][2][i],6);

				break;
			case 2: putbits(bs,scalar[k][0][i],6);

		}
	}	
}

/*=======================================================================\
|                                                                        |
|      The following routines are done after the masking threshold       |
| has been calculated by the fft analysis routines in the Psychoacoustic |
| model. Using the MNR calculated, the actual number of bits allocated   |
| to each subband is found iteratively.                                  |
|                                                                        |
\=======================================================================*/
 
/************************************************************************
/*
/* I_bits_for_nonoise  (Layer I)
/* II_bits_for_nonoise (Layer II)
/*
/* PURPOSE:Returns the number of bits required to produce a
/* mask-to-noise ratio better or equal to the noise/no_noise threshold.
/*
/* SEMANTICS:
/* bbal = # bits needed for encoding bit allocation
/* bsel = # bits needed for encoding scalefactor select information
/* banc = # bits needed for ancillary data (header info included)
/*
/* For each subband and channel, will add bits until one of the
/* following occurs:
/* - Hit maximum number of bits we can allocate for that subband
/* - MNR is better than or equal to the minimum masking level
/*   (NOISY_MIN_MNR)
/* Then the bits required for scalefactors, scfsi, bit allocation,
/* and the subband samples are tallied (#req_bits#) and returned.
/*
/* (NOISY_MIN_MNR) is the smallest MNR a subband can have before it is
/* counted as 'noisy' by the logic which chooses the number of JS
/* subbands.
/*
/* Joint stereo is supported.
/*
/************************************************************************/

/*static double snr[18] = {0.00, 7.00, 11.00, 16.00, 20.84,
                         25.28, 31.59, 37.75, 43.84,
                         49.89, 55.93, 61.96, 67.98, 74.01,
                         80.03, 86.05, 92.01, 98.01};*/
static double snr[18] = { 0.00,  6.03, 11.80, 15.81, /* 0, 3, 5, 7 */
			 19.03, 23.50, 29.82, 35.99, /* 9,15,31,63 */
			 42.08, 48.13, 54.17, 60.20, /* 127, ...   */
			 66.22, 72.25, 78.27, 84.29, /* 2047, ...  */
			 90.31, 96.33};              /* 16383, ... */

int I_bits_for_nonoise(double (*perm_smr)[32], frame_params *fr_ps)
       /*far*/                      
                    
{
   int i,j,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   int req_bits = 0;
 
   /* initial b_anc (header) allocation bits */
   req_bits = 32 + 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );
 
   for(i=0; i<SBLIMIT; ++i)
     for(j=0; j<((i<jsbound)?stereo:1); ++j) {
       for(k=0;k<14; ++k)
			if( (-perm_smr[j][i] + snr[k]) >= fr_ps->mnr_min)
           break; /* we found enough bits */
         if(stereo == 2 && i >= jsbound)     /* check other JS channel */
           for(;k<14; ++k)
				 if( (-perm_smr[1-j][i] + snr[k]) >= fr_ps->mnr_min) break;
         if(k>0) req_bits += (k+1)*12 + 6*((i>=jsbound)?stereo:1);
   }
   return req_bits;
}
 
/***************************** Layer II  ********************************/
 
int II_bits_for_nonoise(double (*perm_smr)[32], unsigned int (*scfsi)[32], frame_params *fr_ps, int a, int b, int *aiff)
       /*far*/                      
                               
                    
      
      
          
{
   int sb,ch,ba,i;
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int n_ml_ch = fr_ps->header->multiling_ch;	/* 23/03/1995 JMZ Multilingual */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
   int bbal = 0;
   int berr;		                  /* before: =0 92-08-11 shn */
   int banc = 32; 	                  /* header ISO Layer II */
   int bancmc = 0;                            /* header multichannel = 93, 5.7.93,SR*/
   int maxAlloc, sel_bits, sc_bits, smp_bits;
   int req_bits = 0;
   static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */

	if( *aiff == 1)
	{ 
	      bancmc += 31;      /* mc_header + crc + tc_sbgr_select+ dyn_cross_on + 
				    mc_prediction_on       01/05/94,  SR*/
	      if(fr_ps->header->tc_sbgr_select == 0)
		bancmc += 36;
	      else
		bancmc += 3;	

	      if(fr_ps->header->dyn_cross_on == 1)
	      {
		  fprintf(stderr, "WARNING!! not done yet Dynamic Crosstalk!!!\n");
		  bancmc += 48;
	      }

              if(fr_ps->header->mc_prediction_on == 1)
	      {
		  fprintf(stderr, "WARNING! not done yet Prediction!!!\n");
		  for(i = 0; i < 12; i++)
		  {
		    bancmc += 1;
		    if(fr_ps->header->mc_pred[i] == 1)
		       bancmc += 4;
		  }
	      }
	 }     
        else bancmc = 0;
	if (fr_ps->header->error_protection) berr=16; else berr=0; /* added 92-08-11 shn */
	/*fixed bug (no errormc) 28.6.93 SR */
	for (sb = 0; sb < jsbound; ++sb)
	  bbal += (stereo+stereomc+n_ml_ch) * (*alloc)[sb][0].bits;  /* 23/03/1995 JMZ Multilingual */
	  
	for (sb = jsbound; sb < sblimit; ++sb)
	  bbal += (stereo-1+stereomc+n_ml_ch) * (*alloc)[sb][0].bits;  /* 23/03/1995 JMZ Multilingual */      	 
	  
	req_bits = banc + bancmc + bbal + berr;


	for(sb = 0; sb < sblimit; ++sb)
	{
	  for(ch = 0; ch < ((sb < jsbound)? stereo+stereomc : 1); ++ch) /* 23/03/1995 JMZ Multilingual */ 
	  {
	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
             sel_bits = sc_bits = smp_bits = 0;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
                   break;	       
		if(((b - a) >= 1) && (sb >= jsbound))
		{ /* check other JS channels */
		      for(;ba<maxAlloc-1; ++ba)
			 if( (-perm_smr[1-ch ][sb]+ snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
			 	>= fr_ps->mnr_min)
		      break;
		}
	
                if(ba>0) 
		{
                 smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
                 /* scale factor bits required for subband */
                 sel_bits = 2;
		 sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];

		   if(stereo == 2 && sb >= jsbound) {
		       /* each new js sb has L+R scfsis*/
                       sel_bits += 2;
                       sc_bits  += 6 * sfsPerScfsi[scfsi[1-ch][sb]];
		      } 

                   req_bits += (smp_bits+sel_bits+sc_bits);
                  }
	    }
	    
   }
/******************************************/
/* 23/03/1995 JMZ Multilingual */

if(n_ml_ch>0)
{
for(sb = 0; sb < jsbound; ++sb)
	{
	for(ch = 7; ch < 7+n_ml_ch ; ++ch)  
		{
		maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
		sel_bits = sc_bits = smp_bits = 0;
		for(ba = 0; ba < maxAlloc-1; ++ba)
			if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
                  break;	       
		if(ba>0) 
			{
			smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
                /* scale factor bits required for subband */
			sel_bits = 2;
			sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];

			if(stereo == 2 && sb >= jsbound) 
				{
				/* each new js sb has L+R scfsis*/
				sel_bits += 2;
				sc_bits  += 6 * sfsPerScfsi[scfsi[1-ch][sb]];
				} 

			req_bits += (smp_bits+sel_bits+sc_bits);
			}
		}
	}
}
/* 23/03/1995 JMZ Multilingual */
/******************************************/
   return req_bits;
}



 
 
 
/**********************************************************************/ 
/*now for the independent channels, 8/6/93, SR                        */
/**********************************************************************/
int II_bits_for_indi(double (*perm_smr)[32], unsigned int (*scfsi)[32], frame_params *fr_ps, int *a, int *b, int *aiff)
       /*far*/                      
                               
                    
       
       
          
{
   int sb,ch,ba,i;
   int stereo  = fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int n_ml_ch = fr_ps->header->multiling_ch;	/* 23/03/1995 JMZ Multilingual */
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
   int req_bits = 0, bbal = 0;
   int berr;		                  /* before: =0 92-08-11 shn */
   int banc = 32; 	                  /* header ISO Layer II */
   int bancmc;                            /* header multichannel = 93, 5.7.93,SR*/
   int maxAlloc, sel_bits, sc_bits, smp_bits;
   static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */

	for(sb = jsbound; sb < sblimit; ++sb)
	{
	  for(ch = 2; ch < 5; ++ch) 
	  {
	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
             sel_bits = sc_bits = smp_bits = 0;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */

              if(ba>0) 
		{
                 smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
                 /* scale factor bits required for subband */
                 sel_bits = 2;
		 sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];

	          req_bits += smp_bits+sel_bits+sc_bits;
                 }
	    }
/******************************************/
/* 23/03/1995 JMZ Multilingual */

	    if (n_ml_ch>0)
	    {
			for(ch = 7; ch < 7+n_ml_ch; ++ch) 
			{
			maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
			sel_bits = sc_bits = smp_bits = 0;
			for(ba = 0; ba < maxAlloc-1; ++ba)
			if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
			if(ba>0) 
				{
				smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);
                 /* scale factor bits required for subband */
				sel_bits = 2;
				sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];

				req_bits += smp_bits+sel_bits+sc_bits;
				}
			}
		}
/* 23/03/1995 JMZ Multilingual */
/******************************************/
	    
   }
   return req_bits;
}

	    
/************************************************************************
/*
/* I_main_bit_allocation   (Layer I)
/* II_main_bit_allocation  (Layer II)
/*
/* PURPOSE:For joint stereo mode, determines which of the 4 joint
/* stereo modes is needed.  Then calls *_a_bit_allocation(), which
/* allocates bits for each of the subbands until there are no more bits
/* left, or the MNR is at the noise/no_noise threshold.
/*
/* SEMANTICS:
/*
/* For joint stereo mode, joint stereo is changed to stereo if
/* there are enough bits to encode stereo at or better than the
/* no-noise threshold (fr_ps->mnr_min).  Otherwise, the system
/* iteratively allocates less bits by using joint stereo until one
/* of the following occurs:
/* - there are no more noisy subbands (MNR >= fr_ps->mnr_min)
/* - mode_ext has been reduced to 0, which means that all but the
/*   lowest 4 subbands have been converted from stereo to joint
/*   stereo, and no more subbands may be converted
/*
/*     This function calls *_bits_for_nonoise() and *_a_bit_allocation().
/*
/************************************************************************/
 
void I_main_bit_allocation(double (*perm_smr)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps)
       /*far*/                      
                                   
         
                    
{
   int  noisy_sbs;
   int  mode, mode_ext, lay, i;
   int  rq_db, av_db = *adb;
static  int init = 0;
 
   if(init == 0) {
     /* rearrange snr for layer I */
     snr[2] = snr[3];
     for (i=3;i<16;i++) snr[i] = snr[i+2];
     init = 1;
   }
 
   if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) {
     fr_ps->header->mode = MPG_MD_STEREO;
     fr_ps->header->mode_ext = 0;
     fr_ps->jsbound = fr_ps->sblimit;
     if(rq_db = I_bits_for_nonoise(perm_smr, fr_ps) > *adb) {
       fr_ps->header->mode = MPG_MD_JOINT_STEREO;
       mode_ext = 4;           /* 3 is least severe reduction */
       lay = fr_ps->header->lay;
       do {
          --mode_ext;
          fr_ps->jsbound = js_bound(lay, mode_ext);
          rq_db = I_bits_for_nonoise(perm_smr, fr_ps);
       } while( (rq_db > *adb) && (mode_ext > 0));
       fr_ps->header->mode_ext = mode_ext;
     }    /* well we either eliminated noisy sbs or mode_ext == 0 */
   }
   noisy_sbs = I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps);
}
 
 

/***************************** Layer II  ********************************/
 
void
II_main_bit_allocation(
	double (*perm_smr)[32], /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
	double (*ltmin)[32], /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
	unsigned int (*scfsi)[32], /* JMZ 08/03/1995 Multilingual */
	unsigned int (*bit_alloc)[32], /* JMZ 08/03/1995 Multilingual */
	int *adb,
	frame_params *fr_ps,
	int *aiff,
	double (*sb_sample)[3][12][32], /* JMZ 08/03/1995 Multilingual */
	unsigned int (*scalar)[3][32], /* JMZ 08/03/1995 Multilingual */
	double (*max_sc)[32], /* JMZ 08/03/1995 Multilingual */
	int cha_sw,
	double (*buffer)[1152], /* JMZ 08/03/1995 Multilingual */
	double (*spiki)[32], /* JMZ 08/03/1995 Multilingual */
	double (*joint_sample)[3][12][32],
	unsigned int (*j_scale)[3][32]
) {
   int  noisy_sbs, nn;
	int  mode, mode_ext, lay, modemc_hlp;
	int  rq_db, av_db = *adb;
	int a, b, i, l, m, sb, k;
	int sbbound = -30;
	float adb_help;
	double smr_pred[7][SBLIMIT];
        float preco[12][4];
	float prega[3][32];
	int bits1, bits2, ba, ba1, subgr;
	int maxAlloc;
	al_table *alloc = fr_ps->alloc;
	static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */




  /***************************layer II two channels *******************/
  if(*aiff == 0){
	if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO){
	  a = 0;
	  b = 1;
	  fr_ps->header->mode = MPG_MD_STEREO;
     fr_ps->header->mode_ext = 0;
     fr_ps->jsbound = fr_ps->sblimit;
	  if(rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, a, b, aiff)
			  > *adb) {
       fr_ps->header->mode = MPG_MD_JOINT_STEREO;
       mode_ext = 4;           /* 3 is least severe reduction */
       lay = fr_ps->header->lay;
       do {
         --mode_ext;
         fr_ps->jsbound = js_bound(lay, mode_ext);
			rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, a, b, aiff);
		 } while( (rq_db > *adb) && (mode_ext > 0));
       fr_ps->header->mode_ext = mode_ext;
	  }	 /* well we either eliminated noisy sbs or mode_ext == 0 */
 }
 }


 /***************** layer II five channels ****************************/
  else{
	for(sb = 0; sb < SBLIMIT; ++sb)
	{
	  if(sb >= 8)
	  {
	    for(subgr = 8; subgr < 12; subgr++)
		 if((sb_groups[subgr-1] < sb) && (sb <= sb_groups[subgr])) break;
	  }  
	  else subgr = sb;
   	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[0][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
	     for(ba1 = 0; ba1 < maxAlloc-1; ++ba1)
                if( (-perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][0]][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)
                /*if( (-perm_smr[5][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)*/
				break;		/* we found enough bits */
		if(ba1 > ba)
		{
         	 perm_smr[0][sb] = perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][0]][sb];		
         	 /*perm_smr[0][sb] = perm_smr[5][sb];*/		
		 ba = ba1;
		}

		 
		 
		 
	     maxAlloc = (1<<(*alloc)[sb][0].bits)-1;
	     for(ba = 0; ba < maxAlloc-1; ++ba)
                if( (-perm_smr[1][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])
				 >= fr_ps->mnr_min)
				break;		/* we found enough bits */
	     for(ba1 = 0; ba1 < maxAlloc-1; ++ba1)
                if( (-perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][1]][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)
                /*if( (-perm_smr[6][sb] + snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])
				 >= fr_ps->mnr_min)*/
				break;		/* we found enough bits */
		if(ba1 > ba)
		{
		 perm_smr[1][sb] = perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][1]][sb];		
		/* perm_smr[1][sb] = perm_smr[6][sb];*/		
		 ba = ba1;
		}
	    }
 
   if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO)
   {
 	  a = 0;
	  b = 1;
	  fr_ps->header->mode = MPG_MD_STEREO;
          fr_ps->header->mode_ext = 0;
	  fr_ps->jsbound = fr_ps->sblimit;
	  adb_help = *adb;
	  if((rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps,/*&*/a, /*&*/b, aiff) /*JMZ 29/03/1995 BUG*/
	            + II_bits_for_indi(perm_smr, scfsi, fr_ps, &a, &b, aiff))  
					  > adb_help)
	  {
             fr_ps->header->mode = MPG_MD_JOINT_STEREO;
             mode_ext = 4;           /* 3 is least severe reduction */
             lay = fr_ps->header->lay;
             do {
               --mode_ext;
               fr_ps->jsbound = js_bound(lay, mode_ext);
	       rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps, a, b, aiff)
	              + II_bits_for_indi(perm_smr, scfsi, fr_ps, &a, &b, aiff);
	     } while( (rq_db >*adb) && (mode_ext > 0));
             fr_ps->header->mode_ext = mode_ext;
	  }	 /* well we either eliminated noisy sbs or mode_ext == 0 */

   }


 }  /* end of else (five-channel) */

noisy_sbs = II_a_bit_allocation(perm_smr, scfsi, bit_alloc, adb,
				  fr_ps, aiff);
				 

}
 
/************************************************************************
/*
/* I_a_bit_allocation  (Layer I)
/* II_a_bit_allocation (Layer II)
/*
/* PURPOSE:Adds bits to the subbands with the lowest mask-to-noise
/* ratios, until the maximum number of bits for the subband has
/* been allocated.
/*
/* SEMANTICS:
/* 1. Find the subband and channel with the smallest MNR (#min_sb#,
/*    and #min_ch#)
/* 2. Calculate the increase in bits needed if we increase the bit
/*    allocation to the next higher level
/* 3. If there are enough bits available for increasing the resolution
/*    in #min_sb#, #min_ch#, and the subband has not yet reached its
/*    maximum allocation, update the bit allocation, MNR, and bits
/*    available accordingly
/* 4. Repeat until there are no more bits left, or no more available
/*    subbands. (A subband is still available until the maximum
/*    number of bits for the subband has been allocated, or there
/*    aren't enough bits to go to the next higher resolution in the
/*    subband.)
/*
/************************************************************************/
 
int I_a_bit_allocation(double (*perm_smr)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps)	/* return noisy sbs */
       /*far*/                      
                                   
         
                    
{
   int i, k, smpl_bits, scale_bits, min_sb, min_ch, oth_ch;
   int bspl, bscf, ad, noisy_sbs, done = 0;
   double mnr[2][SBLIMIT], small;
   char used[2][SBLIMIT];
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
   static char init= 0;
   static int bbal, banc, berr;
 
   if (!init) {
      banc = 32;     /* before: berr = 0; 92-08-11 shn */ 
      init = 1;

      if (fr_ps->header->error_protection) berr = 16; else berr= 0; /* added 92-08-11 shn */
   }
   bbal = 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );
   *adb -= bbal + berr + banc;
   ad= *adb;
 
   for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++) {
     mnr[k][i]=snr[0]-perm_smr[k][i];
     bit_alloc[k][i] = 0;
     used[k][i] = 0;
   }
   bspl = bscf = 0;
 
   do  {
     /* locate the subband with minimum SMR */
     small = mnr[0][0]+1;    min_sb = -1; min_ch = -1;
     for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++)
       /* go on only if there are bits left */
       if (used[k][i] != 2 && small > mnr[k][i]) {
         small = mnr[k][i];
         min_sb = i;  min_ch = k;
       }
     if(min_sb > -1) {   /* there was something to find */
       /* first step of bit allocation is biggest */
       if (used[min_ch][min_sb])  { smpl_bits = 12; scale_bits = 0; }
       else                       { smpl_bits = 24; scale_bits = 6; }
       if(min_sb >= jsbound)        scale_bits *= stereo;
 
       /* check to see enough bits were available for */
       /* increasing resolution in the minimum band */
 
       if (ad  > bspl + bscf + scale_bits + smpl_bits) {
         bspl += smpl_bits; /* bit for subband sample */
         bscf += scale_bits; /* bit for scale factor */
         bit_alloc[min_ch][min_sb]++;
         used[min_ch][min_sb] = 1; /* subband has bits */
         mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb]
                               + snr[bit_alloc[min_ch][min_sb]];
         /* Check if subband has been fully allocated max bits */
         if (bit_alloc[min_ch][min_sb] ==  14 ) used[min_ch][min_sb] = 2;
       }
       else            /* no room to improve this band */
         used[min_ch][min_sb] = 2; /*   for allocation anymore */
       if(stereo == 2 && min_sb >= jsbound) {
         oth_ch = 1-min_ch;  /* joint-st : fix other ch */
         bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];
         used[oth_ch][min_sb] = used[min_ch][min_sb];
         mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb]
                               + snr[bit_alloc[oth_ch][min_sb]];
       }
     }
   } while(min_sb>-1);     /* i.e. still some sub-bands to find */

   /* Calculate the number of bits left, add on to pointed var */
   ad -= bspl+bscf;
   *adb = ad;

   /* see how many channels are noisy */
   noisy_sbs = 0; small = mnr[0][0];
   for(k=0; k<stereo; ++k) {
     for(i = 0; i< SBLIMIT; ++i) {
		 if(mnr[k][i] < fr_ps->mnr_min)	 ++noisy_sbs;
       if(small > mnr[k][i])           small = mnr[k][i];
     }
   }
   return noisy_sbs;
}

/***************************** Layer II  ********************************/

int II_a_bit_allocation(double (*perm_smr)[32], unsigned int (*scfsi)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps, int *aiff)
       /*far*/                        /* minimum masking level *//* JMZ 08/03/1995 Multilingual */
                                		/* JMZ 08/03/1995 Multilingual */
                                    	/* JMZ 08/03/1995 Multilingual */
         
                    
          	 /* flag for masking level */
{
	int n_ml_ch =fr_ps->header->multiling_ch; 	/*JMZ 08/03/95 Multilingual */
	int i, min_ch, min_sb, oth_ch, k, increment, scale, seli, ba, j, l;
	int increment1, scale1, seli1;
	int adb_hlp, adb_hlp1, adb_hlp2;
        int bspl, bscf, bsel, ad, noisy_sbs;
        int bspl_mpg1, bscf_mpg1, bsel_mpg1;
	double mnr[14][SBLIMIT], small;		/* JMZ 08/03/1995 Multilingual */
	char used[14][SBLIMIT];				/* JMZ 08/03/1995 Multilingual */
	int stereo	= fr_ps->stereo;
	int stereomc = fr_ps->stereomc;
        int sblimit = fr_ps->sblimit;
	int jsbound = fr_ps->jsbound;
	int jsboundmc = fr_ps->jsboundmc;
	al_table *alloc = fr_ps->alloc;
	double dynsmr = 0.0;  /* border of SMR for dynamic datarate */
        static char init= 0;
	static int banc, berr;
        int bbal, bancmc, bancext, bbal_mpg1;
        int ll, pred, pci, adb_mpg1;
        static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */
    if (!init)
    { 
	  init = 1; banc = 32; /* banc: bits for header */;
	  if (fr_ps->header->error_protection) berr=16; else berr=0; /* added 92-08-11 shn */
    }
  
        pred = 0;
        bancmc = 0;
	bbal = 0;
	bbal_mpg1 = 0;
	bancext = 0;
	adb_mpg1 = bitrate[fr_ps->header->lay-1][fr_ps->header->bitrate_index] * 24;
	
  if( *aiff == 1)
  {
	 if(fr_ps->actual_mode == MPG_MD_JOINT_STEREO)
	 {
	                     /*JS Lo + Ro */
		 for(i = 0; i < jsbound; ++i)
		 	{
		  /*bbal += 5 * (*alloc)[i][0].bits; JMZ Multilingual 20/03/1995*/
		  bbal += (stereo+stereomc+n_ml_ch) * (*alloc)[i][0].bits;
		  	}
		 for(i = jsbound; i < sblimit; ++i)
		 	{
		  /*bbal += 4 * (*alloc)[i][0].bits; JMZ Multilingual 20/03/1995*/
		  bbal += (stereo+stereomc+n_ml_ch-1) * (*alloc)[i][0].bits;
		  	}
		 if(fr_ps->header->center == 3) bbal -= 41; 
	 }	  
	 else
	 {
	 
	        for( i = 0; i < sblimit; ++i)
	        	{
		  /*bbal += 5 * (*alloc)[i][0].bits; JMZ Multilingual 20/03/1995*/
		  bbal += (stereo+stereomc+n_ml_ch) * (*alloc)[i][0].bits;
		  		}
		 if(fr_ps->header->center == 3) bbal -= 41; 
	 }
  }
  else
  {
	 for(i = 0; i < jsbound; ++i)
		  bbal += stereo * (*alloc)[i][0].bits;
		 for(i = jsbound; i < sblimit; ++i)
		  bbal += (*alloc)[i][0].bits;
  }

    if(fr_ps->header->dyn_cross_on == 1)
    {
	for(i = 0; i < 12; i++)
	{
	    bbal -= dyn_bbal[fr_ps->header->dyn_cross[i]][i];
	}
    }	    
	

      if(fr_ps->header->ext_bit_stream_present == 0)
        bancmc += 35;      /* mc_header + crc + tc_sbgr_select+ dyn_cross_on + 
			    mc_prediction_on  01/05/94,  SR  new! 05/04/94,  SR*/
      else
      {
        bancmc += 43;			    
	bancext = 40;
      }
      			    
      if(fr_ps->header->tc_sbgr_select == 0)
	bancmc += 36;
      else
	bancmc += 3;	

      if(fr_ps->header->dyn_cross_on == 1)
      {
	  if(fr_ps->header->surround == 3)
	        bancmc += 61;      /* now with dyn_second_stereo,  17/02/95,  SR*/
	  else  bancmc += 49;
      }

      if(fr_ps->header->mc_prediction_on == 1)
      {
	for(i = 0; i < 8; i++)   /*now only 8 sb_groups, 05/04/94, SR*/
	{
	    bancmc += 1;
	    if(fr_ps->header->mc_pred[i] == 1)
	       bancmc += n_pred_coef[fr_ps->header->dyn_cross[i]] * 2;
	}
      }	


  for (i = 0; i < sblimit; i++) 
       for (k = 0; k < (stereo+stereomc+2); k++) 
       {
	  mnr[k][i]=snr[0]-perm_smr[k][i];
	  /* mask-to-noise-level = signal-to-noise-level - minimum-masking-*/
	  /* threshold*/

         bit_alloc[k][i] = 0;
         used[k][i] = 0;
       }
   
/********************************************************************/
/* JMZ 08/03/1995 Multilingual */  
 
	for (i = 0; i < sblimit; i++) 
		for (k = 7; k < 7+n_ml_ch; k++) 
		{
		mnr[k][i]=snr[0]-perm_smr[k][i];
	  /* mask-to-noise-level = signal-to-noise-level - minimum-masking-*/
	  /* threshold*/

		bit_alloc[k][i] = 0;
		used[k][i] = 0;
		}

/* JMZ 08/03/1995 Multilingual */   
/********************************************************************/
   
    if(fr_ps->header->mc_prediction_on == 1)
    {
       for( i = 0; i < 8; i++) 
       {
	   if(fr_ps->header->mc_pred[i] == 1)
	   {
	       for(j = 0; j < n_pred_coef[fr_ps->header->dyn_cross[i]]; j++)
	       {
		   if(fr_ps->header->predsi[i][j] != 0)
		   {
		      pred += 3;
		      for(pci = 0; pci < fr_ps->header->predsi[i][j]; pci++)
			pred += 8;
		    }	
	       }
	   }
       }
    }  

    adb_hlp = *adb;

    if(*aiff != 1)
    {
	*adb -= bbal + berr + banc;
    }
    else 
    {
    	if(fr_ps->header->ext_bit_stream_present == 0)    
	    *adb -= bbal + berr + banc + bancmc + pred;
	else
	{
	    *adb = *adb - bbal - berr - banc - bancmc - pred - 
	    bancext - (fr_ps->header->n_ad_bytes * 8);
	    
            for(i = 0; i < jsbound; ++i)
		  bbal_mpg1 += stereo * (*alloc)[i][0].bits;
	    for(i = jsbound; i < sblimit; ++i)
		  bbal_mpg1 += (*alloc)[i][0].bits;

	    adb_mpg1 -= bbal_mpg1 + berr + banc + bancmc +
	     (fr_ps->header->n_ad_bytes * 8);
	}   
     }		    
        ad = *adb;
 
  
   bspl = bscf = bsel = bspl_mpg1 = bscf_mpg1 = bsel_mpg1 = 0;
 
   do  {
     /* locate the subband with minimum SMR */
	  small = 999999.0;
	  min_sb = -1;
	  min_ch = -1;

	for (i = 0; i < sblimit; i++)		  /* searching for the sb min SMR*/
	  for(j = 0; j < (stereo+stereomc); ++j)
	  {
	     if(fr_ps->header->tc_sbgr_select == 1)
	     {
	       if( i == 0) l = 0;
	       else
	       {
                   for(l = 1; l < 12; l++)
	              if((sb_groups[l-1] < i) && (i <= sb_groups[l])) break;
	        }
                k = transmission_channel[fr_ps->header->tc_allocation][j];
	     }  
	     else
	     { 
	       if(i == 0) 
               {
                   k = transmission_channel[fr_ps->header->tc_alloc[0]][j];
                   l = 0;
               }
	       else
	       {
                   for(l = 1; l < 12; l++)
                   {
	              if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
	              {
                          k = transmission_channel[fr_ps->header->tc_alloc[l]][j];
		          break;
	              }
		    }  
                }
	      }
	    
	    if((i >= 12) && (fr_ps->header->center == 3) && (k == 2))   
		used[k][i] = 2;

	     
	     if ((used[k][i] != 2) && (small > mnr[k][i])) 
	     {
                  small = mnr[k][i];
                  min_sb = i;  min_ch = k;
		  ll = l;		    /*sb-group*/
	     }
	   }  
/******************************************************************/
/* Multilingual JMZ 08/03/1995 */
if(n_ml_ch >0)
{
	for (i = 0; i < sblimit; i++)
	  for(j = 7; j < (n_ml_ch+7); ++j)
	  {
	     k=j;
	     if ((used[k][i] != 2) && (small > mnr[k][i])) 
	     {
                  small = mnr[k][i];
                  min_sb = i;  min_ch = k;
		  ll = l;		    
	     }
	}
}
/* Multilingual JMZ 08/03/1995 */
/******************************************************************/

     if(min_sb > -1) 
     {   /* there was something to find */
         /* find increase in bit allocation in subband [min] */
	    increment = 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group *
			(*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);
		 /* how many bits are needed */

       if (used[min_ch][min_sb])
         increment -= 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group*
                           (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);



       /* scale factor bits required for subband [min] */
       /* above js bound, need both chans */

       if((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && 
				    ((min_ch == 0) || (min_ch == 1)))
            oth_ch = 1 - min_ch;       
	    
       if (used[min_ch][min_sb]) scale = seli = 0;
       else 
       {			  /* this channel had no bits or scfs before */
         seli = 2;
         scale = 6 * sfsPerScfsi[scfsi[min_ch][min_sb]];
			if((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) &&
			      ((min_ch == 0) || (min_ch == 1))) 
			{
			  /* each new js sb has L+R scfsis */
				seli += 2;
		                scale += 6 * sfsPerScfsi[scfsi[oth_ch][min_sb]];
			}

	}

       /* check to see enough bits were available for */
       /* increasing resolution in the minimum band */

       if(fr_ps->header->ext_bit_stream_present == 1) 
       {
        if((min_ch == 0) || (min_ch == 1))
	{
	    if (adb_mpg1 > bspl_mpg1 + bscf_mpg1 + bsel_mpg1 + seli + scale + increment) 
	    {
		bspl_mpg1 += increment;  /* bits for subband sample */
		bscf_mpg1 += scale;      /* bits for scale factor */
		bsel_mpg1 += seli;       /* bits for scfsi code */
	    }
	    else
		used[min_ch][min_sb] = 2;  /* can't increase this alloc */
	 }
       }
	
       
       if ((ad > bspl + bscf + bsel + seli + scale + increment) && (used[min_ch][min_sb] != 2)) 
       {

          ba = ++bit_alloc[min_ch][min_sb]; /* next up alloc */
          bspl += increment;  /* bits for subband sample */
          bscf += scale;      /* bits for scale factor */
          bsel += seli;       /* bits for scfsi code */
          used[min_ch][min_sb] = 1; /* subband has bits */
          mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +
			 snr[(*alloc)[min_sb][ba].quant+1];

			  
		/* Check if subband has been fully allocated max bits */
          if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;
	}
	else used[min_ch][min_sb] = 2;  /* can't increase this alloc */
	
	
	
	  /****!!! here make a difference between the different JS-modes !!!!****/
	         
		 
						  
	         if((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) && (stereo == 2) &&
			 ((min_ch == 0) || (min_ch == 1))) 
	         {
                        /* above jsbound, alloc applies L+R */
                        ba = bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];
 			used[oth_ch][min_sb] = used[min_ch][min_sb];
                        mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb] +
                               snr[(*alloc)[min_sb][ba].quant+1];
		 }
		 

	 }   /* end of if-loop if min_sb >-1 */
   } while(min_sb > -1);   /* until could find no channel */
   /* Calculate the number of bits left */

   ad -= bspl+bscf+bsel; 
   *adb = ad;
   for (i=sblimit;i<SBLIMIT;i++) for (k = 0; k < 14; k++) /*for all 14 channels, 8/21/93,SR*/ /*JMZ 08/03/1995 Multilingual */
      bit_alloc[k][i]=0;
 
 
 /*not used !?! perhaps later!! 8/21/93, SR*/
   noisy_sbs = 0;  small = mnr[0][0];      /* calc worst noise in case */
   for(k = 0; k < (stereo+stereomc); ++k)
   {
        for (i=0;i<sblimit;i++) 
	{
           if (small > mnr[k][i]) small = mnr[k][i];
	      if(mnr[k][i] < fr_ps->mnr_min) ++noisy_sbs; /* noise is not masked */

        }
    }

/* JMZ 08/03/1995 Multilingual */
if(n_ml_ch>0)
 {
   for(k = 7; k < (7+n_ml_ch); ++k)
   {
        for (i=0;i<sblimit;i++) 
	{
           if (small > mnr[k][i]) small = mnr[k][i];
	      if(mnr[k][i] < fr_ps->mnr_min) ++noisy_sbs; /* noise is not masked */

        }
    }
 }
/* JMZ 08/03/1995 Multilingual */

   return noisy_sbs;
}
 
/************************************************************************
/*
/* I_subband_quantization  (Layer I)
/* II_subband_quantization (Layer II)
/* II_subband_quantisationmc (MPEG2)  SR
/* PURPOSE:Quantizes subband samples to appropriate number of bits
/*
/* SEMANTICS:  Subband samples are divided by their scalefactors, which
/* makes the quantization more efficient. The scaled samples are
/* quantized by the function a*x+b, where a and b are functions of
/* the number of quantization levels. The result is then truncated
/* to the appropriate number of bits and the MSB is inverted.
/*
/* Note that for fractional 2's complement, inverting the MSB for a
/* negative number x is equivalent to adding 1 to it.
/*
/************************************************************************/
 
static double a[17] = {
  0.750000000, 0.625000000, 0.875000000, 0.562500000, 0.937500000,
  0.968750000, 0.984375000, 0.992187500, 0.996093750, 0.998046875,
  0.999023438, 0.999511719, 0.999755859, 0.999877930, 0.999938965,
  0.999969482, 0.999984741 };
 
static double b[17] = {
  -0.250000000, -0.375000000, -0.125000000, -0.437500000, -0.062500000,
  -0.031250000, -0.015625000, -0.007812500, -0.003906250, -0.001953125,
  -0.000976563, -0.000488281, -0.000244141, -0.000122070, -0.000061035,
  -0.000030518, -0.000015259 };
 
/**************************************************/
/* 08/03/1995 JMZ Multilingual */

void II_subband_quantization_ml(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
                                    
                                      
                                    
                                  
                                    
                                         /*10/03/1995 JMZ Multilingual */
                    
{
   int i, j, k, s, n, qnt, sig, m, l, ll;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   unsigned int stps;
   double d;
   al_table *alloc = fr_ps->alloc;
   int n_ml_ch = fr_ps->header->multiling_ch;

for (s=0;s<3;s++)
for (j=0;j<12;j++)
for (i=0;i<sblimit;i++)
{
	for (m = 7; m < 7+n_ml_ch; ++m)
	{
		k=m;
		if(bit_alloc[k][i])
			d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
		if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
		{ printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		  printf("Value %1.10f\n",sb_samples[k][s][j][i]);
		}
		qnt = (*alloc)[i][bit_alloc[k][i]].quant;
		d = d * a[qnt] + b[qnt];
		/* extract MSB N-1 bits from the floating point sample */
		if (d >= 0) sig = 1;
		else { sig = 0; d += 1.0; }
		n = 0;
		stps = (*alloc)[i][bit_alloc[k][i]].steps;
		while ((1L<<n) < stps) n++;
		n--;
		sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
   	          /* tag the inverted sign bit to sbband at position N */
   	          /* The bit inversion is a must for grouping with 3,5,9 steps
   	             so it is done for all subbands */
		if (sig) sbband[k][s][j][i] |= 1<<n;
		if(bit_alloc[k][i] == 0) sbband[k][s][j][i] = 0;
	}
} 
for (s=0;s<3;s++)
for (j=sblimit;j<SBLIMIT;j++)
for (i=0;i<12;i++) for (k = 7; k < 7+n_ml_ch; k++) sbband[k][s][i][j] = 0;
}
/* 08/03/1995 JMZ Multilingual */
/**************************************************/

void I_subband_quantization(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
                                    
       /*far*/                               
                                    
       /*far*/                             /* L+R for j-stereo if necess */
                                   
             /*far*/                           
                    
{
   int i, j, k, n, sig;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   double d;
static char init = 0;

   if (!init) {
     init = 1;
     /* rearrange quantization coef to correspond to layer I table */
     a[1] = a[2]; b[1] = b[2];
     for (i=2;i<15;i++) { a[i] = a[i+2]; b[i] = b[i+2]; }
   }
   for (j=0;j<12;j++) for (i=0;i<SBLIMIT;i++)
     for (k=0;k<((i<jsbound)?stereo:1);k++)
       if (bit_alloc[k][i]) {
         /* for joint stereo mode, have to construct a single subband stream
            for the js channels.  At present, we calculate a set of mono
            subband samples and pass them through the scaling system to
            generate an alternate normalised sample stream.
 
            Could normalise both streams (divide by their scfs), then average
            them.  In bad conditions, this could give rise to spurious
            cancellations.  Instead, we could just select the sb stream from
            the larger channel (higher scf), in which case _that_ channel
            would be 'properly' reconstructed, and the mate would just be a
            scaled version.  Spec recommends averaging the two (unnormalised)
            subband channels, then normalising this new signal without
            actually sending this scale factor... This means looking ahead.
         */
         if(stereo == 2 && i>=jsbound)
           /* use the joint data passed in */
			  d = j_samps[0][0][j][i] / multiple[j_scale[0][0][i]];
         else
           d = sb_samples[k][0][j][i] / multiple[scalar[k][0][i]];
         /* scale and quantize floating point sample */
         n = bit_alloc[k][i];
         d = d * a[n-1] + b[n-1];
         /* extract MSB N-1 bits from the floating point sample */
         if (d >= 0) sig = 1;
         else { sig = 0; d += 1.0; }
         sbband[k][0][j][i] = (unsigned int) (d * (double) (1L<<n));
         /* tag the inverted sign bit to sbband at position N */
         if (sig) sbband[k][0][j][i] |= 1<<n;
       }
}
 
/***************************** Layer II  ********************************/
 
void II_subband_quantization(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
                                    		/* 08/03/1995 JMZ Multilingual */
       /*far*/                                /* 08/03/1995 JMZ Multilingual */
                                    
       /*far*/                            
                                    		/* 08/03/1995 JMZ Multilingual */
             /*far*/                            /*08/03/1995 JMZ Multilingual*/
                    
{
   int i, j, k, s, n, qnt, sig, l, m;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   unsigned int stps;
   double d;
   al_table *alloc = fr_ps->alloc;

   for (s=0;s<3;s++)
     for (j=0;j<12;j++)
       for (i=0;i<sblimit;i++)
         for (k=0;k<((i<jsbound)?stereo:1);k++)
	 {

	     if (bit_alloc[k][i])
	     {
               /* scale and quantize floating point sample */
               if(stereo == 2 && i>=jsbound)       /* use j-stereo samples */
	         d = j_samps[0][s][j][i] / multiple[j_scale[0][s][i]];
               else
                 d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];

	       if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
	       {
         		printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
			printf("Value %1.10f\n",sb_samples[k][s][j][i]);
			printf("Channel %d\n", k);
	       }
	       qnt = (*alloc)[i][bit_alloc[k][i]].quant;
               d = d * a[qnt] + b[qnt];
               /* extract MSB N-1 bits from the floating point sample */
               if (d >= 0) sig = 1;
               else { sig = 0; d += 1.0; }
               n = 0;
#ifndef MS_DOS
               stps = (*alloc)[i][bit_alloc[k][i]].steps;
               while ((1L<<n) < stps) n++;
#else
               while  ( ( (unsigned long)(1L<<(long)n) <
	              ( (unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
                          & 0xffff)) && ( n <16)) n++;
#endif
               n--;
               sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
               /* tag the inverted sign bit to sbband at position N */
               /* The bit inversion is a must for grouping with 3,5,9 steps
                so it is done for all subbands */
               if (sig) sbband[k][s][j][i] |= 1<<n;
	     } 
          }
           for (s=0;s<3;s++)
             for (j=sblimit;j<SBLIMIT;j++)
               for (i=0;i<12;i++) 
	         for (m=0;m<stereo;m++)
		 sbband[m][s][i][j] = 0;
}





void II_subband_quantizationmc(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps)
                                    	/* 08/03/1995 JMZ Multilingual */
                                      	/* 08/03/1995 JMZ Multilingual */
                                    
                                  
                                    	/* 08/03/1995 JMZ Multilingual */
                                        /* 08/03/1995 JMZ Multilingual */
                    
{
   int i, j, k, s, n, qnt, sig, m, l, ll;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   unsigned int stps;
   double d;
   al_table *alloc = fr_ps->alloc;

 


   for (s=0;s<3;s++)
     for (j=0;j<12;j++)
	 for (i=0;i<sblimit;i++)
	 {
	    if(i == 0)
		ll = 0;
	    else
	    {
                for(l = 1; l < 12; l++)
                  {
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		    {
                          ll = l;
			  break;
		     }  
		   }
	    }	   
          for (m = 2; m < 5; ++m)
	  {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     {
               if(i == 0) k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	       else
	       {	     
                    k = transmission_channel[fr_ps->header->tc_alloc[ll]][m];
                }
	      }

	   if(fr_ps->header->dyn_cross_on == 1)
	   {
	       if(!dyn_ch[fr_ps->header->dyn_cross[ll]][m-2])
	       bit_alloc[k][i] = 0;

	   }
		    if(bit_alloc[k][i])
	               d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];
	   
	   
	    if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */
	    {
		printf("Not scaled properly, %d %d %d %d\n",k,s,j,i);
		printf("Value %1.10f\n",sb_samples[k][s][j][i]);
	    }
	    qnt = (*alloc)[i][bit_alloc[k][i]].quant;
            d = d * a[qnt] + b[qnt];
             /* extract MSB N-1 bits from the floating point sample */
             if (d >= 0) sig = 1;
             else { sig = 0; d += 1.0; }
             n = 0;
#ifndef MS_DOS
             stps = (*alloc)[i][bit_alloc[k][i]].steps;
             while ((1L<<n) < stps) n++;
#else
             while  ( ( (unsigned long)(1L<<(long)n) <
	                 ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)
                          & 0xffff
                         )
                      ) && ( n <16)
                    ) n++;
#endif
             n--;
             sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));
             /* tag the inverted sign bit to sbband at position N */
             /* The bit inversion is a must for grouping with 3,5,9 steps
                so it is done for all subbands */
             if (sig) sbband[k][s][j][i] |= 1<<n;
	 }
	} 
           for (s=0;s<3;s++)
             for (j=sblimit;j<SBLIMIT;j++)
		for (i=0;i<12;i++) for (k = 2; k < 7; k++) sbband[k][s][i][j] = 0;
}






 
/************************************************************************
/*
/* I_encode_bit_alloc  (Layer I)
/* II_encode_bit_alloc (Layer II)
/* II_encode_bit_allocmc (Layer II multichannel)
/*
/* PURPOSE:Writes bit allocation information onto bitstream
/*
/* Layer I uses 4 bits/subband for bit allocation information,
/* and Layer II uses 4,3,2, or 0 bits depending on the
/* quantization table used.
/*
/************************************************************************/
 
void I_encode_bit_alloc(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
{
   int i,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
 
   for (i=0;i<SBLIMIT;i++)
     for (k=0;k<((i<jsbound)?stereo:1);k++) putbits(bs,bit_alloc[k][i],4);
}
 
/***************************** Layer II  ********************************/
 
void II_encode_bit_alloc(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                    	/* 08/03/1995 JMZ Multilingual */
                    
                     
{
   int i,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   al_table *alloc = fr_ps->alloc;
 
	for (i=0;i<sblimit;i++)
	for (k=0;k<((i<jsbound)?stereo:1);k++)
     	{
		putbits(bs,bit_alloc[k][i],(*alloc)[i][0].bits);

       	}
}




void II_encode_bit_allocmc(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                    	/* 08/03/1995 JMZ Multilingual */
                    
                     
{
   int i,k, l, m;
   int stereo	   = fr_ps->stereomc;
   int sblimit     = fr_ps->sblimit;
   int jsboundmc   = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
   int ll;
 

       for (i=0;i<sblimit;i++)
       {
	
/*	  for(m = 2; m < 5; ++m) 21/03/1995 JMZ Multimode */
	  for(m = 2; m < 2+stereo; ++m)
          {        
	     if(fr_ps->header->tc_sbgr_select == 1)
	     {
               k = transmission_channel[fr_ps->header->tc_allocation][m];
               if(i == 0) ll = 0;
	       else
	       {
                  for(l = 1; l < 12; l++)
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l]))
		    {
		       ll = l;
		       break;
		     }	
	       }
	     }
	     else
	     {
               if(i == 0) 
	       {
		    k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
		    ll = 0;
	       }
	       else
	       {	     
                  for(l = 1; l < 12; l++)
                  {
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l])) 
	            {
                       k = transmission_channel[fr_ps->header->tc_alloc[l]][m];
		       ll = l;
		       break;
	            }
		  }  
                }
	      }

            if((fr_ps->header->center != 3) || (i < 12) || (k !=2))
	    {
	       if(dyn_ch[fr_ps->header->dyn_cross[ll]][m-2] == 1)
	       {
		putbits(bs, bit_alloc[k][i], (*alloc)[i][0].bits);

			}
	    }	
	}
    }	
}


/************************************************************************
/*
/* I_sample_encoding   (Layer I)
/* II_sample_encoding  (Layer II)
/* II_sample_encodingmc  (Layer II) SR
/*
/* PURPOSE:Put one frame of subband samples on to the bitstream
/*
/* SEMANTICS:  The number of bits allocated per sample is read from
/* the bit allocation information #bit_alloc#.  Layer 2
/* supports writing grouped samples for quantization steps
/* that are not a power of 2.
/*
/************************************************************************/
 
void I_sample_encoding(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
             /*far*/                           
                                   
                    
                     
{
   int i,j,k;
   int stereo  = fr_ps->stereo;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
 
   for(j=0;j<12;j++) {
     for(i=0;i<SBLIMIT;i++)
       for(k=0;k<((i<jsbound)?stereo:1);k++)
         if(bit_alloc[k][i]) putbits(bs,sbband[k][0][j][i],bit_alloc[k][i]+1);
   }
}
 
/***************************** Layer II  ********************************/
 
void II_sample_encoding(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                        	/* 08/03/1995 JMZ Multilingual */
                                    		/* 08/03/1995 JMZ Multilingual */
                    
                     
{
   unsigned int temp;
   unsigned int i,j,k,s,x,y;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsbound = fr_ps->jsbound;
   int jsboundmc = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
 
   for (s=0;s<3;s++)
     for (j=0;j<12;j+=3)
       for (i=0;i<sblimit;i++)
         for (k=0;k<((i<jsbound)?stereo:1);k++)
           if (bit_alloc[k][i]) {
             if ((*alloc)[i][bit_alloc[k][i]].group == 3) {
               for (x=0;x<3;x++) putbits(bs,sbband[k][s][j+x][i],
                                      (*alloc)[i][bit_alloc[k][i]].bits);

            }
             else {
               y =(*alloc)[i][bit_alloc[k][i]].steps;
               temp = sbband[k][s][j][i] +
                      sbband[k][s][j+1][i] * y +
                      sbband[k][s][j+2][i] * y * y;
               putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);

             }
           }
}




/******************* Layer II five channels ******************************/


void II_sample_encodingmc(unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)
                                        	/* 08/03/1995 JMZ Multilingual */
                                    		/* 08/03/1995 JMZ Multilingual */
                    
                     
{
   unsigned int temp;
   unsigned int i,j,k,s,x,y, l, m;
   int stereo	= fr_ps->stereo;
   int stereomc = fr_ps->stereomc;
   int sblimit = fr_ps->sblimit;
   int jsboundmc = fr_ps->jsboundmc;
   al_table *alloc = fr_ps->alloc;
   
   for (s=0;s<3;s++)
     for (j=0;j<12;j+=3)
       for (i=0;i<sblimit;i++)
         for (m = 2; m < 5; m++)
	 {
	     if(fr_ps->header->tc_sbgr_select == 1)
               k = transmission_channel[fr_ps->header->tc_allocation][m];
	     else
	     {
               if(i == 0) k = transmission_channel[fr_ps->header->tc_alloc[0]][m];
	       else
	       {	     
                  for(l = 1; l < 12; l++)
                  {
	            if((sb_groups[l-1] < i) && (i <= sb_groups[l])) 
	            {
                       k = transmission_channel[fr_ps->header->tc_alloc[l]][m];
		       break;
	            }
		  }  
                }
	      } 
	     
	 
           if (bit_alloc[k][i]) 
	   {
             if ((*alloc)[i][bit_alloc[k][i]].group == 3) 
	     {
			for (x = 0; x < 3; x++)
			 putbits(bs,sbband[k][s][j+x][i],
                                    (*alloc)[i][bit_alloc[k][i]].bits);

            }
             else 
	     {
               y =(*alloc)[i][bit_alloc[k][i]].steps;
               temp = sbband[k][s][j][i] +
                      sbband[k][s][j+1][i] * y +
                      sbband[k][s][j+2][i] * y * y;
               putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);

             }
           }
	 }
}

/************************************************************************
/*
/* encode_CRC
/*
/************************************************************************/
 
void encode_CRC(unsigned int crc, Bit_stream_struc *bs)
{
   putbits(bs, crc, 16);
}

/***************************************************************************
/*
/* tc_alloc  (Layer II, multichannel)
/*
/* PURPOSE: For each subbandgroup the three transmissionchannels are
/*          determined by taking the channel with the lowest level
/*          according to the tabel tc_allocation in the draft
/*  8/10/93, SR          
/* 
/*           changed to a certain limit of TC_ALLOC which must be stepped
/*           beyond, before there is channel-switching
/*           9/20/93 SR

/* JMZ 08/03/1995 Ajout pour traiter les differentes configurations 
/*		envisagees dans la norme
/**************************************************************************/

void tc_alloc(frame_params *fr_ps, double (*max_sc)[32])
{
	layer 	*info 	= fr_ps->header;	
	int 	center 	= info->center;		
	int 	surround = info->surround;	
	int 	matrix 	= info->matrix;		
    	int 	i, l, k;
    	int 	min;
    	double 	min1;
    	double 	min2[7][12];
	
    
/* if(matrix==3 || (matrix ==2 && center ==3)) ->tc_alloc=0
	else 	if(center==3)			->tc_alloc = 0,3,4,5
		else	if(matrix==2)		->tc_alloc = 0,1,2
			else			->tc_alloc = 0,1,2,3,4,5,6,7 */

/* 01/03/1995 JMZ Configuration 3/2 */
if(surround==2 && center !=0)
{

if(matrix==3 || (matrix ==2 && center ==3))
{
	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
}
else	if(center==3) /* && matrix !=2 && matrix != 3 */
		{
			for(i = 0; i < 8; i++)
			{
				if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
				{
					if(max_sc[6][i] < max_sc[4][i])
						fr_ps->header->tc_alloc[i] = 5;
					else 	fr_ps->header->tc_alloc[i] = 3;
				}  
				else 	if(((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
							fr_ps->header->tc_alloc[i] = 4;
						else   	fr_ps->header->tc_alloc[i] = 0; 
			} 
			
			for(i = 8; i < 12; i++)   
			for(k = 2; k < 7; k++)
				min2[k][i] = 0.0;	 
 
			for(i = 8; i < 12; i++)
			{
				for(k = 2; k < 7; k++)
				{
					for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
						{
							min2[k][i] += max_sc[k][l];	 
						}
					min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
				}

				if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
				{
					if(min2[6][i] < min2[4][i])
						fr_ps->header->tc_alloc[i] = 5;
					else 	fr_ps->header->tc_alloc[i] = 3;
				}  
				else 	if(((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
							fr_ps->header->tc_alloc[i] = 4;
						else   	fr_ps->header->tc_alloc[i] = 0; 
			} 
		}	
		else	
			if(matrix==2)	/* && center !=3 */
			{    
				for(i = 0; i < 8; i++)
				{
					if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
					{
						if(max_sc[6][i] < max_sc[5][i])
							fr_ps->header->tc_alloc[i] = 2;
						else 	
							fr_ps->header->tc_alloc[i] = 1;
					}  
					else 	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
									fr_ps->header->tc_alloc[i] = 2;
							else   	fr_ps->header->tc_alloc[i] = 0; 
				} 
				
				for(i = 8; i < 12; i++)   
				for(k = 2; k < 7; k++)
					min2[k][i] = 0.0;	 
 
				for(i = 8; i < 12; i++)
				{
					for(k = 2; k < 7; k++)
					{
						for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
							{
								min2[k][i] += max_sc[k][l];	 
							}
						min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
					}

					if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
					{
						if(min2[6][i] < min2[5][i])
							fr_ps->header->tc_alloc[i] = 2;
						else 	
							fr_ps->header->tc_alloc[i] = 1;
					}  
					else 	if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
									fr_ps->header->tc_alloc[i] = 2;
							else   	fr_ps->header->tc_alloc[i] = 0; 
				} 
			}
			else
			{	
	
    for(i = 0; i < 8; i++)
    {
       if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
       {
           if(max_sc[6][i] < max_sc[5][i])
              min = 6;
	   else if(max_sc[6][i] == max_sc[5][i])
	   {
	       if(max_sc[3][i] <= max_sc[5][i])
	           min = 5;
	       else min = 6;	          
	   }
	   else min = 5;
       }  
       else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
       {
	min = 6;
	/* 01/03/1995 JMZ Simplification */
       }  
       else   	  	    
       {
	      min = 2;
       }
	
	switch(min)
	{
	    case 5: if(max_sc[4][i] <= max_sc[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(max_sc[3][i] <= max_sc[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;		    
	    case 2: if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	            {
	               if(max_sc[4][i] <= max_sc[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
  }

 for(i = 8; i < 12; i++)   
   for(k = 2; k < 7; k++)
        min2[k][i] = 0.0;	 
 
 
 for(i = 8; i < 12; i++)    /*taking the average scalefactor of each sb-group*/
 {
   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

    if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
    {
        if(min2[6][i] < min2[5][i])
           min = 6;
        else if(min2[6][i] == min2[5][i])
	{
	       if(min2[3][i] <= min2[5][i])
	           min = 5;
	       else min = 6;	          
	}
        else min = 5;
    }  
    else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
    {
	min = 6;
	/* 01/03/1995 JMZ Simplification */
    }  
    else   	  	    
    {
           min = 2;
    }
	
	switch(min)
	{
	    case 5: if(min2[4][i] <= min2[6][i])  /* left front,Rs*/
	              fr_ps->header->tc_alloc[i] = 1;
		    else fr_ps->header->tc_alloc[i] = 7;  /*R*/
		    break;
	    case 6: if(min2[3][i] <= min2[5][i])  /* right front,Ls*/
	              fr_ps->header->tc_alloc[i] = 2;
		    else fr_ps->header->tc_alloc[i] = 6;  /* L */
		    break;
	    case 2: if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	            {
	               if(min2[4][i] <= min2[6][i])  
		         fr_ps->header->tc_alloc[i] = 3;
		       else fr_ps->header->tc_alloc[i] = 5;
		    }  
		    else
		    {
	               if(((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  
		         fr_ps->header->tc_alloc[i] = 4;
		       else fr_ps->header->tc_alloc[i] = 0;
		    }    
		    break;
	}
   
 }
			}
}

/* 01/03/1995 JMZ Configuration 3/1 */
/**/
if (surround==1 && center !=0)
{

if(matrix==3 || (matrix ==2 && center ==3))
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	if(center==3) /* && matrix !=2 && matrix != 3 */
	{
	for(i = 0; i < 8; i++)
	{
		if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
		{
			if(max_sc[6][i] < max_sc[5][i])
				fr_ps->header->tc_alloc[i] = 4;
			else 	fr_ps->header->tc_alloc[i] = 3;
		}  
		else 	if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
				fr_ps->header->tc_alloc[i] = 4;
			else   	fr_ps->header->tc_alloc[i] = 0; 
	} 
	
	for(i = 8; i < 12; i++)   
	for(k = 2; k < 7; k++)
		min2[k][i] = 0.0;	 
 
	for(i = 8; i < 12; i++)    
	{
		for(k = 2; k < 7; k++)
		{
			for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
			{
				min2[k][i] += max_sc[k][l];	 
			}
			min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
		}
		
		if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
		{
			if(min2[6][i] < min2[5][i])
				fr_ps->header->tc_alloc[i] = 4;
			else 	
				fr_ps->header->tc_alloc[i] = 3;
		}  
		else 	
			if(((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
				fr_ps->header->tc_alloc[i] = 4;
			else   	
				fr_ps->header->tc_alloc[i] = 0; 
	} 
	

	}	
	else	if(matrix==2)	/* && center !=3 */
		{    
		for(i = 0; i < 8; i++)
		{
			if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
			{
				if(max_sc[6][i] < max_sc[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	fr_ps->header->tc_alloc[i] = 0; 
		}
		 
		for(i = 8; i < 12; i++)   
		for(k = 2; k < 7; k++)
			min2[k][i] = 0.0;	 
 
		for(i = 8; i < 12; i++)    
		{
			for(k = 2; k < 7; k++)
			{
				for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
				{
					min2[k][i] += max_sc[k][l];	 
				}
				min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
			}
		
			if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
			{
				if(min2[6][i] < min2[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	
					fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	
				if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	
					fr_ps->header->tc_alloc[i] = 0; 
		}
		}
		else
			{	
	
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[5][i])
			min = 6;
		else 	min = 5;
	}  
	else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
			{
				if(max_sc[6][i] <= max_sc[5][i])  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 3;
			}  
			else
			{
				if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 0;
			}    
			break;
	}
  }
 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[5][i])
			min = 6;
		else 	min = 5;
	}  
	else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: if(((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
			{
				if(min2[6][i] <= min2[5][i])  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 3;
			}  
			else
			{
				if(((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  
					fr_ps->header->tc_alloc[i] = 4;
				else fr_ps->header->tc_alloc[i] = 0;
			}    
			break;
	}
  }
			}
}
/*******************************************************************/
     
/* 01/03/1995 JMZ Configuration 3/0 (+2/0) */
/**/
if (center !=0 && (surround == 3 || surround ==0))
{

if(matrix==3 || center ==3)
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	if(matrix==2) 
	{
		for(i = 0; i < 8; i++)
		{
			if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
			{
				if(max_sc[6][i] < max_sc[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	fr_ps->header->tc_alloc[i] = 0; 
		} 
		
		for(i = 8; i < 12; i++)   
		for(k = 2; k < 7; k++)
			min2[k][i] = 0.0;	 
 
		for(i = 8; i < 12; i++)    
		{
			for(k = 2; k < 7; k++)
			{
				for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
				{
					min2[k][i] += max_sc[k][l];	 
				}
				min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
			}
		
			if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
			{
				if(min2[6][i] < min2[5][i])
					fr_ps->header->tc_alloc[i] = 2;
				else 	fr_ps->header->tc_alloc[i] = 1;
			}  
			else 	if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
					fr_ps->header->tc_alloc[i] = 2;
				else   	fr_ps->header->tc_alloc[i] = 0; 
		} 
	}
	else
		{	
	
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }

 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }
		}
}
/*******************************************************************/

/* 01/03/1995 JMZ et Configuration 2/1*/
/**/

if (center == 0 && surround ==1)
{

if(matrix==3 )
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	
{
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }

 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[5][i])
			min = 6;
		else	min = 5;
	}  
	else if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			min = 6;
		}  
		else   	  	    
		{
			min = 2;
		}
	
	switch(min)
	{
		case 5: 
			fr_ps->header->tc_alloc[i] = 1;
			break;

		case 6: 
			fr_ps->header->tc_alloc[i] = 2;
			break;
		    
		case 2: 
			fr_ps->header->tc_alloc[i] = 0;
			break;
	}
 }
}
}
/*******************************************************************/

/* 01/03/1995 JMZ Configuration 2/2 */
/**/

if (center == 0 && surround == 2)
{

if(matrix==3 )
  {
    	for(i = 0; i < 12; i++)
	{
		fr_ps->header->tc_alloc[i] = 0;
	}
  }
else	
{
 for(i = 0; i < 8; i++)
 {
	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)
	{
		if(max_sc[6][i] < max_sc[3][i])
			fr_ps->header->tc_alloc[i] = 3;
		else 	
			fr_ps->header->tc_alloc[i] = 2;
	}  
	else if(((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)
		{
			fr_ps->header->tc_alloc[i] = 1;
		}  
		else   	  	    
		{
			fr_ps->header->tc_alloc[i] = 0;
		}
 }

 for(i = 8; i < 12; i++)   
 for(k = 2; k < 7; k++)
	min2[k][i] = 0.0;	 
 
 for(i = 8; i < 12; i++)
 {

   for(k = 2; k < 7; k++)
   {
     for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)
     {
        min2[k][i] += max_sc[k][l];	 
     }
   min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 
   }

	if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)
	{
		if(min2[6][i] < min2[3][i])
			fr_ps->header->tc_alloc[i] = 3;
		else 	
			fr_ps->header->tc_alloc[i] = 2;
	}  
	else if(((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)
		{
			fr_ps->header->tc_alloc[i] = 1;
		}  
		else   	  	    
		{
			fr_ps->header->tc_alloc[i] = 0;
		}
 }
 }
 }
 
/*******************************************************************/
     
    if(fr_ps->header->tc_alloc[0] == fr_ps->header->tc_alloc[1] &&
       fr_ps->header->tc_alloc[1] == fr_ps->header->tc_alloc[2] &&
       fr_ps->header->tc_alloc[2] == fr_ps->header->tc_alloc[3] &&
       fr_ps->header->tc_alloc[3] == fr_ps->header->tc_alloc[4] &&
       fr_ps->header->tc_alloc[4] == fr_ps->header->tc_alloc[5] &&
       fr_ps->header->tc_alloc[5] == fr_ps->header->tc_alloc[6] &&
       fr_ps->header->tc_alloc[6] == fr_ps->header->tc_alloc[7] &&
       fr_ps->header->tc_alloc[7] == fr_ps->header->tc_alloc[8] &&
       fr_ps->header->tc_alloc[8] == fr_ps->header->tc_alloc[9] &&
       fr_ps->header->tc_alloc[9] == fr_ps->header->tc_alloc[10] &&
       fr_ps->header->tc_alloc[10] == fr_ps->header->tc_alloc[11])
       {
          fr_ps->header->tc_sbgr_select = 1;
          fr_ps->header->tc_allocation = fr_ps->header->tc_alloc[0];
       }
      else fr_ps->header->tc_sbgr_select = 0; /* added 8/20/93,SR*/ 
}


	
   	


