#include "xo_head.h"
#include	"LayoutP.h"
#include 	"XoWhen.h"
#include	"XoClickBuffer.h"

/*
** execute_button:	Callback which executes the script attached to a button
**
*/
execute_button(w, client, call)
	Widget	w;
	caddr_t	client;
	caddr_t	call;
{
	LayoutWidget	lw;
	int	argc;
	char 	**argv;
	char 	*widgetname;
	int	i;

	lw = (LayoutWidget)w;
	if(client && client[0] != '\0'){
		if (w->core.constraints != NULL)
			widgetname = (char *)Pathname(((LayoutConstraints)
				(w->core.constraints))->
				layout.layout_element);
		else
			widgetname = (char *)Pathname(
				lw->layout.layout_element);
		StringToArgList(client,&argc,&argv,0);
		/*
		** substitute %% args with the widget name
		*/
		for(i=0;i<argc;i++){
			if(strcmp(argv[i],"<widget>") == 0){
				argv[i] = (char *)malloc(strlen(widgetname)+1);
				strcpy(argv[i],widgetname);
			}
		}	
		ExecuteFunction(argc,argv);
    	}
}

/*
** Upi's button executer routine 
**
*/
XoExecuteButton(w,event)
	Widget	w;
	XButtonEvent	*event;
{
	Arg		args[2];
	int		n;
	XoWhen	*when;

	when = NULL;
	last_click = current_click;
	current_click.w = w;
	current_click.button = event->button;
	current_click.ok = 1;

	n = 0;
	XtSetArg(args[n],XtNwhen,&when); n++;
	XtGetValues(w,args,n);

	for ( ; when ; when = when->next)  {
		if (strcmp(when->action,XoClick) == 0 &&
			when->button == event->button ) {
			execute_button(w,when->script,NULL);
		}
	}
}

/*
** Upi's execute for children of draws... 
**
*/
execute_parent_script(w, client, call)
	Widget	w;
	caddr_t	client;
	caddr_t	call;
{
	int	argc;
	char 	**argv;
	char 	*widgetname;
	int	i;

	if(client && client[0] != '\0'){
		widgetname = (char *)Pathname(((LayoutConstraints)
			(XtParent(w)->core.constraints))->
			layout.layout_element);
		StringToArgList(client,&argc,&argv,0);
		/*
		** substitute %% args with the widget name
		*/
		for(i=0;i<argc;i++){
			if(strcmp(argv[i],"<widget>") == 0){
				argv[i] = (char *)malloc(strlen(widgetname)+1);
				strcpy(argv[i],widgetname);
			}
		}	
		ExecuteFunction(argc,argv);
	}
}
