/* 
** graph_w.c: outer graph widget routines
**
** Written by:	Upinder S. Bhalla 	(bhalla@aurel.caltech.edu)
**		John Uhley 		(uhley@tybalt.caltech.edu)
**
** Copyright 1988 by the California Institute of Technology
**
** Permission to use, copy, modify, and distribute this
** software and its documentation for any purpose and without
** fee is hereby granted, provided that the above copyright
** notice appear in all copies and that both that copyright
** notice and this permission notice appear in supporting
** documentation, and that the name of the California Institute
** of Technology not be used in advertising or publicity pertaining 
** to distribution of the software without specific, written prior 
** permission.  The California Institute of Technology makes no 
** representations about the suitability of this software for any purpose.
** It is provided "as is" without express or implied warranty.
** 
** The Xgraph Widget library was written by Upinder S. Bhalla and
** John Uhley.  Portions of the labeling routines were taken from
** David Harrison's xgraph (X10V4) program with his permission.
**
** The X Window system is copyright 1985, 1986, 1987 By the
** Massachusetts Institute of Technology, without whom none of this
** code would have been possible.
**
*/

#ifndef _Graph_P_h
#include "graph_w.h"
#include "innergraph_w.h"

#define PADDING	5
#define TICKSIZE 10

typedef struct _GraphClass{
  int make_compiler_happy;
}GraphClassPart;

typedef struct _GraphClassRec{
	CoreClassPart core_class;
	CompositeClassPart composite_class;
 	LabelClassPart label_class;
	GraphClassPart graph_class;
}GraphClassRec, *GraphWidgetClass;

extern GraphClassRec graphClassRec;

typedef struct{
  InnerGraphWidget inner_widget;
  float		xmin;		/* INTERNAL RANGES		*/
  float		ymin;
  float		xmax;
  float		ymax;
  char		*xmin_str;	/* XtSetArg ranges for user	*/
  char		*ymin_str;
  char		*xmax_str;
  char		*ymax_str;
  Position	xoffset;	/* offsets needed for labels	*/
  Position	yoffset;
  char		*title;		/* Displayed title		*/
  char		*XUnits;	
  char		*YUnits;	
}GraphPart;

typedef struct _GraphRec{
  CorePart core;
  CompositePart composite;
  LabelPart	label;
  GraphPart graph;
}GraphRec;


/* A very bad kludge, but in the interests of time... 		*/
/* Sorry folks :- JU						*/
extern	XFontStruct	*graph_title_font;
extern	XFontStruct	*graph_axis_font;
extern	int		axis_width;
extern	int		axis_height;
extern	int		title_width;
extern	int		title_height;


#define _Graph_P_h
#endif _Graph_P_h
