#include "widg_ext.h"
#include "XoWhen.h"
#include "button_wP.h"
#include "LayoutP.h"


static XtResource resources[] = {
	{XtNcallback,  XtCCallback,  XtRCallback,  sizeof(caddr_t), 
		XtOffset(ButtonWidget,  button.my_callback_list), 
		XtRCallback,  (caddr_t)NULL
	}, 
	{XtNwhen,  XtCWhen,  XtRPointer,  sizeof(caddr_t), 
		XtOffset(ButtonWidget,  button.when), 
		XtRString,  (caddr_t)NULL
	}, 
};

static void Destroy();
static void button_init();
void buttonNotify();
static void Set(),  Unset(),  Highlight(),  Unhighlight();
Boolean ButtonSetValues();

void buttonDisplay();

static char translations[] = "<EnterWindow>:Highlight()\n\
							<LeaveWindow>:Unhighlight()\n\
							<BtnDown>:	Set()\n\
							<BtnUp>:	buttonNotify() Unset()";

static XtActionsRec actionsList[] = {
		{"Highlight",  Highlight}, 
		{"Unhighlight",  Unhighlight}, 
		{"Set",  Set}, 
		{"Unset",  Unset}, 
		{"buttonNotify",  buttonNotify}, 
};

#ifdef X11R3
ButtonClassRec buttonClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &labelClassRec, 
    /* class_name		*/	"Button", 
    /* widget_size		*/	sizeof(ButtonRec), 
    /* class_initialize		*/	NULL, 
    /* class_part_initialize	*/	NULL, 
    /* class_inited		*/	FALSE, 
    /* initialize		*/	button_init, 
    /* initialize_hook		*/	NULL, 
    /* realize			*/	XtInheritRealize, 
    /* actions			*/	actionsList, 
    /* num_actions		*/	XtNumber(actionsList), 
    /* resources		*/	resources, 
    /* num_resources		*/	XtNumber(resources), 
    /* xrm_class		*/	NULLQUARK, 
    /* compress_motion		*/	TRUE, 
    /* compress_exposure	*/	TRUE, 
    /* compress_enterleave	*/	TRUE, 
    /* visible_interest		*/	FALSE, 
    /* destroy			*/	Destroy, 
    /* resize			*/	XtInheritResize, 
    /* expose			*/	buttonDisplay, 
    /* set_values		*/	ButtonSetValues, 
    /* set_values_hook		*/	NULL, 
    /* set_values_almost	*/	XtInheritSetValuesAlmost, 
    /* get_values_hook		*/	NULL, 
    /* accept_focus		*/	NULL, 
    /* version			*/	XtVersion, 
    /* callback_private		*/	NULL, 
    /* tm_table			*/	translations, 
    /* query_geometry		*/	XtInheritQueryGeometry, 
    /* display_accelerator	*/	XtInheritDisplayAccelerator, 
    /* extension		*/	NULL
  }, 
  { /* template fields */
    /* empty			*/	0
  }    
};
#else
ButtonClassRec buttonClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &labelClassRec, 
    /* class_name		*/	"Button", 
    /* widget_size		*/	sizeof(ButtonRec), 
    /* class_initialize		*/	NULL, 
    /* class_part_initialize	*/	NULL, 
    /* class_inited		*/	FALSE, 
    /* initialize		*/	button_init, 
    /* initialize_hook		*/	NULL, 
    /* realize			*/	XtInheritRealize, 
    /* actions			*/	actionsList, 
    /* num_actions		*/	XtNumber(actionsList), 
    /* resources		*/	resources, 
    /* num_resources		*/	XtNumber(resources), 
    /* xrm_class		*/	NULLQUARK, 
    /* compress_motion		*/	TRUE, 
    /* compress_exposure	*/	TRUE, 
    /* compress_enterleave	*/	TRUE, 
    /* visible_interest		*/	FALSE, 
    /* destroy			*/	Destroy, 
    /* resize			*/	XtInheritResize, 
    /* expose			*/	buttonDisplay, 
    /* set_values		*/	ButtonSetValues, 
    /* set_values_hook		*/	NULL, 
    /* set_values_almost	*/	XtInheritSetValuesAlmost, 
    /* get_values_hook		*/	NULL, 
    /* accept_focus		*/	NULL, 
    /* version			*/	XtVersion, 
    /* callback_private		*/	NULL, 
    /* tm_table			*/	translations, 
    /* query_geometry		*/	XtInheritQueryGeometry, 
    /* display_accelerator	*/	XtInheritDisplayAccelerator, 
    /* extension		*/	NULL
  },   /* CoreClass fields initialization */
  {
    XtInheritChangeSensitive	/* change_sensitive */
  },   /* SimpleClass fields initialization */
  {
    /* empty			*/	0
  },   /* LabelClass fields initialization */
  { /* template fields */
    /* empty			*/	0
  }    /* ButtonClass fields initialization */
};
#endif X11R3

WidgetClass buttonWidgetClass = (WidgetClass)&buttonClassRec;

/*
** button_init:	Init the button.  In this case we just want to 
**		create and set the default GC
**
*/
static void
button_init(w)
	Widget	w;
{
	GC	gc;
	XGCValues	values;

/*
	gc = XtGetGC((Widget)w, GCForeground,  &values) ;
	XSetForeground(XtDisplay(w), gc, xbutton_up_fg);
	XSetBackground(XtDisplay(w), gc, xbutton_up_bg);
*/
}
	
/*
** buttonNotify:	Called to change the button state.  
**			Calls any LayoutWidget callbacks which might
**			have been tagged onto this button and then
**			executes the desired script.
**
*/ 
void buttonNotify(w,  event)
	ButtonWidget w;
	XEvent *event;
{
	int		i;
	XtCallbackRec	*callback;

	if (((LayoutConstraints)(w->core.constraints))->layout.layout_callback 
		!= NULL) {
			callback = (XtCallbackRec *)
				(((LayoutConstraints)
				(w->core.constraints))->
				layout.layout_callback);
			i = 0;
			while (callback[i].callback != NULL) {
				(callback[i].callback)(w,
				callback[i].closure, NULL);
				i++;
			}
	}
	XtCallCallbacks(w,  XtNcallback,NULL);
	XoExecuteButton(w,event);
}

/*
** Destroy:	Called when this widget is destroyed.
**
*/
static void Destroy(w)
		 Widget w;
{
	if (XtHasCallbacks(w, XtNcallback) == XtCallbackHasSome)
		XtRemoveAllCallbacks(w,  XtNcallback);
	XtDestroyWidget(w);
}

/*
** ButtonDisplay:	Called to redisplay a button widget.
**			can be called Publically.
**
*/
void
buttonDisplay(w, event)
	ButtonWidget	w;
	XEvent	*event;
{
	GC	gc;
	XGCValues	values;

	gc = XtGetGC((Widget)w, GCForeground|GCBackground,  &values) ;
	XSetForeground(XtDisplay(w), gc, w->label.foreground);
	XSetBackground(XtDisplay(w), gc, w->core.background_pixel);

	XoDrawCenteredString (XtDisplay(w),  XtWindow(w),  gc, 
		w->label.label, w->core.width/2, w->core.height/2);
}

static void Highlight(w,event)
	ButtonWidget	w;
	XEvent	*event;
{
	Arg args[3];
	XWindowChanges	wcs;
	int n = 0;
		XtSetArg(args[n], XtNborderWidth, 2); n++;
		XtSetArg(args[n], XtNborderColor, xbutton_hilight); n++;
		XtSetValues(w,args,n);
	/*
	if (color_flag) {
	} else {
		wcs.border_width = 2;
		XConfigureWindow(XtDisplay(w), XtWindow(w),
			CWBorderWidth, &wcs);
	}
	*/
}

static void Unhighlight(w,event)
	ButtonWidget	w;
	XEvent	*event;
{
	Arg args[3];
	XWindowChanges	wcs;
	int n = 0;
		XtSetArg(args[n], XtNborderWidth, 1); n++;
		XtSetArg(args[n], XtNborderColor, xbutton_unhilight); n++;
		XtSetValues(w,args,n);
	/*
	if (color_flag) {
	} else {
		wcs.border_width = 1;
		XConfigureWindow(XtDisplay(w), XtWindow(w),
			CWBorderWidth, &wcs);
	}
	*/
}

static void Set(w,event)
	ButtonWidget	w;
	XEvent	*event;
{
	GC	gc;
	XGCValues	values;
	Arg args[3];
	int n = 0;
	gc = XtGetGC((Widget)w, GCForeground|GCBackground,  &values) ;
	
		XtSetArg(args[n], XtNbackground, xbutton_down_bg); n++;
		XtSetArg(args[n], XtNforeground, xbutton_down_fg); n++;
		XtSetValues(w,args,n);
	/*
		XSetForeground(XtDisplay(w), gc, xbutton_down_fg);
		XSetBackground(XtDisplay(w), gc, xbutton_down_bg);
	if (color_flag){ 
	} else {
		XtSetArg(args[n], XtNbackground, BlackColor); n++;
		XtSetArg(args[n], XtNforeground, WhiteColor); n++;
		XSetForeground(XtDisplay(w), gc, WhiteColor);
		XSetBackground(XtDisplay(w), gc, BlackColor);
		XtSetValues(w,args,n);
	}	
	XFillRectangle(XtDisplay(w), XtWindow(w), gc, 0 , 0,
		w->core.width, w->core.height);
	XoDrawCenteredString (XtDisplay(w),  XtWindow(w),  gc, 
		w->label.label, w->core.width/2, w->core.height/2);
	*/
}

static void Unset(w,event)
	ButtonWidget	w;
	XEvent	*event;
{
	GC	gc;
	XGCValues	values;
	Arg args[3];
	int n = 0;
	gc = XtGetGC((Widget)w, GCForeground,  &values) ;
		XtSetArg(args[n], XtNbackground, xbutton_up_bg); n++;
		XtSetArg(args[n], XtNforeground, xbutton_up_fg); n++;
		XtSetValues(w,args,n);
	/*
		XSetBackground(XtDisplay(w), gc, xbutton_up_bg);
		XSetForeground(XtDisplay(w), gc, xbutton_down_fg);
	if (color_flag) {
	} else {
		XtSetArg(args[n], XtNbackground, WhiteColor); n++;
		XtSetArg(args[n], XtNforeground, BlackColor); n++;
		XSetBackground(XtDisplay(w), gc, WhiteColor);
		XSetForeground(XtDisplay(w), gc, BlackColor);
		XtSetValues(w,args,n);
	}
	XFillRectangle(XtDisplay(w), XtWindow(w), gc, 0 , 0,
		w->core.width, w->core.height);
	XoDrawCenteredString (XtDisplay(w),  XtWindow(w),  gc, 
		w->label.label, w->core.width/2, w->core.height/2);
	*/
}

Boolean ButtonSetValues(current,request,new)
	ButtonWidget	current;
	ButtonWidget	request;
	ButtonWidget	new;
{
	if (current->core.background_pixel != request->core.background_pixel ||
		current->core.border_width != request->core.border_width ||
		current->label.foreground != request->label.foreground)
		return(TRUE);
	/*
	if (current->bg != request->bg ||
		current->fg != request->fg)
		return(TRUE);
	*/
}
