#include "gen_ext.h"
#include "draw_w.h"

int	XoCreateView();

void xview_callback(w, client, call)
	LayoutWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xview_type	*element;

	element = (struct xview_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (element == NULL) {
		fprintf(stderr,"xview_callback: null element\n");
		return;
	}
	xodus_core_set(element, w);
}

xview_func(element,action)
	struct xview_type *element;
	Action		*action;
{
	char	*field, *value;
	LayoutWidget	widget;
	static	XtCallbackRec	callback[2];
	static struct valid_arg xview_args[] = {
		{"pix", 0, 2},
		{"pixname", 0, 2},
		{"viewmode", 0, 2},
		{"viewicon", 0, 2},
		{"pixcolor", 0, 2},
		{"hlhistmode", 0, 2},
		{"hldispmode", 0, 2},
		{"path", 0, 2},
		{"field", 0, 2},
		{"vmin", 0, 2},
		{"vmax", 0, 2},
		{"autoscale", 0, 2},
		{"nx", 0, 2},
		{"ny", 0, 2},
		{"autospace", 0, 2},
		{"ox", 0, 2},
		{"oy", 0, 2},
		{"oz", 0, 2},
		{"END", -1, -1}
	};

	if(debug > 1){
		ActionHeader("Xview",element,action);
	}
	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	switch(action->type) {
		case PROCESS :
			update_pix(((struct xdraw_type *)(element->parent))->widget,
				(Pix *)(element->pix));
			break;
    	case CREATE: 
				XoCreateElmPix(element,
					((struct xdraw_type *)action->data)->widget,
					action->argc, action->argv, XoCreateView);
			break;
    	case DELETE:
                drop_pix(Pathname(element->parent),
                                ((Pix *)(element->pix))->name);
			break;
    	case SET:
			if (x_parse_set(action->argc, action->argv, 
				xview_args))
			XoSetElmPix(element, action->argc, action->argv);
			break;
		case RESET:
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
		default:
			InvalidAction("Xview",element,action);
			break;
	}
	return(1);
}

xview_update(argc,argv)
	int	argc;
	char	**argv;
{

}
