#include "gen_ext.h"
#include "xodus_args.h"
#include "graph_w.h"

static	int	xaxisgraph_parser();

xaxisgraph_callback(w, client, call)
	LayoutWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xaxisgraph_type	*output;
	output = (struct xaxisgraph_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (output == NULL) {
		fprintf(stderr,"xaxisgraph_callback: null element\n");
		return;
	}
	xodus_core_set(output, w);
}

xaxisgraph_func(element,action)
struct xaxisgraph_type *element;
Action		*action;
{
	PFI	func;
	float 	y;
	struct xaxisgraph_type *new;
	char	**argv;
	float 	y1;
	float 	y2;
	float 	x;
	char 	*itoa();
	int 	i;
	char	plotname[80];
	int 	ndata;
	MsgIn	*msg;
	MsgIn	*msg2;
	char	*valuestr;
	char	*field, *value;
	LayoutWidget	widget;
	LayoutConstraints	widget_const;
	int	n;
	Arg	arg[10];
	static	XtCallbackRec	callback[2];
	static struct valid_arg xgraph_args[] = {
		{"xmin", 0, 2}, 
		{"ymin", 0, 2}, 
		{"xmax", 0, 2}, 
		{"ymax", 0, 2}, 
		{"overlay", 0, 2}, 
		{"xoffset", 0, 2}, 
		{"yoffset", 0, 2}, 
		{"last_plot", 0, 2}, 
		{"phase_plot", 0, 2}, 
		{"XUnits", 0, 2}, 
		{"YUnits", 0, 2}, 
		{"range", 0, 2}, 
		{"END", -1}
	};

	if(debug > 1){
		ActionHeader("xaxisgraph",element,action);
	}
	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}
	callback[0].callback = (XtCallbackProc)xaxisgraph_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;

	switch(action->type) {
    		case CREATE: /* create [xlabel argv0 argv1 argv...] */
			widget = (LayoutWidget)do_axis_graph(action->argc,
				 action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			xfunc_core_create(element, callback);
			element->last_plot = 0;
			element->overlay = 0;
			element->phase_plot = 0;
			element->xoffset = 0.0;
			element->yoffset = 0.0;
			element->xmin = atof(x_arg(ARG_XMIN));
			element->ymin = atof(x_arg(ARG_YMIN));
			element->xmax = atof(x_arg(ARG_XMAX));
			element->ymax = atof(x_arg(ARG_YMAX));
			break;
    		case DELETE:
			genesis_destroy_widget(element);
			free(element->title);
			break;
			
    		case SET:
			argv = (char **) 
				calloc(action->argc + 2,sizeof(char *));
			XoParseCoords(&(action->argc), action->argv, argv);
			if (x_parse_set(action->argc, argv, xgraph_args))
				xfunc_parse_set(element, action->argc, 
					argv, xaxisgraph_parser);
			free(argv);
			break;
		case RESET:
			if(!element->overlay){
				element->last_plot = 0;
				axis_graph_reset(Pathname(element)); 
			} else {
				for(msg=element->msg_in;msg;msg=msg->next){
					switch(msg->type){
					case 0:
						element->last_plot++;
						break;
					}
				}
			}
			break;
		case PROCESS:
			if(!element->phase_plot){
				i=0;
				for(msg=element->msg_in;msg;msg=msg->next){
					switch(msg->type){
					case 0: /* PLOT */
						y = MsgValue(msg,float,0) + i*element->yoffset;
					x = simulation_time + i*element->xoffset;
					sprintf(plotname,"%d %s",
					i+element->last_plot,
					msg->slot[1].data);
					graph_add_pts(element->widget,
					plotname,msg->slot[2].data,x,y);
					i++;
					break;
					case 1: /* PLOTSCALE */
					y = MSGVALUE(msg,3)*MsgValue(msg,float,0) + MSGVALUE(msg,4);
					x = simulation_time + i*element->xoffset;
					sprintf(plotname,"%d %s",
					i+element->last_plot,
					msg->slot[1].data);
					graph_add_pts(element->widget,
					plotname,msg->slot[2].data,x,y);
					i++;
					break;
				}
			}
		} else {
		/*
		** do the phase  plot
		*/
		/*
		** find the halfway point
		*/
			ndata = 0;
			for(msg=element->msg_in;msg;msg=msg->next){
				switch(msg->type){
				case 0:
					ndata++;
					break;
				}
			}
			ndata /= 2;
		/*
		** get to the halfway point
		*/
			for(i=0,msg2=element->msg_in;msg2 && i<ndata;msg2=msg2->next){
				switch(msg2->type){
				case 0:
					i++;
					break;
				}
			}
		/*
		** traverse the list starting at the beginning and at the
		** halfway point plotting one against the other
		*/
			for(i=0,msg=element->msg_in;
				msg && msg2 && i<ndata;
				msg2=msg2->next,msg=msg->next,i++){
				y2 = MsgValue(msg,float,0) + i*element->yoffset;
				y1 = MsgValue(msg2,float,0) + i*element->xoffset;
				sprintf(plotname,"%d %s %s",
				i +element->last_plot,
				msg->slot[1].data,
				msg2->slot[1].data);
				graph_add_pts(element->widget,
				plotname,msg->slot[2].data,y1,y2);
			}
		}
		break;

		case	COPY:
			genesis_no_copy();
			return(0);
	default:
		InvalidAction("GraphOutput",element,action);
		break;
}
return(1);
}

static int
xaxisgraph_parser(element, i , argc, argv)
	struct xaxisgraph_type	*element;
	int			i;
	int			argc;
	char			**argv;
{
	int	n;
	Arg	arg[10];
	char	*field;
	char	*value;
	char	*foo;
	int	percent;

	field = argv[i];
	i++;
	if (i > argc) {
		fprintf(stderr,"SET: must specify a value field for '%s'\n",
			field);
		return(-1);
	}
	value = argv[i];

	if (strcmp(field,"xmin") == 0) {
		x_set_axis_graph_range(Pathname(element),
			atof(value), element->ymin,
			element->xmax, element->ymax);
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"xmax") == 0) {
		x_set_axis_graph_range(Pathname(element),
			element->xmin,  element->ymin,
			atof(value), element->ymax);
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"ymin") == 0) {
		x_set_axis_graph_range(Pathname(element),
			element->xmin,  atof(value),
			element->xmax, element->ymax);
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"ymax") == 0) {
		x_set_axis_graph_range(Pathname(element),
			element->xmin, element->ymin,
			element->xmax, atof(value));
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"XUnits") == 0) {
		n = 0;
		foo = (char *)g_copy(value);
		XtSetArg(arg[n], XtNXUnits, foo);	n++;
		XtSetValues(element->widget, arg, n);
		SetField(element,element->object->type,field,
			value);
		graph_rescale(element->widget);
		return(2);
	}
	if (strcmp(field,"YUnits") == 0) {
		n = 0;
		foo = (char *)g_copy(value);
		XtSetArg(arg[n], XtNYUnits, foo);	n++; 
		XtSetValues(element->widget, arg, n);
		SetField(element,element->object->type,field,
			value);
		graph_rescale(element->widget);
		return(2);
	}
	if (strcmp(field,"xoffset") == 0) {
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"yoffset") == 0) {
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"overlay") == 0) {
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"last_plot") == 0) {
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"phase_plot") == 0) {
		SetField(element,element->object->type,field,
			value);
		return(2);
	}
	if (strcmp(field,"range") == 0 ||
	strcmp(field,"-range") == 0) {
		fprintf(stderr,"SET: use -(subrange) value for now\n");
		return(2);
	}
	return(0);
}
