#include "gen_ext.h"
#ifdef X11R3
#include <X11/LabelP.h>
#else
#include <X11/Xaw/LabelP.h>
#endif X11R3
#include "XoWhen.h"
#include "draw_wP.h"

static void xfunc_draw_create();
static int xdraw_parser();

void xdraw_callback(w, client, call)
	DrawWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xdraw_type	*element;

	element = (struct xdraw_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (element == NULL) {
		fprintf(stderr,"xdrawcallback: null element\n");
		return;
	}
	xodus_core_set(element, w);
	SetField(element, element->object->type, "value", w->draw.pixvalue);
	SetField(element, element->object->type, "pixchoose", w->draw.pixname);
}

xdraw_func(element,action)
	struct xdraw_type *element;
	Action		*action;
{
	char	*field, *value;
	char	**argv;
	LayoutWidget	widget;
	static	XtCallbackRec	callback[2];
	static struct valid_arg xdraw_args[] = {
		{"vmin", 0, 2},
		{"vmax", 0, 2},
		{"cx", 0, 2},
		{"cy", 0, 2},
		{"cz", 0, 2},
		{"vx", 0, 2},
		{"vy", 0, 2},
		{"vz", 0, 2},
		{"wx", 0, 2},
		{"wy", 0, 2},
		{"value", 0, 2},
		{"pixchoose", 0, 2},
		{"transform", 0, 2},
		{"refresh_flag", 0, 2},
		{"widgets", 0, 2},
		{"END", -1, -1}
	};


	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}
	if(debug > 1){
		ActionHeader("Xdraw",element,action);
	}

	callback[0].callback = (XtCallbackProc)xdraw_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;

	switch(action->type) {
   		case CREATE: 
			widget = (LayoutWidget)do_3d_draw(action->argc,
				 action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			xfunc_core_create(element, callback);
			xfunc_parse_set(element, action->argc - 2,
				action->argv + 2, xdraw_parser);
			xfunc_draw_create(element);
			break;
   		case DELETE:
			genesis_destroy_widget(element);
			free(element->title);
			break;
   		case SET:
			argv =(char **)calloc(action->argc + 2,sizeof(char *));
			XoParseCoords(&(action->argc), action->argv, argv);
			if (x_parse_set(action->argc, argv, xdraw_args))
			xfunc_parse_set(element, action->argc,
				argv, xdraw_parser);
			break;
		case RESET:
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
		default:
			InvalidAction("Xdraw",element,action);
			break;
	}
	return(1);
}

static void xfunc_draw_create(elm)
	struct xdraw_type	*elm;
{
	Widget	w = elm->widget;
	char		*field;
	int			i;
	char	*names[MAXARGS];
	Arg		args[MAXARGS];
	int			n;

	n = 0;
	names[n] = XtNcx; n++;
	names[n] = XtNcy; n++;
	names[n] = XtNcz; n++;
	names[n] = XtNvx; n++;
	names[n] = XtNvy; n++;
	names[n] = XtNvz; n++;
	names[n] = XtNwx; n++;
	names[n] = XtNwy; n++;
	names[n] = XtNvalue; n++;
	names[n] = XtNpixchoose; n++;
	names[n] = XtNtransform; n++;
	names[n] = XtNrefresh_flag; n++;

	XoGetValuesToStrings(w,names,args,&n);

	for (i = 0 ; i < n ; i++)
		SetField(elm,elm->object->type,args[i].name,args[i].value);
}

static int xdraw_parser(element, i, argc, argv)
	struct xdraw_type	*element;
	int			i;
	int			argc;
	char			**argv;
{
	Widget	widget;
	int 	n = 0;
	char	*field, *value;
	Arg		args[50];

	widget = (Widget)XoGetWidgetFromString(Pathname(element));
	if (!widget) {
		fprintf(stderr,"could not find widget '%s' in xdraw_parser\n",
			Pathname(element));
		return(0);
	}
	
	field = argv[i];
	if (field[0] == '-')
		field++;
	i++;
	if (i >= argc) {
		fprintf(stderr,"Syntax: set %s %s <value>\n",
				Pathname(element), field);
		return(-1);
	}
	value = argv[i];
	
	if (
		strcmp(field, "cx") == 0 ||
		strcmp(field, "cy") == 0 ||
		strcmp(field, "cz") == 0 ||
		strcmp(field, "vx") == 0 ||
		strcmp(field, "vy") == 0 ||
		strcmp(field, "vz") == 0 ||
		strcmp(field, "wx") == 0 ||
		strcmp(field, "wy") == 0 ||
		strcmp(field, "value") == 0 ||
		strcmp(field, "pixchoose") == 0 ||
		strcmp(field, "transform") == 0 || 
		strcmp(field, "refresh_flag") == 0) {
			XtSetArg(args[n],field,value); n++;
			SetField(element, element->object->type, field, value);
	} else {
		fprintf(stderr,"variable '%s' not known - skipping\n",field);
		return(1);
	}
	XoSetValuesFromStrings(widget,args,n);
	return(2);
}


xodus_set_draw_elm(w)
	Widget w;
{
	Element *elm, *x_wte_get();
	int			i;
	char	*names[MAXARGS];
	Arg		args[MAXARGS];
	int			n;

	if (elm = x_wte_get(w)) {
		n = 0;
		names[n] = XtNcx; n++;
		names[n] = XtNcy; n++;
		names[n] = XtNcz; n++;
		names[n] = XtNvx; n++;
		names[n] = XtNvy; n++;
		names[n] = XtNvz; n++;
		names[n] = XtNwx; n++;
		names[n] = XtNwy; n++;
		names[n] = XtNvalue; n++;
		names[n] = XtNpixchoose; n++;
		names[n] = XtNtransform; n++;
		names[n] = XtNrefresh_flag; n++;
		XoGetValuesToStrings(w,names,args,&n);
		for (i = 0 ; i < n ; i++)
			SetField(elm,elm->object->type,args[i].name,args[i].value);
	}
}
