/* --------------------------------------------- */
/* The routine for generating assorted icons for use in
 * the draw widget.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"


char	*fillstr();


FindCoordRange(coords,ncoords,max,min)
	Coord	*coords;
	Coord	*max,*min;
{
	int i;

	if (!coords || ncoords == 0)
		return(0);

	*max = *min = coords[0];
	for (i = 1 ; i < ncoords ; i++) {
		if (max->x < coords[i].x)
			max->x = coords[i].x;
		else if (min->x > coords[i].x)
			min->x = coords[i].x;

		if (max->y < coords[i].y)
			max->y = coords[i].y;
		else if (min->y > coords[i].y)
			min->y = coords[i].y;

		if (max->z < coords[i].z)
			max->z = coords[i].z;
		else if (min->z > coords[i].z)
			min->z = coords[i].z;
	}
	return(1);
}

Coord *
ScaleCoords(old,ncoords,scale,offset)
	Coord	*old;
	int		ncoords;
	Coord	scale;
	Coord	offset;
{
	Coord	*new;
	int i;

	if (!old || ncoords == 0)
		return(NULL);

	new = (Coord *) calloc(ncoords,sizeof(Coord));

	for (i = 0 ; i < ncoords ; i++) {
		new[i].x = old[i].x * scale.x + offset.x;
		new[i].y = old[i].y * scale.y + offset.y;
		new[i].z = old[i].z * scale.z + offset.z;
	}
	return(new);
}

ScaleAllIcons(dw,scale,offset) 
	DrawWidget	dw;
	Coord	scale,offset;
{
	Pix	*pix;
	Coord	*coords;
	int		i;

	for (pix = dw->draw.icons ; pix  ; pix = pix->next) {
		coords = ((CoordRescale *)pix->rescale)->coords;
		for (i = 0 ; i < pix->npts ; i++ ) {
			coords[i].x = coords[i].x * scale.x + offset.x;
			coords[i].y = coords[i].y * scale.y + offset.y;
			coords[i].z = coords[i].z * scale.z + offset.z;
		}
	}
}

/*
** ALL ICONS ASSUMED TO BE FROM (-1,-1,-1) TO (1,1,1)
*/

InitialiseIcons()
{
	char *drawname;
	
	drawname = "/xproto/draw";

    MakeCircleIcon(drawname);
    MakeCompartmentIcon(drawname);
    MakeBufferIcon(drawname);
    MakeAxonIcon(drawname);
    MakeHHNaIcon(drawname);
    MakeHHKIcon(drawname);
    MakeExcSynIcon(drawname);
    MakeInhSynIcon(drawname);
    MakePlaneIcon(drawname);
}

MakeBoxIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = -1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 1; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = 1; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"box.icon",coords,i,"FillPoly",
		"Blue");
}

MakeCircleIcon(drawname)
	char *drawname;
{
	Coord   coords[22];
	int i;
	float   theta;

	for (i = 0 ; i < 20 ; i++) {
		theta = PI * (float)i / 10.0;
		coords[i].x = sin(theta); 
		coords[i].y = cos(theta); 
	}
	XoSetSimplePix(drawname,"circle.icon",coords,i,"FillPoly",
		"Red");
}

MakeCompartmentIcon(drawname)
	char *drawname;
{
	Coord   coords[22];
	int i = 0;
	int	j;

	coords[i].x = 0.6; coords[i].y = 0.8; coords[i].z = 0; i++;
	coords[i].x = 0.9; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0.4; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0.2; coords[i].z = 0; i++;
	coords[i].x = 0.8; coords[i].y = -0.2; coords[i].z = 0; i++;
	for (j = 0 ; j < 5 ; j++) {
		coords[i].x = coords[5 - j].x - 1.4; 
		coords[i].y = coords[5 - j].y - 0.2; 
		coords[i].z = 0;
		i++;
	}
	coords[i].x = 0.6; coords[i].y = 0.8; coords[i].z = 0; i++;
	for (j = 0 ; j < 5 ; j++) {
		coords[i].x = -coords[5 - j].x; 
		coords[i].y = 0.2 - coords[5 - j].y; 
		coords[i].z = 0;
		i++;
	}

	XoSetSimplePix(drawname,"compartment.icon",coords,i,"DrawLines",
		"Purple");
}

MakeBufferIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = -1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 1; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = 1; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"buffer.icon",coords,i,"FillPoly",
		"green");
}

MakeAxonIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = -1; coords[i].y = 0.8; coords[i].z = 0; i++;
	coords[i].x = 0.5; coords[i].y = 0.5; coords[i].z = 0; i++;
	coords[i].x = 0; coords[i].y = 1; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0; coords[i].z = 0; i++;
	coords[i].x = 0; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 0.5; coords[i].y = -0.5; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = -0.8; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"axon.icon",coords,i,"FillPoly",
		"purple");
}

MakeHHNaIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = 0.2; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 0.8; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0.4; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 0.4; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = -0.8; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 0.6; coords[i].z = 0; i++;

	coords[i].x = 0.4; coords[i].y = 0.7; coords[i].z = 0; i++;
	coords[i].x = 0.4; coords[i].y = 0.9; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 1; coords[i].z = 0; i++;
	coords[i].x = -0.6; coords[i].y = 1; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = -0.2; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = -0.2; coords[i].y = 0.5; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 0.6; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"hhna.icon",coords,i,"FillPoly",
		"yellow");
}

MakeHHKIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = 0.2; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 0.8; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0.4; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 0.4; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = -0.8; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 0.6; coords[i].z = 0; i++;

	coords[i].x = 0.4; coords[i].y = 0.7; coords[i].z = 0; i++;
	coords[i].x = 0.4; coords[i].y = 0.9; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 1; coords[i].z = 0; i++;
	coords[i].x = -0.6; coords[i].y = 1; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = -0.2; coords[i].y = -1; coords[i].z = 0; i++;
	coords[i].x = -0.2; coords[i].y = 0.5; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 0.6; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"hhk.icon",coords,i,"FillPoly",
		"violet");
}

MakeExcSynIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = -1; coords[i].y = 0.05; coords[i].z = 0; i++;
	coords[i].x = 0; coords[i].y = 0.05; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 0.2; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = -0.6; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = -0.2; coords[i].z = 0; i++;
	coords[i].x = 0; coords[i].y = -0.05; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = -0.05; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"excsyn.icon",coords,i,"FillPoly",
		"yellow");
}

MakeInhSynIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = -1; coords[i].y = 0.05; coords[i].z = 0; i++;
	coords[i].x = 0; coords[i].y = 0.05; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = 0.2; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = -0.6; coords[i].z = 0; i++;
	coords[i].x = 0.2; coords[i].y = -0.2; coords[i].z = 0; i++;
	coords[i].x = 0; coords[i].y = -0.05; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = -0.05; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"inhsyn.icon",coords,i,"FillPoly",
		"violet");
}

MakePlaneIcon(drawname)
	char *drawname;
{
	Coord	coords[20];
	int		i = 0;

	coords[i].x = -1; coords[i].y = -0.6; coords[i].z = 0; i++;
	coords[i].x = -0.6; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 1; coords[i].y = 0.6; coords[i].z = 0; i++;
	coords[i].x = 0.6; coords[i].y = -0.6; coords[i].z = 0; i++;
	coords[i].x = -1; coords[i].y = -0.6; coords[i].z = 0; i++;

	XoSetSimplePix(drawname,"plane.icon",coords,i,"DrawLines",
		"violet");
}
