#include "draw_ext.h"


Coord	CrossProduct();
float	DotProduct();

/*********************************************************
**                                                      **
**                     RescaleDraw(dw)                  **    
**                                                      **
** this routine, other than mundanely handling the      **
** window resize events, does all the work of           **
** recalculating displays after changes in viewpoint    **
** or centers or rotation or zooms etc                  **
**                                                      **
*********************************************************/

void RescaleDraw(dw)
	DrawWidget	dw;
{
	Pix		*pix;
	int		is_icon = 0;
    int		i;

	if (!dw) return;

    pix = dw->draw.images;
	for (is_icon = 0 ; is_icon <= 1 ; is_icon++ ) {
	    while (pix) {
			if (pix->rescale && pix->rescale->func)
				(pix->rescale->func)(dw,pix,is_icon);
			pix = pix->next;
		}
		pix = dw->draw.icons;
	}
	/*
    XClearArea(XtDisplay(dw),XtWindow(dw),0,0,0,0,True);
	*/
}

int UseCoords(dw,pix,is_icon)
	DrawWidget	dw;
	Pix			*pix;
	int			is_icon;
{
	Coord	*coords,*pixcoords;
	Coord	offset;
	int		i;

	coords = (Coord *) malloc(pix->npts * sizeof(Coord));
	pixcoords = ((CoordRescale *)(pix->rescale))->coords;
	offset = ((CoordRescale *)(pix->rescale))->offset;

	for (i = 0 ; i < pix->npts; i++) {
		coords[i].x = pixcoords[i].x + offset.x;
		coords[i].y = pixcoords[i].y + offset.y;
		coords[i].z = pixcoords[i].z + offset.z;
	}
	
	(dw->draw.transf_func)(dw,coords,pix,is_icon);

	return(1);
}

int UseElms(dw,pix,is_icon)
	DrawWidget	dw;
	Pix			*pix;
	int			is_icon;
{
	Coord	*coords;
	Coord	offset;
	int		i;
	Element **elms;

	coords = (Coord *) malloc(pix->npts * sizeof(Coord));
	elms = ((ElmRescale *)(pix->rescale))->elms;
	offset = ((ElmRescale *)(pix->rescale))->offset;

	for (i = 0 ; i < pix->npts; i++) {
		coords[i].x = elms[i]->x + offset.x;
		coords[i].y = elms[i]->y + offset.y;
		coords[i].z = elms[i]->z + offset.z;
	}
	
	(dw->draw.transf_func)(dw,coords,pix,is_icon);

	free(coords);

	return(1);
}

int UsePt(dw,pix,is_icon)
	DrawWidget	dw;
	Pix			*pix;
	int			is_icon;
{
	Coord	coords[1];
	Coord	offset;
	int		i;
	Element **elms;

	coords[0].x = pix->rescale->offset.x ;
	coords[0].y = pix->rescale->offset.y ;
	coords[0].z = pix->rescale->offset.z ;

	pix->npts = 1;
	(dw->draw.transf_func)(dw,coords,pix,is_icon);

	return(1);
}

int UseFile(dw,pix,is_icon)
	DrawWidget	dw;
	Pix			*pix;
	int			is_icon;
{
	fprintf(stderr,"UseFile not yet implemented\n");
	return(0);
}

z2d(dw,coords,pix,is_icon)
	DrawWidget	dw;
	Coord		*coords;
	Pix			*pix;
	short		is_icon;
{
	float	w,h;
	float	xrange,yrange;
	float	xmin,ymin;
	int		sx,sy;
	int		i;
	XPoint	*pts;

	pts = pix->pts;

	w = (float)(dw->core.width);
	h = (float)(dw->core.height);

	xrange = dw->draw.wx;
	yrange = dw->draw.wy;

	if (is_icon) {
		for (i = 0 ; i < pix->npts ; i++) {
			pts[i].x = (short)(w * coords[i].x / xrange);
			pts[i].y = (short)(h - h * coords[i].y / yrange);
		}
	} else {
		xmin = dw->draw.cx - xrange/2.0;
		ymin = dw->draw.cy - yrange/2.0;
	
		for (i = 0 ; i < pix->npts ; i++) {
			pts[i].x = (short)(w * (coords[i].x - xmin) / xrange);
			pts[i].y = (short)(h - h * (coords[i].y - ymin) / yrange);
		}
	}
}

y2d(dw,coords,pix,is_icon)
	DrawWidget	dw;
	Coord		*coords;
	Pix			*pix;
	short		is_icon;
{
	float	w,h;
	float	xrange,yrange;
	float	xmin,ymin;
	int		sx,sy;
	int		i;
	XPoint	*pts;

	pts = pix->pts;

	w = (float)(dw->core.width);
	h = (float)(dw->core.height);

	xrange = dw->draw.wx;
	yrange = dw->draw.wy;

	if (is_icon) {
		for (i = 0 ; i < pix->npts ; i++) {
			pts[i].x = w * coords[i].x / xrange;
			pts[i].y = h - h * coords[i].z / yrange;
		}
	} else {
		xmin = dw->draw.cx - xrange/2.0;
		ymin = dw->draw.cz - yrange/2.0;
	
		for (i = 0 ; i < pix->npts ; i++) {
			pts[i].x = w * (coords[i].x - xmin) / xrange;
			pts[i].y = h - h * (coords[i].z - ymin) / yrange;
		}
	}
}

x2d(dw,coords,pix,is_icon)
	DrawWidget	dw;
	Coord		*coords;
	Pix			*pix;
	short		is_icon;
{
	float	w,h;
	float	xrange,yrange;
	float	xmin,ymin;
	int		sx,sy;
	int		i;
	XPoint	*pts;

	pts = pix->pts;

	w = (float)(dw->core.width);
	h = (float)(dw->core.height);

	xrange = dw->draw.wx;
	yrange = dw->draw.wy;

	if (is_icon) {
		for (i = 0 ; i < pix->npts ; i++) {
			pts[i].x = w * coords[i].y / xrange;
			pts[i].y = h - h * coords[i].z / yrange;
		}
	} else {
		xmin = dw->draw.cy - xrange/2.0;
		ymin = dw->draw.cz - yrange/2.0;
	
		for (i = 0 ; i < pix->npts ; i++) {
			pts[i].x = w * (coords[i].y - xmin) / xrange;
			pts[i].y = h - h * (coords[i].z - ymin) / yrange;
		}
	}
}

ortho3d(dw,coords,pix,is_icon)
	DrawWidget	dw;
	Coord		*coords;
	Pix			*pix;
	short		is_icon;
{
	Coord		ip,jp,kp; /* i, j, and k vectors of the plane. */
	float		cx,cy;	  /* center offset of the plane */
	float		len;
	int			i,j;
	XPoint		*pts;
	Coord		temp;
	float		x,y;
	short		ht, wid;

	FindPlane(dw,&ip,&jp,&kp);

	wid = (short) dw->core.width;
	ht = (short) dw->core.height;

	/* Now that we have found the plane, lets do the actual proj */

	pts = pix->pts;
	if (is_icon) {
		for (i = 0 ; i < pix->npts ; i++) {
			pts[i].x = DotProduct(coords[i],ip);
			pts[i].y = ht - DotProduct(coords[i],jp);
		}
	} else {
		temp.x = dw->draw.cx;
		temp.y = dw->draw.cy; 
		temp.z = dw->draw.cz;
		cx = DotProduct(temp,ip);
		cy = DotProduct(temp,jp);
		cx = cx - wid/2;
		cy = cy - ht/2;
		for (i = 0 ; i < pix->npts ; i++) {
			x = DotProduct(coords[i],ip);
			y = DotProduct(coords[i],jp);
			pts[i].x = (short)(x - cx);
			pts[i].y = ht - (short)(y - cy);
			/*
			pts[i].x = (short)(DotProduct(coords[i],ip) - cx);
			pts[i].y = (short)(DotProduct(coords[i],jp) - cy);
			*/
		}
	}
}

defaultortho3d(dw,coords,pix,is_icon)
	DrawWidget	dw;
	Coord		*coords;
	Pix			*pix;
	short		is_icon;
{
}

pan3d(dw,coords,pix,is_icon)
	DrawWidget	dw;
	Coord		*coords;
	Pix			*pix;
	short		is_icon;
{
}

perspective(dw,coords,pix,is_icon)
	DrawWidget	dw;
	Coord		*coords;
	Pix			*pix;
	short		is_icon;
{
	Coord		ip,jp,kp; /* i, j, and k vectors of the plane. */
	float		cx,cy;	  /* center offset of the plane */
	float		len;
	float		scale;
	int			i,j;
	XPoint		*pts;
	Coord		temp;
	Coord		viewpt;
	Coord		center;
	float		x,y;
	short		ht,wid;

	FindPlane(dw,&ip,&jp,&kp);
	ht = (short)(dw->core.height);
	wid = (short)(dw->core.width);

	/* Now that we have found the plane, lets do the actual proj */
	viewpt.x = dw->draw.vx;
	viewpt.y = dw->draw.vy;
	viewpt.z = dw->draw.vz;
	center.x = dw->draw.cx;
	center.y = dw->draw.cy;
	center.z = dw->draw.cz;
	pts = pix->pts;

	len = DotProduct(kp,viewpt);

	pts = pix->pts;
	if (is_icon) {
		for ( i = 0 ; i < pix->npts ; i++) {
			temp = coords[i];
			temp.x = viewpt.x + center.x - temp.x;
			temp.y = viewpt.y + center.y - temp.y;
			temp.z = viewpt.z + center.z - temp.z;
			scale = DotProduct(kp,temp);
			scale = scale /len;
			if (scale < 1.0e-3) {
				pts[i].x = pts[i].y = 0;
			} else {
				x = DotProduct(coords[i],ip);
				y = DotProduct(coords[i],jp);
				pts[i].x = (short)(x / scale);
				pts[i].y = ht - (short)(y / scale);
			}
		}
	} else {
		cx = DotProduct(center,ip);
		cy = DotProduct(center,jp);
		cx = cx - wid/2;
		cy = cy - ht/2;
		for ( i = 0 ; i < pix->npts ; i++) {
			temp = coords[i];
			temp.x = viewpt.x + center.x - temp.x;
			temp.y = viewpt.y + center.y - temp.y;
			temp.z = viewpt.z + center.z - temp.z;
			scale = DotProduct(kp,temp);
			scale = scale /len;
			if (scale < 1.0e-3) {
				pts[i].x = pts[i].y = 0;
			} else {
				x = DotProduct(coords[i],ip) ;
				y = DotProduct(coords[i],jp) ;
				pts[i].x = (short)(x / scale - cx);
				pts[i].y = ht - (short)(y / scale - cy);
			}
		}
	}
}

Coord CrossProduct(p,q)
	Coord p,q;
{
	Coord r;

	r.x = p.y * q.z - q.y * p.z;
	r.y = p.z * q.x - q.z * p.x;
	r.z = p.x * q.y - q.x * p.y;

	return(r);
}

float DotProduct(p,q)
	Coord p,q;
{
	float	prd;

	prd = (float)(p.x * q.x + p.y * q.y + p.z * q.z);
	return(prd);
}

FindPlane(dw,i,j,k)
	DrawWidget	dw;
	Coord	*i,*j,*k;
{
	Coord		ip,jp,kp; /* i, j, and k vectors of the plane. */
	Coord		korig;    /* k of the original frame. */
	float		len;
	float		scalex,scaley;

	scalex = ((float)(dw->core.width)) / dw->draw.wx;
	scaley = ((float)(dw->core.height)) / dw->draw.wy;

	kp.x = dw->draw.vx;
	kp.y = dw->draw.vy;
	kp.z = dw->draw.vz;

	len = sqrt(kp.x * kp.x + kp.y * kp.y + kp.z * kp.z);
	kp.x = kp.x/len;
	kp.y = kp.y/len;
	kp.z = kp.z/len;

	korig.x = 0.0; korig.y = 0.0; korig.z = 1.0;
	ip = CrossProduct(korig, kp);
	len = ip.x * ip.x + ip.y * ip.y + ip.z * ip.z;
	if (len < 1.0e-10) {
		ip.x = 1.0;
		ip.y = ip.z = 0.0;
	} else {
		len = sqrt(len);
		ip.x = ip.x / len;
		ip.y = ip.y / len;
		ip.z = ip.z / len;
	}
	jp = CrossProduct(kp,ip);

	/*
	** Now for a terrible hack which is very time_saving: to scale
	** ip and jp to the screen so that later scaling is not needed
	*/
	ip.x *= scalex;
	ip.y *= scalex;
	ip.z *= scalex;

	jp.x *= scaley;
	jp.y *= scaley;
	jp.z *= scaley;

	*i = ip;
	*j = jp;
	*k = kp;
}


/*
bounding_cube(dw,r1,r2)
	DrawWidget	dw;
	Coord	*r1,*r2;
{
	Pix	*pix;
	Coord *r;
	int	i;

	pix = dw->draw.images;
	*r2 = *r1 = pix->coords[0];

	while(pix) {
		r = pix->coords;

		for (i = 0 ; i < pix->npts ; i++) {
			if (r[i].x < r1->x)  
				r1->x = r[i].x;
			if (r[i].y < r1->y)  
				r1->y = r[i].y;
			if (r[i].z < r1->z)  
				r1->z = r[i].z;

			if (r[i].x > r2->x)  
				r2->x = r[i].x;
			if (r[i].y > r2->y)  
				r2->y = r[i].y;
			if (r[i].z > r2->z)  
				r2->z = r[i].z;
		}
		pix = pix->next;
	}
}
*/
