//genesis

// The cell reading utility
addfunc read_cell do_read_cell

// The cell writing utility
addfunc write_cell do_write_cell

// A utility for positioning the dendrites of a cell based on 
// messages rather than parent-child relationships
addfunc rel_position do_rel_position

// A utility for randomising the coords of a cell
addfunc rancoord do_rancoord

// A way of creating 3-d surfaces of cells. Options permit 
// automatic orientation, randomisation, and curving the dendrites 
// of the cells to match the surface
addfunc cell_sheet do_cell_sheet

// A generalised function for doing 3-d messages. It finds the dist
// between the source and dest elements in 3-d space, and if they
// are close enough, sends the message.
addfunc gen_3d_msg do_gen_3d_msg

// A specialised function for doing 3-d messaging between dendrites.
// It finds the shortest distance between
// the DENDS of the source and dest channels, and if this is
// within the specified range it sends the message. For use in 
// dd-synapses

addfunc dd_3d_msg do_dd_3d_msg

// A function for doing rotations of cells in 3-d. Lots of options.
addfunc rotcoord do_rotate

// A function for connecting cells based on their 3-d positions.
addfunc volume_connect do_volume_connect

// A function for fitting exponential decays to a plot file
addfunc expfit do_expfit

// A function for extracting a whole bunch of strange parameters
// from the Vm trace of a neuronal spike in a plot file
addfunc spikeparms do_spike_parms

// A function for getting cell input res using Rall's calculations
addfunc rall_calc_Rm do_rall_calc_Rm

// A function for getting cell input res using the compartment model
addfunc calc_Rm do_calc_Rm


// A function for getting approx cell capacitance using simple summing
// Clearly, there is no simple Cm since there are multiple time 
// constants in the cell.
addfunc calc_Cm do_sumCm
