#include <stdio.h>
#include <math.h>

#define PI 3.1415927

float newpt();

main(argc,argv)
	int	argc;
	char	**argv;
{
	FILE	*fp,*fopen();
	float	x,y,z,d,cx,cy,cz,cr;
	float	theta,phi;
	float	nx,ny,nz;
	float	temp;
	int		i = 0;
	int 	normal;
	float	fudge;

	if (argc < 6) {
		fprintf(stderr,"This routine generates coords for an egg with specified dimensions x,y,z\n");
		fprintf(stderr,"d specifies the spacing.\n");
		fprintf(stderr,"the -n option decides if a normal should also becalculated\n");	
		fprintf(stderr,"usage : %s filename x y z d [-n]\n",argv[0]);
		return;
	}
	x = atof(argv[2])/2.0;
	y = atof(argv[3])/2.0;
	z = atof(argv[4])/2.0;
	d = atof(argv[5]);
	fudge = sqrt(x * y);
	if (argc == 7)
		normal = (strcmp(argv[6],"-n") == 0);

	fp = fopen(argv[1],"w");

	for(cz = z, cr = 0.0, phi = 0.0; phi < PI ;
		phi += newpt(&cz,&cr,z,fudge,d)) {
		for(cx = cr * x/fudge, cy = 0.0, theta = 0.0; theta < (PI * 2);
			theta += newpt(&cx,&cy,cr * x/fudge,cr * y/fudge,d)) {
			i++;
			if (normal) {
				nx = cx /(x * x);
				ny = cy /(y * y);
				nz = cz /(z * z);
				temp = sqrt(nx * nx + ny * ny + nz * nz);
				nx /= temp;
				ny /= temp;
				nz /= temp;
				fprintf(fp,"%-10.6e	%-10.6e	%-10.6e	%-10.6e	%-10.6e	%-10.6e\n",cx,cy,cz,nx,ny,nz);
			} else {
				fprintf(fp,"%-20.6e	%-20.6e	%-20.6e\n",cx,cy,cz);
			}
		}
	}
	printf ("%d coordinates were found\n",i);
}

/* Given coords x,y, and the required dist d, gets dtheta by assuming
** a circle, using the new theta to calculate new coords x,y. dtheta
** is calculated agin for this position, and the mean taken as the
** correct dtheta, which is used to calculated the returned coords.
*/
float newpt(nx,ny,X,Y,d)
	float *nx,*ny;
	float X,Y,d;
{
	float dt;
	float len;
	float x,y;
	float tx,ty;
	float s,c;
	float ds,dc,ns,nc;

	if ((X * PI) < d || (Y * PI) < d)
		return(2 * PI);

	x = *nx;
	y = *ny;
	len = sqrt(x * x + y * y);
	dt = d / len;

	s = y/Y;
	c = x/X;
	ds = sin(dt);
	dc = cos(dt);
	ns = s * dc + ds * c;
	nc = c * dc - s * ds;

	tx = X * nc;
	ty = Y * ns;
	len = sqrt(tx * tx + ty * ty);

	/* Average of two dthetas */
	dt = (dt + d/len)/2.0;

	ds = sin(dt);
	dc = cos(dt);
	ns = s * dc + ds * c;
	nc = c * dc - s * ds;

	*nx = X * nc;
	*ny = Y * ns;

	return(dt);
}
