#include "sim_ext.h"

#define MAXFITPTS 1001
#define MAXNA 20
#define ENDT 1000.0

/*
** This file has the sum of exp form for the nonlin curvefit routine
** mrqmin to use.
*/

#ifdef OLD
void expsum(x,a,y,dyda,na)
	float	x,a[],*y,dyda[];
	int na;
{
	int i;
	float e1,e2;

	e1 = exp(-x * a[3]);
	e2 = exp(-x * a[5]);

	*y = a[1] + a[2] * e1 + a[4] * e2;
	dyda[1] = 1;
	dyda[2] = e1;
	dyda[3] = -a[2] * x * e1;
	dyda[4] = e2;
	dyda[5] = -a[4] * x * e2;
}
#endif

void fitsum(x,a,y,dyda,na)
	float	x,a[],*y,dyda[];
	int na;
{
	int i;
	float e;

	dyda[1] = 1;
	*y = a[1];
	for (i=2;i<na;i += 2){
		e = exp(-x * a[i+1]);
		*y += a[i] * e;
		dyda[i] = e;
		dyda[i+1]= -a[i] * x * e;
	}
	if ((na%2) == 0) {
		*y += a[na] * x;
		dyda[na]=x;
	}
}

char *do_expfit(argc,argv)
	int		argc;
	char	**argv;
{
	float	x[MAXFITPTS],y[MAXFITPTS],sig[MAXFITPTS];
	float	a[MAXNA];
	int		lista[MAXNA];
	int		na,mfit;
	float	**covar,**alpha;
	float	chisq;
	float	lastchisq;
	float	alamda;
	int		plotno = 0;
	float	startt = 0,endt = ENDT,dt = 0,t=0;
	int		niterations=0,nexpterms=2,linterm=0;
	float	asymptote = -0.070; /* Resting potl */
	int		asymptote_flag = 0;
	char	*outputfile,*filemode;
	char	*notes;
	int		npts;
	int		i;
	static char ret[200];
	float	**matrix();

	float	*allvars[50];
	char	*varnames[50];
	int		nvars;

	if (argc < 2) {
		printf("usage : %s filename [-plot plotno] [-start time] [-end time]\n",argv[0]);
		printf("[-iterations n] [-expterms n] [-linterm] [-file outputfile mode]\n");
		printf("[-asymptote v] [-notes notes]\n");
		printf("The command returns : Vm(asymptotic),Vm(tau0),tau0,Vm(tau1),tau1,chisq\n");
		printf("start and end specify the points in the plot that will be fitted\n");
		printf("'iterations n' specifies the number of iterations : min if +ve, max if -ve\n");
		printf("It forces the routine to print out chisq for each stage\n");
		printf("'expterms' sets the number of exponential terms that the routine must fit\n");
		printf("'linterm' tells the routine to also fit a linear term\n");
		printf("'-asymptote v' fixes the value of the asymptote term\n");
		printf("Valid filemodes : multifile onefile onefileappend\n");
		return;
	}
	for (i = 2 ; i < argc ; i++) {
		if (strcmp(argv[i],"-plot") == 0) {
			i++; plotno = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-start") == 0) {
			i++; startt = atof(argv[i]);
		}
		if (strcmp(argv[i],"-end") == 0) {
			i++; endt = atof(argv[i]);
		}
		if (strcmp(argv[i],"-iterations") == 0) {
			i++; niterations = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-expterms") == 0) {
			i++; nexpterms = atoi(argv[i]);
		}
		if (strcmp(argv[i],"-linterm") == 0) {
			linterm = 1;
		}
		if (strcmp(argv[i],"-file") == 0) {
			if (argc < (i + 2)) {
				printf("syntax : -file outputfile mode\n");
				return;
			}
			i++; outputfile = argv[i];
			i++; filemode = argv[i];
		}
		if (strcmp(argv[i],"-asymptote") == 0) {
			i++; asymptote = atof(argv[i]);
			asymptote_flag = 1;
		}
		if (strcmp(argv[i],"-notes") == 0) {
			i++; notes = argv[i];
		}
	}
	na = 1 + nexpterms * 2 + linterm;
	if (na >= MAXNA) {
		printf("Max no of nexpterms is %d. Abandoning.\n",MAXNA/2 - 2);
		return;
	}

	nvars = 0;
	allvars[nvars] = &(a[1]); varnames[nvars] = "asymVm"; nvars++;
	allvars[nvars] = &chisq; varnames[nvars] = "chisq"; nvars++;
	for (i = 1 ; i <= (nexpterms * 2) ; i++) {
		allvars[nvars] = &(a[i+1]);
		varnames[nvars] = (char *) malloc(8 * sizeof(char *));
		if (i%2)
			sprintf(varnames[nvars],"Vm%d",(i-1)/2);
		else
			sprintf(varnames[nvars],"tau%d",(i-1)/2);
		nvars++;
	}
	if (linterm) {
		allvars[nvars] = &(a[i+1]);
		varnames[nvars] = "slope";
		nvars++;
	}

	if (!read_plot2(argv[1],plotno,&dt,y,MAXFITPTS - 1,&npts,startt,endt)) {
		printf("Read plot failed\n");
		return("failed");
	}
	for (i=0,t=startt;i<npts;i++,t+=dt)
		x[i]=t;
	endt = t-dt;


/* INITIALISING VARIABLES */

	alpha = (float **)malloc((na + 1) * sizeof(float *));
	for (i = 0 ; i <= na ; i++)
		alpha[i] = (float *)malloc((na+1) * sizeof(float));
	covar = (float **)malloc((na+1) * sizeof(float *));
	for (i = 0 ; i <= na ; i++)
		covar[i] = (float *)malloc((na+1) * sizeof(float));

	a[1] = asymptote;	/* Resting potential by default */
	for (i=2;i<=na;i++){
		if (i%2) /* odds i.e taus */
			a[i]= 5 * i * i;
		else
			a[i]=0.04/((float)i);
	}

	if (asymptote_flag) {
		mfit = na-1;
		for (i=0;i<na;i++)
			lista[i] = i+1;
	} else {
		mfit = na;
		for (i=0;i<=na;i++)
			lista[i] = i;
	}

	for (i = npts ; i > 0 ; i--) {
		x[i] = x[i - 1];
		y[i] = y[i - 1];
		sig[i] = fabs(0.0005 * y[i]); /* assume 0.05% error */
		/* moving the values up because of their stupid
		** convention of starting at 1 */
	}
	
/* INITIALISING THE FUNCTION */
	alamda = -1;
	mrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
		fitsum,&alamda);
	lastchisq = chisq * 1.01 + 1;

/* LOOPING TILL CONVERGENCE */
	if (niterations < 0) {
		niterations = -niterations;
		for (i = 1; i <= niterations; i++) {
			lastchisq = chisq;
			mrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
				fitsum,&alamda);
			printf("Iteration %d, chisq = %f, lamda = %f\n",
				i,chisq,alamda);
		}
	} else {
		for (i=1;((lastchisq - chisq)/1000.0) > 0.001 ||
			lastchisq <=  chisq || i <= niterations; i++) {
			lastchisq = chisq;
			mrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
				fitsum,&alamda);
			printf("Iteration %d, chisq = %f, lamda = %f\n",
				i,chisq,alamda);
		}
	}

/* EXTRACTING THE VARIABLES */
	alamda = 0;
	mrqmin(x,y,sig,npts,a,na,lista,mfit,covar,alpha,&chisq,
		fitsum,&alamda);
	
	sprintf(ret,"%g %g %g %g %g %g",a[1],a[2],1.0/a[3],a[4],
		1.0/a[na],chisq);
	
/* CLEANING UP */
	free_matrix(alpha,1,na,1,1);
	free_matrix(covar,1,na,1,1);

/* INVERTING THE TAUS */
	for (i=3;i<=na;i+=2)
		if (a[i] > 0.000001)
			a[i]=1.0/a[i];

/* DUMPING OUTPUT */
    if (notes)
        printf("\n%s\n",notes);
    for (i = 0 ; i < nvars ; i++) {
        printf("%s  %g  ",varnames[i],*(allvars[i]));
        if ((i%3) == 2)
            printf("\n");
    }
    printf("\n");

	if (outputfile && strlen(outputfile) > 0) {
		spikeparmoutput(allvars,NULL,varnames,nvars,outputfile,filemode,notes);
	}
	return(ret);
}


read_plot(fname,plotno,x,y,maxpts,actualpts,timestep)
	char	*fname;
	int	plotno;
	float	*x,*y;
	int	maxpts;
	int	*actualpts;
	float	timestep;
{
char	label[100];
int	npts = 0;
int	cellnum;
FILE	*fp;
int 	header_size;
int	i;
int	xmax, ymax;
int	datatype;
int	j;
float	dt;
float	start_time;
float	time;
float	val;
double 	dval;
int 	ival;
float 	fval;
float	gain;
float	*data;
short	skip;
int	count;
int	datasize;
short	new_format = 1;
short 	dnum;

    gain = 1;
    skip = 0;
    fp = NULL;

	if((fp = fopen (fname,"r")) == NULL) {
		fprintf(stderr,"\nfile not found : %s\n",fname);
		return(0);
	    }

    if(new_format){
	fread(label,sizeof(char),80,fp);
	fread(&start_time,sizeof(float),1,fp);
	fread(&dt,sizeof(float),1,fp);
	fread(&cellnum,sizeof(int),1,fp);
	fread(&datatype,sizeof(int),1,fp);
	header_size = 2*sizeof(int) + 2*sizeof (float) + 80 +
	3*cellnum*sizeof(float);
    } else {
	fread(&xmax,sizeof(int),1,fp);
	fread(&ymax,sizeof(int),1,fp);
	cellnum= (xmax+1)*(ymax+1);
	fread(&dt,sizeof(float),1,fp);
	fread(&datatype,sizeof(int),1,fp);
	header_size = 3*sizeof(int) + sizeof (float);
    }
    if(cellnum <= 0) {
	printf("file is empty\n");
	fclose(fp);
	return(0);
    }
    switch(datatype){
	case INT :
	datasize = sizeof(int);
	break;
	case SHORT :
	datasize = sizeof(short);
	break;
	case FLOAT :
	datasize = sizeof(float);
	break;
	case DOUBLE :
	datasize = sizeof(double);
	break;
    }

    skip = timestep/dt - 0.5;
    data = (float *)malloc(cellnum*datasize);
    count=0;
    fseek (fp, (long) ((plotno * datasize) + header_size),0); 
    time = start_time;
    while (!feof(fp)){
	switch(datatype){
	case FLOAT :
	    dnum = fread (&fval, datasize,1,fp);
	    val = fval;
	    break;
	case DOUBLE :
	    dnum = fread (&dval, datasize,1,fp);
	    val = dval;
	    break;
	case INT :
	    dnum = fread (&ival, datasize,1,fp);
	    val = ival;
	    break;
	}
	if(dnum <=0) break;
	if (feof(fp)) break;
	/*
	** add the points to the array
	*/
	if((skip <= 0) || (count%skip == 0)) {
		x[npts] = time;
		y[npts] = val;
		npts++;
		if (npts >= maxpts)
			break;
	}
	time += dt;
	count++;
	fseek (fp, (long)( (cellnum-1)*datasize), 1);
    }
    fclose(fp);
    *actualpts = npts;

	return(npts);
}
#undef MAXFITPTS
