#include <stdio.h>
#include <math.h>
#include "sim_ext.h"
#include "tools.h"
#include "seg_struct.h"
#include "hh_struct.h"

float calc_len(elm,RM,RA)
	struct compartment_type	*elm;
	float RM,RA;
{
	float len,Ra,Rm,dx,dy,dz;
	Element	*parent,*find_parent_dend();

	parent = find_parent_dend(elm);

	if (parent) {
		len = sqrt((elm->x - parent->x) * (elm->x - parent->x) +
			(elm->y - parent->y) * (elm->y - parent->y) +
			(elm->z - parent->z) * (elm->z - parent->z));
	} else {
		len = RM * RM * elm->Ra / (4 * PI * RA * elm->Rm * elm->Rm);
		len = exp((log(len))/3.0);
	}
	return(len);
}

float calc_dia(elm,RM,RA)
	struct compartment_type	*elm;
	float RM,RA;
{
	float dia,len;
	float calc_len();

	len = calc_len(elm,RM,RA);
	dia = RM / (elm->Rm * len * PI);
	return(dia);
}

float calc_cond(elm,chan,RM,RA)
	struct compartment_type *elm;
	Element	*chan;
	float RM,RA;
{
	float dia,len;
	float cond;
	float calc_len();

	len = calc_len(elm,RM,RA);
	dia = RM / (elm->Rm * len * PI);

	if (strcmp(chan->object->name,"hh_channel") == 0)
		cond = ((struct hh_channel_type *)chan)->Gbar;
	else if (strcmp(chan->object->name,"channelC2") == 0)
		cond = ((struct channelC2_type *)chan)->gmax;
	else
		return(-1.0);
	
	return(cond/(len * dia * PI));
}

