#include "struct_defs.h"

/*
*******************************
**       CONNECTION          **
*******************************
*/
struct connection_synapse_type {
    CONNECTION_TYPE
    short		plastic_weight;	
    short		base_weight;
    unsigned char	transient_weight;
    unsigned char	state_age;
    short		state;
    short		activity_level;
};

struct synapseA_type {
    CONNECTION_TYPE
    float	time;
    float	state;
};

struct synapseB_type {
    CONNECTION_TYPE
    float	time;
    float	state;
    float	rate;
    float	scale;
    float	maxweight;
};

struct synapseB1_type {
    CONNECTION_TYPE
    float	state;
    float	rate;
    float	scale;
    float	maxweight;
};

struct synapseC_type {
    CONNECTION_TYPE
    float	time;
    float	state;
    float	rate;
    float	scale;
    float	maxweight;
    float	orig_gmax;
};

struct hebbsynapseA_type {
    CONNECTION_TYPE
    float	state;
    float	scale;
    float	baseline;
};

struct hebbsynapseB_type {
    CONNECTION_TYPE
    float	state;
    float	scale;
    float	baseline;
    float	decay;
};

struct rel_connection_synapse_type {
	short			base_weight;
};

