#include "syn_ext.h"

#ifdef LATER
FullWeightSynapse(projection,connection,mode,offset_time,event)
register struct axon_type		*projection;
register struct connection_synapse_type	*connection;
int		mode;
float		offset_time;
Event		*event;
{
int		offset = round(offset_time/global_clock[projection->clock]);

    if(offset == 0) {
	/* 
	** use a table lookup to get the conductance value
	*/
	connection->target->activation +=
	event->magnitude
	* connection->weight
	* projection->Ctable[offset]
	* connection->transient_weight
	* connection->plastic_weight;

	connection->state = event->magnitude * state_scale;

	connection->activity_level += connection->plastic_weight;
	connection->state_age = 1;
    } else {
	connection->target->activation +=
	event->magnitude
	* connection->weight
	* projection->Ctable[offset]
	* connection->transient_weight
	* connection->plastic_weight;
    }
}

ConvolutionSynapseA(projection,connection,mode,offset_time,event)
register struct axon_type	*projection;
Connection	*connection;
int		mode;
float		offset_time;
Event		*event;
{
int	offset = round(offset_time/global_clock[projection->clock]);

    connection->target->activation +=
    event->magnitude
    * connection->weight
    * projection->Ctable[offset];
}
#endif

#ifdef LATER
#define Ffield(F)	Specific(connection,synapseB1_type,F)

SynapseB1(projection,connection,mode,offset_time,event)
Projection	*projection;
Connection	*connection;
int		mode;
float		offset_time;
Event		*event;
{
    switch(mode){
    case INIT:
	Ffield(state) -= 
	(float)(Ffield(state)*Ffield(rate)*CLOCKRATE(projection));
	break;
    case PROCESS:

	connection->target->activation +=
	event->magnitude
	*(Ffield(state) + connection->weight);
	/*
	** set the new state
	*/
	Ffield(state) += Ffield(scale)*(Ffield(maxweight) - Ffield(state));
	break;
    case RESET:
	Ffield(state) =  (float)(0.0);
	break;
    }
}
#undef Ffield


#define Ffield(F)	Specific(connection,synapseC_type,F)

SynapseC(projection,connection,mode,offset_time,event)
Projection	*projection;
Connection	*connection;
int		mode;
float		offset_time;
Event		*event;
{
float	old_state;

    switch(mode){
    case PROCESS:
	/*
	** update the facilitation weighting
	*/
	old_state = Ffield(state)*
	    exp(Ffield(rate)*(Ffield(time) - simulation_time));

	Specific(connection->target,channelB_type,gain_gk) =
	event->magnitude*Ffield(state) + Ffield(orig_gmax);
	/*
	** set the new state
	*/
	Ffield(state) = old_state + 
	    Ffield(scale)*(Ffield(maxweight) -  old_state);
	Ffield(time) = simulation_time;
	break;
    case RESET:
	Ffield(time) = 0;
	Ffield(state) =  0;
	if(Ffield(orig_gmax) == 0){
	    Ffield(orig_gmax) =  
	    Specific(connection->target,channelB_type,gain_gk);
	}
	Specific(connection->target,channelB_type,gain_gk)  
	= Ffield(orig_gmax);
	break;
    }
}
#undef Ffield


#define Ffield(F)	Specific(connection,hebbsynapseA_type,F)

HebbSynapseA(projection,connection,mode,offset_time,event)
Projection	*projection;
Connection	*connection;
int		mode;
float		offset_time;
Event		*event;
{
    switch(mode){
    case PROCESS:
	/*
	** calculate the postsynaptic activation
	*/
	connection->target->activation +=
	event->magnitude *Ffield(state);
	/*
	** modify the weight
	*/
	Ffield(state) += 
	    Ffield(scale)*
	    (connection->target->state - Ffield(baseline));
	break;
    case RESET:
	Ffield(state) = connection->weight;
	break;
    }
}
#undef Ffield

#define Ffield(F)	Specific(connection,hebbsynapseA_type,F)

HebbSynapseA1(projection,connection,mode,offset_time,event)
Projection	*projection;
Connection	*connection;
int		mode;
float		offset_time;
Event		*event;
{
    switch(mode){
    case PROCESS:
	/*
	** calculate the postsynaptic activation
	*/
	connection->target->activation +=
	event->magnitude *Ffield(state);
	/*
	** modify the weight
	*/
	Ffield(state) += 
	    Ffield(scale)*
	    event->magnitude*
	    (connection->target->state - Ffield(baseline));
	break;
    case RESET:
	Ffield(state) = connection->weight;
	break;
    }
}
#undef Ffield

#define Ffield(F)	Specific(connection,hebbsynapseB_type,F)
HebbSynapseB(projection,connection,mode,offset_time,event)
Projection	*projection;
Connection	*connection;
int		mode;
float		offset_time;
Event		*event;
{
    switch(mode){
    case INIT:
	/*
	** implement decay
	*/
	Ffield(state) -= 
	(float)(Ffield(state)*Ffield(decay)*CLOCKRATE(projection));
	break;
    case PROCESS:
	/*
	** calculate the postsynaptic activation
	*/
	connection->target->activation +=
	event->magnitude *Ffield(state);
	/*
	** modify the weight
	*/
	Ffield(state) += 
	    Ffield(scale)*
	    (connection->target->state - Ffield(baseline));
	break;
    case RESET:
	Ffield(state) = connection->weight;
	break;
    }
}
#undef Ffield

#define Ffield(F)	Specific(connection,hebbsynapseB_type,F)

HebbSynapseB1(projection,connection,mode,offset_time,event)
Projection	*projection;
Connection	*connection;
int		mode;
float		offset_time;
Event		*event;
{
    switch(mode){
    case INIT:
	/*
	** implement decay
	*/
	Ffield(state) -= 
	(float)(Ffield(state)*Ffield(decay)*CLOCKRATE(projection));
	break;
    case PROCESS:
	/*
	** calculate the postsynaptic activation
	*/
	connection->target->activation +=
	event->magnitude *Ffield(state);
	/*
	** modify the weight
	*/
	Ffield(state) += 
	    Ffield(scale)*
	    event->magnitude*
	    (connection->target->state - Ffield(baseline));
	break;
    case RESET:
	Ffield(state) = connection->weight;
	break;
    }
}
#undef Ffield

#endif

