#include "sim.h"
#include <setjmp.h>

char	**global_envp;
jmp_buf main_context;

DisplayHeader()
{
printf("   ==========================================================================\n");
printf("                                  G E N E S I S\n");
printf("                            Neural Systems Simulator\n");
printf("                              Release Version: 1.1\n\n");
printf("                             Written by Matt Wilson\n");
printf("   ==========================================================================\n");
printf("                          Script Language Interpreter\n");
printf("                            Written by Dave Bilitch\n");
printf("                                and Matt Wilson\n");
printf("   ==========================================================================\n");
printf("                                XODUS Front-End\n");
printf("                            Written by U. S. Bhalla\n");
printf("                               and John D. Uhley\n");
printf("   ==========================================================================\n");
printf("                          Copyright 1988, 1989 & 1990\n");
printf("                      California Institute of Technology\n");
printf("   ==========================================================================\n");
printf("                    E-Mail : genesis@smaug.cns.caltech.edu\n");
printf("   ==========================================================================\n\n");

    system("/usr/games/fortune");
    printf("\n");
}

usage(s)
char *s;
{
    printf("usage : %s [-usage][-nosimrc][-nosig][-load][-batch][-status][script arg1 ...]\n",s);
}

main (argc, argv,envp)
int     argc;
char   *argv[];
char	**envp;
{
short     i,nxtarg;
extern	int	SetBreakFlag();
FILE	*pfile;
char	*pname;
int	file_arg;
char simfile[100];
short catch = 1;
char *home;
char string[100];
char *getenv();
int status_line=0;
int use_simrc;

    nxtarg = 0;
    use_simrc = 1;
    global_envp = envp;
    pname = NULL;
    while(++nxtarg < argc){
	if(arg_is("-load")){
	    EnableDynamicLoad();
	} else 
	if(arg_is("-defout")){
	    freopen(argv[++nxtarg],"w",stdout);
	} else 
	if(arg_is("-nosig")){
	    catch = 0;
	} else 
	if(arg_is("-batch")){
	    SetBatchMode(1);
	} else 
	if(arg_is("-status")){
	    status_line = 1;
	} else 
	if(arg_is("-nosimrc")){
	    use_simrc = 0;
	} else 
	if(arg_is("-usage")){
	    usage(argv[0]);
	    exit(0);
	} else {
	    pname = argv[nxtarg];			
	    file_arg = nxtarg;
	    break;
	}
    }

    /*
    ** get input from stdin
    */
    if(!IsBatchMode()){
	SetScript(stdin,0,NULL,0);
	DisplayHeader();
    }

    /*
    ** initialize the command interpreter
    */
    SetDefaultPrompt("genesis #!");

    if(!SetupInterp(argv[0])){
	printf("Unable to find the simulator. ");
	printf("Check your PATH environment variable\n");
	exit(0);
    };

    /*
    ** initialization for the base simulator
    */
    SimStartup();

    sleep(2);

    /*
    ** load the symbolic information for the rest of the libraries
    */
    LOAD_LIBRARIES();

    /*
    ** if a parameter file has been specified on the command line
    ** then read it in
    ** using the remaining command line args as args to the file
    */
    if(pname != NULL) {
	if((pfile=SearchForScript(pname,"r")) == NULL){
	    Error();
	    printf("can't open parameter file %s\n",pname);
	} else {
	    if(!IsSilent()) printf("%-20s%s\n","Simulation Script:",pname);
	    /*
	    ** try reading from the parameter file
	    */
	    AddScript(pfile,argc - file_arg,argv + file_arg,0);
	    /*
	    SetScript(pfile,argc - file_arg,argv + file_arg,0);
	    Interpreter(-1);
	    */
	}
    }
    /*
    ** try reading from the startup file
    */
    if(use_simrc){
	/*
	** first try and find it locally
	*/
	strcpy(string,".simrc");
	if((pfile=fopen(string,"r")) == NULL){
	    /*
	    ** else try and find it in the home directory
	    */
	    if(home = getenv("HOME")){
		sprintf(string,"%s/.simrc",home);
		pfile=fopen(string,"r");
	    } 
	}
	if(pfile){
	    if(!IsSilent()) printf("%-20s%s\n","Startup script:",string);
	    /*
	    * get input from .simrc
	    */
	    AddScript(pfile,0,NULL,0);
	}
    }
    /*
    ** if it is batch mode then dont bother going into
    ** interactive mode
    */
    if(!IsBatchMode()){
	if(status_line){
	    EnableStatusLine();
	}

	/*
	** put the terminal into non-blocking custom io mode
	*/
	terminal_setup();
	/*
	** set the return point for context jumps
	*/
	if(setjmp(main_context) != 0){
	    /*
	    ** coming back from a longjump
	    */
	    ClearScriptStack();
	    RemoveSimulationJob();
	    tset();
	}

	ParseInit();

	if(catch){
	    SetSignals();
	}
	/*
	** go to the interactive interpreter level
	*/
    }
    EnableHistory(1);
    AlternatePrompt(NULL);
    Interpreter(-1);
}

