#include "sim_ext.h"
#define MAXFILES 20

static FILE	*filefp[MAXFILES];
static char	*filename[MAXFILES];
static char	*filemode[MAXFILES];

do_showfiles()
{
int i;

    printf("\nOPEN ASCII FILES\n");
    printf("-----------------\n");
    for(i=0;i<MAXFILES;i++){
	if(filefp[i] != NULL){
	    printf("%-20s %s\n",filename[i],filemode[i]);
	}
    }
    printf("\n");
}

static FILE *GetFile(name)
char *name;
{
int i;

    if(name == NULL){
	return(NULL);
    }
    for(i=0;i<MAXFILES;i++){
	if(filename[i] != NULL && (strcmp(filename[i],name) == 0)){
	    return(filefp[i]);
	}
    }
    return(NULL);
}

static FILE *OpenFile(name,mode)
char *name;
char *mode;
{
int i;
FILE *fp;

    /*
    ** see whether the file is already open
    */
    if((fp = GetFile(name)) != NULL){
	/*
	** if it is then close it
	*/
	CloseFile(name);
    }
    /*
    ** try and open it
    */
    if((fp = fopen(name,mode)) == NULL){
	return(NULL);
    }
    /*
    ** if found then add it to the table
    */
    for(i=0;i<MAXFILES;i++){
	/*
	** find the first empty slot
	*/
	if(filefp[i] == NULL){
	    /*
	    ** add the file
	    */
	    filename[i] = CopyString(name);
	    filemode[i] = CopyString(mode);
	    filefp[i] = fp;
	    return(fp);
	}
    }
    return(NULL);
}

static int CloseFile(name)
char *name;
{
int i;

    if(name == NULL){
	return(0);
    }
    for(i=0;i<MAXFILES;i++){
	if(filename[i] != NULL && (strcmp(filename[i],name) == 0)){
	    free(filename[i]);
	    filename[i] = NULL;
	    if(filemode[i]) free(filemode[i]);
	    filemode[i] = NULL;
	    fclose(filefp[i]);
	    filefp[i] = NULL;
	    return(1);
	}
    }
    return(0);
}

int do_openfile(argc,argv)
int argc;
char **argv;
{
char *file;
char *mode;
FILE *fp;

    if(argc < 3){
	printf("usage: %s filename {r,w,a}\n",argv[0]);
	return(0);
    }
    file = argv[1];
    mode = argv[2];
    if((fp = OpenFile(file,mode)) == NULL){
	Error();
	printf("unable to open file '%s' with mode '%s'\n",file,mode);
	return(0);
    }
    return(1);
}

int do_closefile(argc,argv)
int argc;
char **argv;
{
    if(argc < 2){
	printf("usage: %s filename\n",argv[0]);
	return(0);
    }
    if(!CloseFile(argv[1])){
	Error();
	printf("unable to close file '%s'\n",argv[1]);
	return(0);
    }
    return(1);
}

int do_checkeof(argc,argv)
int argc;
char **argv;
{
FILE	*fp;

    if(argc < 2){
	printf("usage: %s filename\n",argv[0]);
	return(0);
    }
    if((fp = GetFile(argv[1])) == NULL){
	Error();
	printf("file '%s' is not open\n",argv[1]);
	return(0);
    }
    return(feof(fp));
}

char **do_readfile(argc,argv)
int argc;
char **argv;
{
char	line[1000];
int	fpargc;
char	**fpargv;
FILE	*fp;
int	nxtarg;
int	linemode = 0;
char	*filename;
char	*ptr;

    if(argc < 2){
	fprintf(stderr,"usage: %s [-l] filename\n",argv[0]);
	return(NULLArgv());
    }
    nxtarg = 0;
    while(++nxtarg < argc){
	if(strcmp(argv[nxtarg],"-l") == 0){
	    linemode = 1;
	} else
	if(argv[nxtarg][0] != '-'){
	    filename = argv[nxtarg];
	    if((fp = GetFile(filename)) == NULL){
		Error();
		fprintf(stderr,"file '%s' is not open \n",filename);
		return(NULLArgv());
	    }
	}
    }
    if(fp == NULL){
	fprintf(stderr,"no file specified\n");
	return(NULLArgv());
    }
    if(fgets(line,1000,fp) == NULL){
	Error();
	fprintf(stderr,"cannot read from file '%s'\n",filename);
	return(NULLArgv());
    }
    if(!linemode){
	StringToArgList(line,&fpargc,&fpargv);
    } else {
	fpargc = 1;
	fpargv = (char **)malloc(2*sizeof(char *));
	/*
	** zap any CR
	*/
	if((ptr = strchr(line,'\n')) != 0){
	    *ptr = '\0';
	}
	fpargv[0] = CopyString(line);
	fpargv[1] = NULL;
    }
    return(fpargv);
}

int do_writefile(argc,argv)
int argc;
char **argv;
{
int i;
FILE	*fp;
int	cr;
int	nxtarg;
char	*format;
int	userformat;

    if(argc < 2){
	printf("usage: %s filename [-n][-format str][arguments ...]\n",
	argv[0]);
	return(0);
    }
    if((fp = GetFile(argv[1])) == NULL){
	Error();
	printf("file '%s' is not open \n",argv[1]);
	return(0);
    }
    nxtarg = 1;
    cr = 1;
    format = "%s";
    userformat = 0;
    while( argc > ++nxtarg){
	if(strcmp(argv[nxtarg],"-n") == 0){
	    /*
	    ** no cr option
	    */
	    cr = 0;
	    continue;
	}
	if((argc > nxtarg+1) && (strcmp(argv[nxtarg],"-format") == 0)){
	    if(argc <= nxtarg+1){
		Error();
		printf("%s : missing formatting arguments\n",argv[0]);
		return(0);
	    }
	    /*
	    ** user formatting
	    */
	    format = argv[++nxtarg];
	    userformat = 1;
	    continue;
	}
	break;
    }
    for(i=nxtarg;i<argc;i++){
#ifdef mips
	if(fprintf(fp,format,argv[i]) == EOF){
#else
	if(fprintf(fp,format,argv[i]) <= 0){
#endif
	    Error();
	    printf("unable to write to file '%s'\n",argv[1]);
	    return(0);
	}
	if(i < argc-1 && !userformat){
	    /*
	    ** place a space after all but the last argument
	    */
	    fprintf(fp," ");
	}
    }
    if(cr){
	fprintf(fp,"\n");
    }
    OK();
    return(1);
}

CloseAllAsciiFiles()
{
int i;

    for(i=0;i<MAXFILES;i++){
	if(filefp[i] != NULL){
	    CloseFile(filename[i]);
	}
    }
}

