#include "sim_ext.h"

static Action show_action = { "SHOW", SHOW, NULL, 0, NULL, NULL };

int GetDatatype(type)
char *type;
{
    if(type == NULL){
	return(INVALID);
    }
    if(strcmp(type,"char") == 0){
	return(CHAR);
    } else
    if(strcmp(type,"short") == 0){
	return(SHORT);
    } else
    if(strcmp(type,"int") == 0){
	return(INT);
    } else
    if(strcmp(type,"float") == 0){
	return(FLOAT);
    } else
    if(strcmp(type,"double") == 0){
	return(DOUBLE);
    } else
    return(INVALID);
}


DisplayOneField(adr,type,field)
char *adr;
char *type;
char *field;
{
Info 		info;
int 		dim;
int 		i;
int 		j;
char		pr[100];
char 		ival[20];
int 		offset;
int 		total;
int 		mod;
char 		*dstring;
char		name[100];

    /*
    ** construct the variable specifier of the form:
    ** datatype.fieldname
    */
    strcpy(name,type);
    strcat(name,".");
    strcat(name,field);
    /*
    ** get information on the variable specifier
    */
    if(GetInfo(name,&info)){
	/*
	** get the value of the variable in generic string form
	*/
	dstring = GetValue(adr + info.offset,&info);
	/*
	** if it fails then try to recursively display
	** the fields of the field
	** this is assuming that the unknown field is
	** a structure and has other fields in it
	*/
	if(strlen(dstring) == 0){
#ifdef RECURSIVE
	    if(info.struct_type == 1){
		printf("(%s)\n",field);
		DisplayFields(adr+info.offset,info.type);
	    } else
#endif
		/*
		** use the string ??? to indicate an unknown value
		*/
		FieldFormat(field,"???");
	} else {
	    /*
	    ** is this variable an array?
	    */
	    if(info.dimensions == 0){
		/*
		** if not then just print the value
		*/
		FieldFormat(field,dstring);
	    } else {
		/*
		** if it is an array then
		** construct a string which contains the field
		** name along with the array dimensions
		*/
		strcpy(pr,field);
		for(i=0;i<info.dimensions;i++){
		    sprintf(ival,"[%d]",info.dimension_size[i]);
		    strcat(pr,ival);
		}
		/*
		** and display it
		*/
		printf("%-20s = ",pr);
		total = 1;
		for(i=0;i<info.dimensions;i++){
		    total *= info.dimension_size[i];
		}
		printf("{ ");
		offset = info.offset;
		for(i=0;i<total;i++){
		    dstring = GetValue(adr + offset,&info);
		    printf("%s , ",dstring);
		    mod = 1;
		    for(j=info.dimensions-1;j>=0;j--){
			mod *= info.dimension_size[j];
			if(i < total -1){
			    if((i +1)%mod == 0) printf("},{");
			} else
			    printf("}");
		    }
		    if(info.field_indirection == 0){
			offset += info.type_size;
		    } else {
			offset += sizeof(char *);
		    }
		}
		printf("\n");
	    }
	}
    } else {
	printf("could not find field %s\n",field);
    }
}

DisplayFields(element,object,adr,type,start_field,after)
Element	*element;
GenesisObject 	*object;
char 	*adr;
char	*type;
char	*start_field;
int	after;
{
char 		*ptr;
char 		*tmp;
char		field[100];
char 		string[1000];
int		reached = 0;
extern char 	*FieldHashFind();
int		already_shown;
PFI		func;

    if(adr == NULL) return(0);
    /*
    ** get the string containing all of the fields for given data structure
    */
    ptr = FieldHashFind(type);
    if(ptr == NULL) return(0);
    /*
    ** copy the field list into a safe place
    */
    strcpy(string,ptr);
    ptr = string;
    while(*ptr != '\0'){
	/*
	** find the next field in the list by searching for a CR
	*/
	tmp = ptr;
	while(*tmp != '\n') tmp++;
	*tmp = '\0';
	/*
	** get the field name
	*/
	strcpy(field,ptr);
	/*
	** advance the ptr beyond the field name
	*/
	ptr = tmp+1;
	/*
	** if a starting field has been specified then check
	** to see if it has been reached
	*/
	if(start_field && !reached){
	    if(strcmp(field,start_field) != 0){
		/*
		** if it hasnt then continue
		*/
		continue;
	    }
	    /*
	    ** otherwise indicate that the field has been found
	    */
	    reached = 1;
	    /*
	    ** if the non-inclusive flag is set then start after
	    ** this field
	    */
	    if(after) continue;
	}
	/*
	** if the object has the SHOW action then give it the
	** first shot
	*/
	already_shown = 0;
	if(object && (func = GetActionFunc(object,SHOW))){
	    /*
	    ** if it does then call the function with the action
	    */
	    show_action.data = field;
	    if(already_shown = func(element,&show_action)){
		FieldFormat(field,show_action.passback);
	    }
	} 
	if(!already_shown){
	    DisplayOneField(adr,type,field);
	}
    }
}

FieldFormat(field,value)
char *field;
char *value;
{
    printf("%-20s = %s\n", field,value);
}

char *FieldValue(adr,object,field)
char	*adr;
GenesisObject	*object;
char	*field;
{
char *value;
int	status;
int	already_shown;
PFI	func;

    if(adr == NULL || object == NULL || field == NULL){
	return(NULL);
    }
    already_shown = 0;
    if(func = GetActionFunc(object,SHOW)){
	/*
	** if it does then call the function with the action
	*/
	show_action.data = field;
	already_shown = func(adr,&show_action);
	value = show_action.passback;
    } 
    if(!already_shown){
	value = GetFieldStr(adr,object->type,field,&status);
	if(!status){
	    /*
	    Error();
	    printf("could not find field '%s'\n",field);
	    */
	    return(NULL);
	}
    }
    return(value);
}

DisplayField(adr,object,field)
char 	*adr;
GenesisObject 	*object;
char 	*field;
{
char	*value;

    if(adr == NULL || object == NULL) return;

    if((value = FieldValue(adr,object,field)) != NULL){
	FieldFormat(field,value);
    }
}

char *GetFieldStr(adr,type,field,status)
char 	*adr;
char 	*type;
char 	*field;
int	*status;
{
char *address;
Info info;
char tmpstr[1000];
static char str[1000];

    if((address = CalculateAddress(adr,type,field,&info)) != NULL){
	*status = 1;
	/*
	** if it is a structure then return the entire contents of the
	** structure
	*/
	return(GetValue(address,&info));
    } else {
	*status = 0;
	return(NULL);
    }
}

char *GetFieldAdr(element,field,datatype)
Element 	*element;
char 		*field;
short 		*datatype;
{
char 	*address;
Info 	info;

    if((address = CalculateAddress(element,Type(element),field,&info)) != NULL){
	*datatype = GetDatatype(info.type);
	return(address);
    } else
	return(NULL);
}

char **do_getfields(argc,argv)
int argc;
char **argv;
{
extern char 	*FieldHashFind();
int fargc;
char **fargv;
char string[1000];
char *ptr;
Element *element;

    if(argc < 2){
	printf("usage: %s element\n",argv[0]);
	return(NULL);
    }
    element = GetElement(argv[1]);
    /*
    ** get the field string
    */
    ptr = FieldHashFind(Type(element));
    if(ptr == NULL) return(NULL);
    strcpy(string,ptr);
    StringToArgList(string,&fargc,&fargv,0);
    return(fargv);
}

char *FormatStruct(s)
char *s;
{
static char string[1000];
char *ptr;

    /*
    ** get the string containing all of the fields for given data structure
    */
    if(s == NULL) return(0);
    ptr = string;
    for(;*s != '\0';s++){
	if(*s == '\n'){
	    *ptr = '\n';
	    ptr++;
	    *ptr = '\t';
	    ptr++;
	    *ptr = '\t';
	    ptr++;
	    *ptr = '\t';
	} else {
	    *ptr = *s;
	}
	ptr++;
    }
    *ptr = '\0';
    return(string);
}

