#include "sim_ext.h"
#include "hash.h"

HASH *class_hash_table;

int CheckClass(element,id)
Element *element;
int 	id;
{
ClassList	*class;

    /*
    ** search the class list of the element
    */
    for(class=element->object->class;class;class=class->next){
	if(class->id == id){
	    return(1);		/* found */
	}
    }
    return(0);			/* not found */
}

/*
** Hash table utilities
*/
void ClassHashInit()
{
HASH *hash_create();

    /*
    ** create the table
    */
    class_hash_table = hash_create(100);
}

int ClassHashPut(key,class)
char	*key;
int 	class;
{
ENTRY	item,*hash_enter();

    item.data = (char *)malloc(sizeof(int));
    *((int *)(item.data)) = class;
    item.key = CopyString(key);
    /*
    ** put the class into the table
    */
    if(hash_enter(&item,class_hash_table) == NULL){
	Error();
	printf("class hash table full\n");
	return(0);
    };
    return(1);
}

int ClassHashFind(key)
char	*key;
{
ENTRY	*found_item,*hash_find();

    /*
    ** get the class from the table
    */
    if((found_item = hash_find(key,class_hash_table)) != NULL){
	return(*((int *)(found_item->data)));
    } else
	return(NULL);
}

int ClassID(name)
char	*name;
{
int	id;

    /*
    ** look up the class name in the class id table
    */
    id = ClassHashFind(name);
    return(id);
}

char *GetClassName(id)
int	id;
{
extern HASH *class_hash_table;
char 	*name;
int 	i;

    for(i=0;i<class_hash_table->size;i++){
	if(name = class_hash_table->entry[i].key){
	    if(id == *((int *)(class_hash_table->entry[i].data))){
		return(name);
	    }
	}
    }
    return("???");
}

int AddClass(name,class)
char 	*name;
int	class;
{
    ClassHashPut(name,class);
}

void do_add_class(argc,argv)
int	argc;
char 	**argv;
{
char	*name;
char	*newclass;
int	id;
int	i;

    if(argc < 2){
	printf("usage: %s classname\n",argv[0]);
	return;
    }
    newclass = argv[1];
    /*
    ** find a new class by getting the max class id and adding one
    */
    id = 0;
    for(i=0;i<class_hash_table->size;i++){
	/*
	** is this a non-NULL class name
	*/
	if(name = class_hash_table->entry[i].key){
	    /*
	    ** check the new class to see if it matches an existing
	    ** class
	    */
	    if(strcmp(newclass,name) == 0){
		/*
		** if it does then dont bother adding it
		*/
		return;
	    }
	    /*
	    ** check its id against the largest found so far
	    */
	    id = MAX(id,*((int *)(class_hash_table->entry[i].data)));
	}
    }
    AddClass(newclass,id+1);
}

void BasicClasses()
{
    AddClass(	"element",	ELEMENT_ELEMENT		);
    AddClass(	"segment",	SEGMENT_ELEMENT		);
    AddClass(	"buffer",	BUFFER_ELEMENT		);
    AddClass(	"projection",	PROJECTION_ELEMENT	);
    AddClass(	"connection",	CONNECTION_ELEMENT	);
}

void do_list_classes()
{
extern HASH *class_hash_table;
char 	*name;
int	cnt=0;
int 	i;

    printf("\DEFINED CLASSES:\n");
    for(i=0;i<class_hash_table->size;i++){
	if(name = class_hash_table->entry[i].key){
	    printf("%-12s", name);
	    if(((++cnt)%4) == 0){
		printf("\n");
	    }
	}
    }
    printf("\n\n");
}
