#include "sim_ext.h"

/*
** check the consistency of the time intervals for the 
** buffers projections and segments
*/
CheckSimulation()
{
Element			*element;
Projection 		*projection;
Buffer			*buffer;
Connection 		*connection;
int			j,k;
ElementStack		*stk;
float 			simulation_dt;
PFI 			func;
Action			*action;

    Reschedule();
    simulation_dt = ClockValue(0);
    if(simulation_dt <= 0.0){
	Error();
	printf("Invalid simulation step size of %f\n",simulation_dt);
    }
    /*
    ** go through each enabled element
    */
    stk = NewPutElementStack(RootElement());
    /*
    ** scan all elements except those that are disabled
    */
    action = GetAction("CHECK");
    while(element = NewFastNextElement(1,stk)){
	if(Clockrate(element) < simulation_dt){
	    Error();
	    printf("the interval for '%s' (%f) ",
	    Pathname(element),
	    Clockrate(element));
	    printf("is less than the simulation dt (%f)\n",
	    simulation_dt);
	}
	/*
	** does the object have a check action?
	*/
	if(func = GetActionFunc(element->object,CHECK)){
	    /*
	    ** call the function which will process the segment
	    */
	    func(element,action);
	}
	/*
	** check the projections
	*/
	if(CheckClass(element, PROJECTION_ELEMENT)){
	    projection = (Projection *)element;
	    if(Clockrate(projection) < simulation_dt){
		Error();
		printf("the projection interval for '%s' (%f) ",
		Pathname(projection),
		Clockrate(projection));
		printf("is less than the simulation dt (%f)\n",
		simulation_dt);
	    }
	    /*
	    ** do the connections have a check action?
	    */
	    if(projection->connection_object){
		func = GetActionFunc(projection->connection_object,CHECK);
	    } else {
		func = NULL;
	    }
	    /*
	    ** check each connection
	    */
	    for(connection=projection->connection;
	    connection;connection = connection->next){
		if(connection->target == NULL){
		    Error();
		    printf("NULL destination segment for projection '%s'\n",
		    Pathname(projection));
		} else
		/*
		** check the time intervals of each destination
		** segment for each absolute connection
		*/
		if(Clockrate(projection) <
		Clockrate(connection->target)){
		    /*
		    ** if they are not the same then flag it
		    */
		    Warning();
		    printf("projection '%s' updates more rapidly than segment '%s'\n",
		    Pathname(projection),
		    Pathname(connection->target));
		}
		if(func){
		    /*
		    ** call the function which will check the connection
		    */
		    func(connection,action,projection);
		}
	    }
	}
    }
    NewFreeElementStack(stk);
    CHECK_Simulate();
} 
