#include "sim_ext.h"

int CallElement(element,action)
Element *element;
Action *action;
{
PFI	func;

    if(element == NULL || action == NULL){
	return(0);
    }
    /*
    ** call the element function with the desired action
    */
    if((func = GetActionFunc(element->object,action->type)) != NULL){
	func(element,action);
    } else {
	return(0);
    }
    return(1);
}

char *do_call_element(argc,argv)
int	argc;
char	**argv;
{
Element	*element;
ElementList *list;
Action	*action;
int	i;

    if(argc < 3){
	printf("usage: %s path action [args]\n",argv[0]);
	return(NULL);
    }
    if((action = GetAction(argv[2])) == NULL){
	Error();
	printf("%s : could not find action '%s'.\n",argv[0],argv[2]);
	return(NULL);
    }
    action->argc = argc-3;
    action->argv = argv+3;
    action->passback = NULL;
    list = WildcardGetElement(argv[1],1);
    if(list->nelements <= 0){
	Error();
	printf("%s : invalid path '%s'.",argv[0],argv[1]);
	return(NULL);
    }
    for(i=0;i<list->nelements;i++){
	element = list->element[i];
	if(!CallElement(element,action)){
	    Error();
	    printf("could not call '%s' with action '%s'\n",
	    Pathname(element),
	    argv[2]);
	    return(NULL);
	}
    }
    OK();
    return(CopyString(action->passback));
}
