#include "shell_ext.h"
#include <sys/types.h>
#include <sys/stat.h>

#define MAXSCRIPTS	20
#define SIZE 80

short	script_ptr = -1;
Script	script[MAXSCRIPTS];

extern char **CopyArgv();

ValidScript(fp)
FILE *fp;
{
char line[80];
char *lineptr;
int i;

    if(fp == NULL) return(0);
    /*
    ** check for the magic word at the beginning of the file
    */
    line[0] = '\0';
    while(EmptyLine(line) && !feof(fp)){
	fgets(line,SIZE,fp);
    }
    /*
    ** skip white space
    */
    i = 0;
    while(line[i] == ' ' && i < SIZE-1) i++;
    if((i < SIZE-2) && (strncmp(line+i,"//",2) == 0)){
	i += 2;
	/*
	** skip more white space
	*/
	while(line[i] == ' ' && i < SIZE-1) i++;
	if((i <= SIZE - strlen("genesis")) && 
	(strncmp(line+i,"genesis", strlen("genesis")) ==  0)) {
	    fseek(fp,0L,0);
	    return(1);
	}
    }
    fclose(fp);
    return(0);
}
#undef SIZE
/*
** file script utilities (used by the 'source' command)
*/
SetScript(ptr,argc,argv,type)
char *ptr;
int argc;
char **argv;
short type;
{
char **newargv;

    if(ptr == NULL) return;
    script_ptr = 0;
    script[script_ptr].ptr = ptr;
    script[script_ptr].current = ptr;
    script[script_ptr].type = type;
    script[script_ptr].argc = argc;
    /*
    ** make a copy of the argv list
    */
    script[script_ptr].argv = CopyArgv(argc,argv);
    script[script_ptr].line = 0;
}
AddScript(ptr,argc,argv,type)
char *ptr;
int argc;
char **argv;
short type;
{
    if(ptr == NULL) return;
    if(script_ptr+1 < MAXSCRIPTS){
	script_ptr++;
	script[script_ptr].ptr = ptr;
	script[script_ptr].current = ptr;
	script[script_ptr].type = type;
	script[script_ptr].argc = argc;
	script[script_ptr].argv = CopyArgv(argc,argv);
	script[script_ptr].line = 0;
    } else {
	Error();
	printf("file script stack overflow\n");
    }
#ifdef NEW
    if(argc > 0)
	PushLocalVars(argc,argv,NULL);
#endif
}

#ifdef OLDTRACE
TraceScript()
{
int i;
int once = 0;

    for(i=0;i<=script_ptr;i++){
	if(script[i].type == FILE_TYPE && (FILE *)(script[i].ptr) == stdin){
	    continue;
	} else {
	    once = 1;
	    printf("-> ");
	    if(script[i].type == STR_TYPE){
		printf("MACRO ");
	    } 
	    if(script[i].argc > 0){
		printf(" line %d of %s ",script[i].line,script[i].argv[0]);
	    } else {
		printf(" line %d of ??? ",script[i].line);
	    }
	}
    }
    if(once) printf("\n");
}
#endif
FILE *NextScriptFp()
{
    if(script_ptr > 0){
	/*
	** close the current file
	*/
	if(script[script_ptr].type == FILE_TYPE){
	    fclose(script[script_ptr].ptr);
	    fclose(script[script_ptr].ptr);
	} else
	    script[script_ptr].current = script[script_ptr].ptr;
#ifdef NEW
    if(script[script_ptr].argc > 0)
	PopLocalVars();
#endif
	return((FILE *)(script[--script_ptr].ptr));
    } else {
	return(NULL);
    }
}

Script *NextScript()
{
    if(script_ptr > 0){
	/*
	** close the current file
	*/
	if(script[script_ptr].type == FILE_TYPE){
	    fclose(script[script_ptr].ptr);
	} else
	    script[script_ptr].current = script[script_ptr].ptr;
#ifdef NEW
    if(script[script_ptr].argc > 0)
	PopLocalVars();
#endif
	return(&(script[--script_ptr]));
    } else {
	return(NULL);
    }
}

ClearScriptStack()
{
    while(script_ptr > 0){
	NextScript();
    }
}

ScriptDepth()
{
    return(script_ptr);
}

Script *CurrentScript()
{
    if(script_ptr >= 0)
	return(&(script[script_ptr]));
    else
	return(NULL);
}

FILE *CurrentScriptFp()
{
    if(script_ptr >= 0)
	return((FILE *)(script[script_ptr].ptr));
    else
	return(NULL);
}

char *CurrentScriptName()
{
    if(script_ptr >= 0 && script[script_ptr].argc > 0)
	return(script[script_ptr].argv[0]);
    else
	return(NULL);
}

int CurrentScriptLine()
{
    if(script_ptr >= 0)
	return(script[script_ptr].line);
    else
	return(-1);
}


ScriptEnded()
{
    if(script_ptr >= 0){
	switch(script[script_ptr].type){
	case FILE_TYPE:
#ifdef NEW
    if(script[script_ptr].argc > 0)
	    PopLocalVars();
#endif
	    return(feof((FILE *)(script[script_ptr].ptr)));
	    break;
	case STR_TYPE:
#ifdef NEW
    if(script[script_ptr].argc > 0)
	    PopLocalVars();
#endif
	    return(*(script[script_ptr].current) == '\0');
	    break;
	}
    } else
	return(0);
}

ScriptArgc()
{
    if(script_ptr >= 0)
	return(script[script_ptr].argc);
    else
	return(0);
}

char *ScriptArgv(arg)
int arg;
{
    if((script_ptr >= 0) && (arg < script[script_ptr].argc)){
	return(script[script_ptr].argv[arg]);
    } else {
	return("");
    }
}

void EndScript()
{
    NextScript();
}

int IsFile(fp)
FILE *fp;
{
struct stat buf;
    if(!fp) return(0);
    if(fstat(fileno(fp),&buf) == -1 || buf.st_mode & S_IFDIR){
	return(0);
    } else {
	return(1);
    }
}

FILE *OpenScriptFile(name,mode)
char *name;
char *mode;
{
FILE *fp;
char extname[300];

    /*
    ** try to open the file directly
    */
    if((fp = fopen(name,mode)) == NULL){
	/*
	** if that fails then try looking for the same file
	** with the .g extension
	*/
	sprintf(extname,"%s.g",name);
	fp = fopen(extname,mode);
    } else {
	/*
	** is it a real file?
	*/
	if(!IsFile(fp)){
	    return(NULL);
	}
    }
    return(fp);
}

/*
** search the paths given in SIMPATH environment variable
** if the SIMPATH variable is not found then just search the
** current directory
*/
FILE *SearchForScript(name,mode)
char *name;
char *mode;
{
char prefix[300];
char *prefixptr;
char *path;
FILE *fp;
char *getenv();

    if(name == NULL) return(NULL);
    path = getenv("SIMPATH");
    fp = NULL;
    /*
    ** if there is no search path defined or it is an absolute
    ** path then dont search
    */
    if((path == NULL) || (name[0] == '/')){
	/*
	** just look it up in current directory
	*/
	fp = OpenScriptFile(name,mode);
    } else {
	/*
	** follow the paths in order trying to find the file
	*/
	while(fp == NULL && path != NULL && *path != '\0'){
	    /*
	    ** skip white space
	    */
	    while(IsWhiteSpace(*path) && *path != '\0') path++;
	    /*
	    ** copy the path up to a space
	    */
	    prefixptr = prefix;
	    while(!IsWhiteSpace(*path) && *path != '\0') {
		*prefixptr++ = *path++;
	    }
	    *prefixptr = '\0';
	    /*
	    ** now try to open the file
	    */
	    if(prefix[0] != '\0'){
		strcat(prefix,"/");
		strcat(prefix,name);
		fp = OpenScriptFile(prefix,mode);
	    }
	}
    }
    return(fp);
}

void do_where(argc,argv)
int argc;
char **argv;
{
char prefix[300];
char tmp[300];
char *prefixptr;
char *path;
char *env;
FILE *fp;
char *getenv();
char *name;

    if(argc < 2){
	printf("usage: %s script\n",argv[0]);
	return;
    }
    name = argv[1];
    env = path = getenv("SIMPATH");
    fp = NULL;
    if(path == NULL){
	/*
	** just look it up in current directory
	*/
	fp = fopen(name,"r");
	if(fp != NULL){
	    fclose(fp);
	    printf("'%s' found in current directory \n",name);
	    return;
	} else {
	    printf("could not find '%s' in current directory\n",name);
	    return;
	}
    } else {
	/*
	** follow the paths in order trying to find the file
	*/
	while(fp == NULL && path != NULL && *path != '\0'){
	    /*
	    ** skip white space
	    */
	    while(IsWhiteSpace(*path) && *path != '\0') path++;
	    /*
	    ** copy the path up to a space
	    */
	    prefixptr = prefix;
	    while(!IsWhiteSpace(*path) && *path != '\0') {
		*prefixptr++ = *path++;
	    }
	    *prefixptr = '\0';
	    if(prefix[0] != '\0'){
		strcpy(tmp,prefix);
		strcat(tmp,"/");
		strcat(tmp,name);
		fp = fopen(tmp,"r");
	    }
	    if(fp != NULL){
		printf("'%s' found in %s\n",name,prefix);
		fclose(fp);
		return;
	    }
	}
    }
    printf("could not find '%s' in %s\n",name,env);
}

void do_source(argc,argv)
int argc;
char **argv;
{
FILE	*pfile;

    if(argc < 2){
	printf("usage: %s script\n",argv[0]);
	return;
    }
    /*
    ** try to open the named script
    */
    if((pfile = SearchForScript(argv[1],"r")) != NULL){
	if(debug > 0){
	    printf("source %s\n",argv[1]);
	}
	/*
	** activate the script and pass it the remaining
	** arguments on the command line
	*/
	AddScript(pfile,argc - 1,argv+1,FILE_TYPE);
    } else {
	Error();
	printf("unable to open file %s\n",
	argv[1]);
    }
}

int IncludeScript(argc,argv)
int 	argc;
char	**argv;
{
FILE	*pfile;

    /*
    ** try to open it as a script
    */
    if((pfile = SearchForScript(argv[0],"r")) != NULL){
	AddScript(pfile,argc,argv,FILE_TYPE);
	return(1);
    } else {
	return(0);
    }
}

int IsInclude(s)
char	*s;
{
FILE	*pfile;

    /*
    ** try to open it as a script
    */
    if((pfile = SearchForScript(s,"r")) != NULL){
	fclose(pfile);
	return(1);
    } else {
	return(0);
    }
}


/*
** search the paths given in PATH environment variable
** if the PATH variable is not found then just search the
** current directory
*/
FILE *SearchForExecutable(name,mode,pathname)
char *name;
char *mode;
char **pathname;
{
char prefix[300];
char *prefixptr;
char *path;
FILE *fp;
char *getenv();

    if(name == NULL) return(NULL);
    path = getenv("PATH");
    fp = NULL;
    /*
    ** if there is no search path defined or it is an absolute
    ** path then dont search
    */
    if((path == NULL) || (name[0] == '/')){
	/*
	** just look it up in current directory
	*/
	if(!IsFile(fp = fopen(name,mode))){
	    fclose(fp);
	    fp = NULL;
	} else {
	    *pathname = CopyString(name);
	}
    } else {
	/*
	** follow the paths in order trying to find the file
	*/
	while(fp == NULL && path != NULL && *path != '\0'){
	    /*
	    ** skip white space
	    */
	    while(IsWhiteSpace(*path) && *path != '\0') path++;
	    /*
	    ** copy the path up to a space
	    */
	    prefixptr = prefix;
	    while(!IsWhiteSpace(*path) && *path != '\0' &&
	    *path !=':') {
		*prefixptr++ = *path++;
	    }
	    if(*path == ':'){
		path++;
	    }
	    *prefixptr = '\0';
	    /*
	    ** now try to open the file
	    */
	    if(prefix[0] != '\0'){
		strcat(prefix,"/");
	    }
	    strcat(prefix,name);
	    if(!IsFile(fp = fopen(prefix,mode))){
		if(fp) fclose(fp);
		fp = NULL;
	    } else {
		*pathname = CopyString(prefix);
	    }
	}
    }
    return(fp);
}
