static int warning_cnt = 0;
static int error_cnt = 0;
static int silent = 0;
static int max_warnings = 20;
static int max_errors = 10;

SetSilent(x) 
int x; 
{ 
    silent = x; 
}

IsSilent() { return(silent || InControlStructure()); }

int do_silent(argc,argv)
int	argc;
char	**argv;
{
    if(argc > 1){
	silent =atoi(argv[1]);
    }
    return(silent);
}


MaxWarnings(i)
int i;
{
    max_warnings = i;
}

MaxErrors(i)
int i;
{
    max_errors = i;
}

do_set_maxwarnings(argc,argv)
int argc;
char **argv;
{
    if(argc > 1){
	max_warnings = atoi(argv[1]);
    }
    if(!silent)
	printf("max warnings = %d\n",max_warnings);
}

do_set_maxerrors(argc,argv)
int argc;
char **argv;
{
    if(argc > 1){
	max_errors = atoi(argv[1]);
    }
    if(!silent)
	printf("max errors = %d\n",max_errors);
}

ResetErrors()
{
    warning_cnt = 0;
    error_cnt = 0;
}

Warning()
{
    if(!silent){
	TraceScript();
	printf("* Warning - ");
    }
    warning_cnt++;
    if(warning_cnt > max_warnings){
	printf("Exceeded the maximum number of warnings (%d)\n",
	max_warnings);
	warning_cnt = 0;
	restore_context();
    }
}

Error()
{
    TraceScript();
    printf("** Error - ");
    error_cnt++;
    if(error_cnt > max_errors){
	printf("Exceeded the maximum number of errors (%d)\n",
	max_errors);
	error_cnt = 0;
	restore_context();
    }
}

DisplayErrors()
{
    printf("\n");
    printf("%d Warnings\n",warning_cnt);
    printf("%d Errors\n",error_cnt);
    printf("\n");
}

yyerror(s)
char *s;
{
    Error();
    printf("%s\n",s);
    restore_context();
}
