// genesis

/*
************************************************************************
**                       SEGMENT SHELL COMMANDS                     **
************************************************************************
*/
addfunc		balanceEm		do_balance_Em

/*
*************************************************************************
**                              OBJECT TABLE                           **
*************************************************************************
*/
//==========================================================================
//	name		data            function	class	
//==========================================================================

object	channelA	channelA_type	ChannelA      	segment channel	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	VOLTAGE 0 	1 Vm \		/* type 0: Vm */
			ACTIVATION 1	1 activation \	/* type 1: activation */
	-fields		"Ek = equilibrium potential" \
	-description	"Direct mapping of activation to conductance." \
			"Calculates Ik = (Ek - Vk)Gk."

object	channelB	channelB_type 	ChannelB      	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	VOLTAGE 0 	1 Vm \	
			ACTIVATION 1 	1 activation \
	-fields		tau_ak gain_ak tau_gk gain_gk  \
			"Ek = equilibrium potential"

object	channelC	channelC_type 	ChannelC      	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK RECALC SAVE2 RESTORE2 \
	-messages	ACTIVATION 	0	1 activation \
			RAND_ACTIVATION 1 	2 probability amplitude \
	-fields		"tau1 tau2  = time constants of channel activation" \
			"gmax = peak conductance" 

object	channelC2	channelC2_type 	ChannelC2      	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK RECALC SAVE2 RESTORE2 \
	-messages 	VOLTAGE 	0 	1 Vm \	
			ACTIVATION 	1 	1 activation \
			RAND_ACTIVATION 2 	2 probability amplitude \
	-fields		"tau1 tau2  = time constants of channel activation" \
			"gmax = peak conductance" \
			"Ik = channel current"

object	manuelconduct	manuelconduct_type ManuelConduct  segment channel \
	-author 	"M.Wilson Caltech 2/89" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages	VOLTAGE 	0	1 Vm \
			ACTIVATION 	1	1 activation \
			RAND_ACTIVATION 2 	2 probability amplitude \
	-fields		"tau_g = opening time" \
			"tau_h = closing time" \
			"tau_d = transmitter decay time" \
			"K_r  = dissociation constant for transmitter binding" \
			"gmax = channel conductance per unit of transmitter"

object	Ca_concen	Ca_concen_type CaConcen  segment channel \
	-author 	"M.Wilson Caltech 2/89" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages	I_Ca 0		1 I_Ca \
			fI_Ca 1		2 I_Ca fraction \
	-fields		tau Ca_base  \
	-description	"Single shell model for Ca concentration"

object	leakage		leakage_type 	Leakage  	segment channel \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	VOLTAGE 0 	1 Vm \
	-fields		Ek Gk

object	compartment	compartment_type Compartment  	segment membrane \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK SAVE2 RESTORE2 \
	-messages 	CHANNEL 0 	2 Gk Ek \
			RAXIAL	1	2 Ra Vm \
			AXIAL	2	1 Vm \
			INJECT	3	1 inject \
	-fields		"Rm = membrane resistance" \
			"Cm = membrane capacitance" \
			"Em = resting potential" \
			"Ra = axial resistance" \
			"inject = injected current" \
			method spikes \
	-description 	"Axially asymmetric compartment. Ra is located on" \
			"one side of the compartment. This is slightly more" \
			"computationally efficient than the symmetric" \
			"counterpart."

object	symcompartment	symcompartment_type SymCompartment  segment membrane \
	-author 	"M.Wilson Caltech 5/89" \
	-actions 	INIT PROCESS RESET CHECK \
	-messages 	CHANNEL 0 	2 Gk Ek \
			RAXIAL	1	2 Ra Vm \
			RAXIAL2	2	2 Ra Vm \
			AXIAL	2	2 Ra Vm \
			CONNECTHEAD	1	2 Ra Vm \
			CONNECTTAIL	2	2 Ra Vm \
			INJECT	3	1 inject \
	-fields		"Rm = membrane resistance" \
			"Cm = membrane capacitance" \
			"Em = resting potential" \
			"Ra = total axial resistance" \
			"inject = injected current" \
			method spikes \
	-description 	"Axially symmetric compartment. Ra is divided into" \
			"two equal components across the compartment."

object	unit		unit_type 	Unit 		segment 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions	INIT RESET PROCESS CHECK \
	-messages 	INJECT 	0 	1 inject \
	-fields		Em inject

object	RC		RCunit_type 	RC_Unit		segment 	\	
	-author 	"M.Wilson Caltech 6/88" \
	-actions	RESET PROCESS CHECK \
	-messages 	INJECT 	0 	1 inject \
	-fields		V0 R C state inject method

object	site		site_type 	Site 		segment 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions	INIT RESET PROCESS

