#include "seg_ext.h"

do_clear_buffer(argc,argv)
int 	argc;
char 	**argv;
{
char 		*pathname;
Buffer 		*buffer;
int stk;

    if(argc < 2){
	printf("usage: %s buffer ...\n",argv[0]);
	return(0);
    }
    pathname = argv[1];
    buffer = (Buffer *)GetElement(pathname);
    buffer->end = buffer->current = buffer->start;
}

do_get_input (argc,argv) 
int	argc;
char	**argv;
{
float		xs,xe,ys,ye,x,y;
float		stim_time;
float		stim_magnitude;
float		random_input_p;
float		random_input_amp;
float		dt;
Event	 	event;
Element	 	*element;
Element	 	*parent;
Buffer	 	*buffer;
char 		*buffername;
short		nxtarg;
char		*pathname;
int 		stk;

    if(argc < 3){
	printf("usage: %s parent:buffer ...\n",argv[0]);
	return(0);
    }

    pathname = GetPathComponent(argv[1]);
    buffername = GetFieldComponent(argv[1]);
    parent = GetElement(pathname);
    if(parent == NULL){
	printf("could not find element '%s'\n",argv[1]);
	return(0);
    }
    if(parent->child == NULL){
	printf("'%s' not a parent element\n",argv[1]);
	return(0);
    }

    if (debug >0){
	printf ("%s %s\n",argv[0],argv[1]);
    }

    /*
    * get a string from the parameter file which indicates
    * how to specify the input
    */
    nxtarg = 2;
    if(arg_is("RANDOM")){
	int     ptr;
	float   curtime,maxtime,starttime;
	xs = farg();
	ys = farg();
	xe = farg();
	ye = farg();
	while(xs >= 0) {
	    random_input_p = farg();
	    random_input_amp = farg();
	    starttime = farg();
	    maxtime = farg();
	    stk = PutElementStack(parent);
	    while((element = NextElement(1,BUFFER_ELEMENT,stk)) != NULL){
		if(element->x >= xs && element->x <= xe &&
		element->y >= ys && element->y <= ye){
		    curtime = starttime;
		    dt = Clockrate(buffer);
		    while(curtime < maxtime) {
			if (frandom (0, 1) <= random_input_p*dt) {
#ifdef FLOATTIME
			    event.time = curtime;
#else
			    event.time = curtime/dt;
#endif
			    event.magnitude = random_input_amp;
			    InsertEvent(buffer,&event,NULL, EXPAND);
			}
			curtime += dt;
		    }
		}
	    }
	    FreeElementStack(stk);
	    xs = farg();
	    ys = farg();
	    xe = farg();
	    ye = farg();
	}
    } else
    if (arg_is("RANDOM MODULATED") ) {
	int     ptr;
	float   curtime,maxtime,starttime;
	float	mod_p;
	float	min_p,max_p;
	float	period;
	float	phase;

	xs = farg();
	ys = farg();
	xe = farg();
	ye = farg();
	while(xs >= 0) {
	    max_p = farg();
	    min_p = farg();
	    starttime = farg();
	    maxtime = farg();
	    period = farg();
	    phase = farg();
	    stk = PutElementStack(parent);
	    while((element = NextElement(1,BUFFER_ELEMENT,stk)) != NULL){
		if(element->x >= xs && element->x <= xe &&
		element->y >= ys && element->y <= ye){
		    curtime = starttime;
		    dt = Clockrate(buffer);
		    while(curtime < maxtime) {
			/*
			* modulate the input prob as a function of time
			*/
			mod_p = min_p+(max_p - min_p)*
			(sin(2*PI*curtime/period+
			phase*2*PI/360.0)+1)/2;
			if (frandom (0, 1) <= mod_p) {
#ifdef FLOATTIME
			    event.time = curtime;
#else
			    event.time = curtime/dt;
#endif
			    event.magnitude = 1.0;
			    InsertEvent(buffer,&event,NULL, EXPAND);
			}
			curtime += dt;
		    }
		}
	    }
	    FreeElementStack(stk);
	    xs = farg();
	    ys = farg();
	    xe = farg();
	    ye = farg();
	}
    } else
    if (arg_is("DEFINE ALL")) {
	xs = farg();
	ys = farg();
	xe = farg();
	ye = farg();
	while(xs >= 0) {
	    while((stim_time = farg()) >= 0){
		stk = PutElementStack(parent);
		while((element = NextElement(1,BUFFER_ELEMENT,stk)) != NULL){
		    if(element->x >= xs && element->x <= xe &&
		    element->y >= ys && element->y <= ye){
#ifdef FLOATTIME
			event.time = stim_time;
#else
			event.time = stim_time/global_clock[buffer->clock];
#endif
			event.magnitude = 1.0;
			InsertEvent(buffer,&event,NULL, EXPAND);
		    }
		}
		FreeElementStack(stk);
	    }
	    xs = farg();
	    ys = farg();
	    xe = farg();
	    ye = farg();
	}
    } else
    if (arg_is("DEFINE STRENGTH"))  {
	xs = farg();
	ys = farg();
	xe = farg();
	ye = farg();
	while(xs >= 0) {
	    while((stim_time = farg())>= 0){
		stim_magnitude = farg();
		stk = PutElementStack(parent);
		while((element = NextElement(1,BUFFER_ELEMENT,stk)) != NULL){
		    if(element->x >= xs && element->x <= xe &&
		    element->y >= ys && element->y <= ye){
#ifdef FLOATTIME
			event.time = stim_time;
#else
			event.time = stim_time/global_clock[buffer->clock];
#endif
			event.magnitude = stim_magnitude;
			InsertEvent(buffer,&event,NULL, EXPAND);
		    }
		}
		FreeElementStack(stk);
	    }
	    xs = farg();
	    ys = farg();
	    xe = farg();
	    ye = farg();
	}
    } else
    if (arg_is("DEFINE PATTERN") ) {
	struct xy_coord {
	    float x;
	    float y;
	    float amp;
	} *pattern;
	int ncoords;
	int i;

	ncoords = iarg();
	/*
	** instead of a bounding region give a coordinate list
	*/
	pattern = (struct xy_coord *)
	malloc(ncoords*sizeof(struct xy_coord));
	for(i=0;i<ncoords;i++){
	    pattern[i].x = farg();
	    pattern[i].y = farg();
	    pattern[i].amp = farg();
	}
	while ((stim_time = farg()) >= 0) {
	    stk = PutElementStack(parent);
	    while((element = NextElement(1,BUFFER_ELEMENT,stk)) != NULL){
		for(i=0;i<ncoords;i++){
		    if(element->x == pattern[i].x && 
		    element->y == pattern[i].y){
#ifdef FLOATTIME
			event.time = stim_time;
#else
			event.time = stim_time/global_clock[buffer->clock];
#endif
			event.magnitude = pattern[i].amp;
			InsertEvent(buffer,&event,NULL, EXPAND);
			break;
		    }
		}
	    }
	    FreeElementStack(stk);
	}
	free(pattern);
    }
    else {
	Error();
	printf ("Error in input specification\n");
    }
}
