//genesis

// ===========================================
//      BASIC SIMULATOR UTILITY FUNCTIONS
// ===========================================

// ===========================================
// links together two asymetric compartments
// ===========================================
function link_compartment(channel,compartment)
    sendmsg   {channel}   {compartment}  RAXIAL 	Ra previous_state
    sendmsg   {compartment}   {channel}  AXIAL 	previous_state
end

// ===========================================
// links a channel which computes channel current
// (e.g. ChannelC2) with a compartment
// ===========================================
function link_channel2(channel,compartment)
    sendmsg   {channel}   {compartment} CHANNEL	Gk Ek 
    sendmsg   {compartment}   {channel} VOLTAGE 	Vm 
end

// ===========================================
// links a channel which does not compute channel current
// (e.g. ChannelC) with a compartment
// ===========================================
function link_channel(channel,compartment)
    sendmsg   {channel}   {compartment} CHANNEL	Gk Ek 
end

// ===========================================
// sets up data file output of either binary or ascii type
// ===========================================
function disk_output(path,type)
    str path,type
    if(type == "binary")
	create 		disk_out		{path}
    end
    if(type == "ascii")
	create 		asc_file		{path}
    end
    set	 {path}		flush			1 \
			leave_open		1
    useclock {path} 1
end

// =================================
//   modify spike output based on integration step to give constant 
//   impulse area
// =================================
function adjustspike
    set /##[TYPE=spike] output_amp {1.0/getclock(0)}
end

