#include "per_ext.h"
/* 
** 3/89 Matt Wilson 
**
*/
int SpatialDistField(argc,argv)
int 	argc;
char 	**argv;
{
float 		max;
float 		sigma;
float 		min = 0;
float 		x,y;
float 		x0,y0,z0;
float		lambda;
ElementList	*list;
Element		*element;
char 		*path;
int		i;
char		val[80];
int		mode = -1;
int		nxtarg;
char		*field;

    if(argc < 10){
	printf("usage: %s path field max min x y z -gaussian sigma -exp lambda \n",
	argv[0]);
	return(0);
    }
    nxtarg = 1;
    path = argv[nxtarg++];
    field = argv[nxtarg++];
    max = Atof(argv[nxtarg++]);
    min = Atof(argv[nxtarg++]);
    x0 = Atof(argv[nxtarg++]);
    y0 = Atof(argv[nxtarg++]);
    z0 = Atof(argv[nxtarg++]);
    /*
    ** check the distribution options
    */
    if(strcmp(argv[nxtarg],"-gaussian") == 0){
	mode = 0;
	sigma = -2*pow(Atof(argv[++nxtarg]),2.0);
    } else 
    if(strcmp(argv[nxtarg],"-exp") == 0){
	mode = 1;
	lambda = -Atof(argv[++nxtarg]);
    } else {
	Error();
	printf("%s : invalid option '%s'\n",argv[0],argv[nxtarg]);
	return(0);
    }
    list = WildcardGetElement(path,1);
    switch(mode){
    case 0:		/* gaussian */
	for(i=0;i<list->nelements;i++){
	    element = list->element[i];
	    /*
	    ** set the field according to the gaussian of the distance between
	    ** the specified coordinate and element 
	    */
	    sprintf(val,"%e", (max - min)*exp((pow(x0 - element->x,2.0) + 
	    pow(y0 - element->y,2.0))/sigma) + min);
	    SetElement(element,field,val);
	}
	break;
    case 1:		/* exponential */
	for(i=0;i<list->nelements;i++){
	    element = list->element[i];
	    sprintf(val,"%e", (max - min)*exp(sqrt(pow(x0-element->x,2.0)+ 
	    pow(y0 - element->y,2.0))/lambda) + min);
	    SetElement(element,field,val);
	}
	break;
    default:
	printf("invalid mode\n");
	FreeElementList(list);
	return(0);
	break;
    }
    FreeElementList(list);
    OK();
    return(1);
}
