#include "per_ext.h"

/* 9/88 Matt Wilson */
int ExpWeight(argc,argv)
int argc;
char **argv;
{
float 		maxval;
float 		minval;
float 		x,y;
Projection 	*projection;
ElementList	*list;
char 		*path;
int		i;
register Connection *connection;
register float scale;
register float rate;

    if(argc < 4){
	printf("usage: %s path rate maxval minval\n",argv[0]);
	return(0);
    }
    path = argv[1];
    rate = Atof(argv[2]);
    maxval = Atof(argv[3]);
    minval = Atof(argv[4]);
    scale = maxval-minval;
    list = WildcardGetElement(path,1);
    for(i=0;i<list->nelements;i++){
	projection = (Projection *)list->element[i];
	x = projection->x;
	y = projection->y;
	/*
	** set the weight according to the radial distance between
	** the source and dst and the velocity
	*/
	for(connection=projection->connection;connection;
	connection=connection->next){
	connection->weight =
		scale*exp(rate*sqrt(
		sqr(x - connection->target->x) +
		sqr(y - connection->target->y)
		)) + minval;
	}
	printf(".");
	fflush(stdout);
    }
    printf("\n");
    FreeElementList(list);
    OK();
    return(1);
}

/* 9/88 Matt Wilson */
int AbsExpWeight(argc,argv)
int argc;
char **argv;
{
float rate;
float maxval;
float minval;
float scale;
float x,y;
Connection *connection;
Projection *projection;
ElementList	*list;
char *path;
int	i;

    if(argc < 4){
	printf("usage: %s path rate maxval minval\n",argv[0]);
	return(0);
    }
    path = argv[1];
    rate = Atof(argv[2]);
    maxval = Atof(argv[3]);
    minval = Atof(argv[4]);
    scale = maxval-minval;
    list = WildcardGetElement(path,1);
    for(i=0;i<list->nelements;i++){
	/*
	** set the weight according to the radial distance between
	** the source and dst and the velocity
	*/
	for(connection= ((Projection *)(list->element[i]))->connection;
	connection;
	connection=connection->next){
	connection->weight =
	    scale*exp(rate*sqrt(
		sqr(connection->target->x) +
		sqr(connection->target->y)
		)) + minval;
	}
	printf(".");
	fflush(stdout);
    }
    printf("\n");
    FreeElementList(list);
    OK();
    return(1);
}
