#include "per_ext.h"

/*
** this routine should not be interrupted as it temporarily modifies
** the xy coords of some elements and must finish in order to 
** restore their value
*/
do_NormalizeSynapses(argc,argv)
int 	argc;
char 	**argv;
{
char 		*src;
char		*dst;
ElementList	*srclist;
ElementList	*dstlist;
Projection	*src_element;
Element		*dst_element;
int		i,j;
Connection	*conn;
float		*savex;
float		*savey;
int		nxtarg;
int		mode;
float		lower,upper;
float		mean,sd;
float		scale;
float		var;

    if(argc < 5){
	printf("usage: %s srcpath targetpath [-scale #][-uniform lo hi][-gaussian mean sd][-exp lo hi]\n",argv[0]);
	return;
    }
    src = argv[1];
    dst = argv[2];
    srclist = WildcardGetElement(src,1);
    dstlist = WildcardGetElement(dst,1);
    nxtarg = 3;
    /*
    ** check the distribution options
    */
    if(strcmp(argv[nxtarg],"-scale") == 0){
	mode = 0;
	scale = Atof(argv[++nxtarg]);
    } else
    if(strcmp(argv[nxtarg],"-uniform") == 0){
	mode = 1;
	lower = Atof(argv[++nxtarg]);
	upper = Atof(argv[++nxtarg]);
    } else
    if(strcmp(argv[nxtarg],"-gaussian") == 0){
	mode = 2;
	mean = Atof(argv[++nxtarg]);
	sd = Atof(argv[++nxtarg]);
	var = sd*sd;
    } else 
    if(strcmp(argv[nxtarg],"-exp") == 0){
	mode = 3;
	lower = Atof(argv[++nxtarg]);
	upper = Atof(argv[++nxtarg]);
    } else {
	Error();
	printf("%s : invalid option '%s'\n",argv[0],argv[nxtarg]);
	return;
    }
    savex = (float *)malloc(sizeof(float)*dstlist->nelements);
    savey = (float *)malloc(sizeof(float)*dstlist->nelements);
    ClearMarkers(RootElement());
    for(i=0;i<dstlist->nelements;i++){
	/*
	** use the x field for the synapse count
	*/
	savex[i] = dstlist->element[i]->x;
	/*
	** use the y field for the normalization factor
	*/
	savey[i] = dstlist->element[i]->y;
	/*
	** clear the synapse count
	*/
	dstlist->element[i]->x = 0;
	/*
	** set the marker used to indicate valid targets
	*/
	dstlist->element[i]->flags |= MARKERMASK;
	/*
	** calculate the desired normalization factor
	*/
	switch(mode){
	case 0:			/* constant */
	    break;
	case 1:			/* uniform */
	    scale = frandom(lower,upper);
	    break;
	case 2:			/* gaussian */
	    scale = rangauss(mean,var);
	    break;
	case 3:			/* exponential */
	    scale = -log(frandom(lower,upper));
	    break;
	}
	if(scale < 0) scale = 0;
	dstlist->element[i]->y = scale;
    }
    /*
    ** first pass to calculate total enervation
    */
    for(i=0;i<srclist->nelements;i++){
	src_element = (Projection *)srclist->element[i];
	if(!CheckClass(src_element,PROJECTION_ELEMENT)){
	    Error();
	    printf("'%s' is not a projection\n",Pathname(src_element));
	    FreeElementList(srclist);
	    FreeElementList(dstlist);
	    return;
	}
	/*
	** for each dst element go through all of the connections
	** to it and keep track of the total synaptic weight
	*/
	for(conn=src_element->connection;conn;conn=conn->next){
	    /*
	    ** check the connection target against the destination
	    ** elements
	    */
	    if(conn->target->flags & MARKERMASK){
		conn->target->x += conn->weight;
	    }
	}
    }
    /*
    ** second pass to apply normalization
    */
    for(i=0;i<srclist->nelements;i++){
	src_element = (Projection *)srclist->element[i];
	for(conn=src_element->connection;conn;conn=conn->next){
	    /*
	    ** check the connection target against the destination
	    ** elements
	    */
	    if((conn->target->flags & MARKERMASK) && (conn->target->x > 0)){
		conn->weight = conn->weight*conn->target->y/conn->target->x;
	    }
	}
    }
    /*
    ** restore the x,y fields to their original value
    */
    for(i=0;i<dstlist->nelements;i++){
	dstlist->element[i]->x = savex[i];
	dstlist->element[i]->y = savey[i];
    }
    free(savex);
    free(savey);
    FreeElementList(srclist);
    FreeElementList(dstlist);
}
