#include "olf_ext.h"

#define LINEAR_EXTRAP 0
#define TRUNC_EXTRAP 1
#define SPECIAL_EXTRAP 2

/*
** table[0] is actually the lo extrapolation value. The actual table
** values run from 1 to xdivs. table[xdivs + 1] is the hi extrapolation
** value. 
*/
double TabInterp(ip,x)
	Interpol *ip;
	double x;
{
	register double frac;
	register double lo;
	register int L;
	register double *table;

	table = ip->table;
	lo = (x - ip->xmin)/ip->dx;
	L = (int)lo;
	if (L < 0)
		L = 0;
	else if (L >= ip->xdivs)
		L = ip->xdivs - 1;
	frac = lo - (double)L;
	return(table[L] * (1.0 - frac) + table[L + 1] * frac);
}

Interpol *create_interpol(xdivs,xmin,xmax)
	int xdivs;
	float xmin,xmax;
{
	Interpol *ip;

	ip = (Interpol *) calloc(1,sizeof(Interpol));

	ip->xdivs = xdivs;
	ip->xmin = xmin;
	ip->xmax = xmax;
	ip->table = (double *)calloc(xdivs + 1,sizeof(double));
	ip->allocated = 1;

	ip->dx = (ip->xmax - ip->xmin) / (double)(ip->xdivs);

	return(ip);
}

#ifdef MAYBE

free_interpol(ip)
	Interpol	*ip;
{
	if (ip->allocated)
		free(ip->table);
	free(ip);
}

reset_interpol(ip)
	Interpol	*ip;
{
	switch (ip->extrapolation_mode) {
		case TRUNC_EXTRAP :
			ip->table[0] = ip->table[1];
			ip->table[xdivs + 1] = ip->table[xdivs];
		break;
		case LINEAR_EXTRAP :
		default : /* linear extrapolation */
			break;
	}
}

do_create_interpol(argc,argv)
	int argc;
	char **argv;
{
	tab_gate_struct	*elm;

	if (argc < 6) {
		printf("usage : %s element interp xdivs xmin xmax\n",argv[0]);
		printf("Warning : interp must be an interpolation structure\n");
		printf("in the element.\n");
		return;
	}
	elm = (tab_gate_struct *)(GetElement(argv[1]));
	if (!elm) {
		printf("Element '%s' not found\n",argv[1]);
		return;
	}
	elm
}
#endif
