#include "hh_ext.h"

#define	Field(F) (channel->F)

/* M.Nelson Caltech 8/88 */
hh_channel(channel,action)
register struct hh_channel_type *channel;
Action		*action;
{
double 	v;
int 	int_method = 0;
double 	xrest;
double 	yrest;
MsgIn	*msg;

    if(debug > 1){
	ActionHeader("hh_channel",channel,action);
    }

    SELECT_ACTION(action){
    case INIT:
	channel->activation = 0;
	break;
    case PROCESS:
	MSGLOOP(channel,msg) {
	case 0:		/* compartment */
	    /*
	    ** 0 = membrane potential
	    */
	    v = MSGVALUE(msg,0);
	    break;
	case 1:		/* integration method */
	    int_method = MSGVALUE(msg,0);
	    break;
	}

	/* 
	** calculate the active state variables x and y 
	*/
	if(Field(Xpower) != 0){
	    hh_update(channel,&Field(X),"X",int_method,v,
		Field(X_alpha_FORM),
		Field(X_alpha_A),
		Field(X_alpha_B),
		Field(X_alpha_V0),
		Field(X_beta_FORM),
		Field(X_beta_A),
		Field(X_beta_B),
		Field(X_beta_V0));
	}
	if(Field(Ypower) != 0){
	    hh_update(channel,&Field(Y),"Y",int_method,v,
		Field(Y_alpha_FORM),
		Field(Y_alpha_A),
		Field(Y_alpha_B),
		Field(Y_alpha_V0),
		Field(Y_beta_FORM),
		Field(Y_beta_A),
		Field(Y_beta_B),
		Field(Y_beta_V0));
	}

	/* 
	** calculate the conductance 
	*/
	if(Field(Xpower) != 0 && Field(Ypower) != 0){
	    Field(Gk) = Field(Gbar) * pow(Field(X),Field(Xpower)) * 
	    		pow(Field(Y),Field(Ypower));
	} else 
	if(Field(Ypower) == 0) {
	    Field(Gk) = Field(Gbar) * pow(Field(X),Field(Xpower));
	} else {
	    Field(Gk) = Field(Gbar);
	}

	/* 
	** calculate the transmembrane current 
	*/
	Field(Ik) = (v - Field(Ek)) * Field(Gk);

	break;
    case RESET:
	channel->activation = 0;
	v = 0;
	/* 
	** calculate the conductance at Erest 
	*/
	MSGLOOP(channel,msg) {
	    case 0:		/* Vm */
		v = MSGVALUE(msg,0);
		break;
	}

	/*
	** calculate the active state variables x and y at steady state
	*/
	if(Field(Xpower) != 0){

	    hh_evaluate(&Field(X),v,
		Field(X_alpha_FORM),
		Field(X_alpha_A),
		Field(X_alpha_B),
		Field(X_alpha_V0),
		Field(X_beta_FORM),
		Field(X_beta_A),
		Field(X_beta_B),
		Field(X_beta_V0));
	}

	if(Field(Ypower) != 0){
	    hh_evaluate(&Field(Y),v,
		Field(Y_alpha_FORM),
		Field(Y_alpha_A),
		Field(Y_alpha_B),
		Field(Y_alpha_V0),
		Field(Y_beta_FORM),
		Field(Y_beta_A),
		Field(Y_beta_B),
		Field(Y_beta_V0));
	}
	/*
	** calculate the conductance
	*/
	if(Field(Xpower) != 0 && Field(Ypower) != 0){
	    Field(Gk) = Field(Gbar)*pow(Field(X),Field(Xpower))* 
	    pow(Field(Y),Field(Ypower));
	} else 
	if(Field(Ypower) == 0) {
	    Field(Gk) = Field(Gbar)* pow(Field(X),Field(Xpower));
	} else{
	    Field(Gk) = Field(Gbar);
	}
	break;
    case CHECK:
	if(channel->msg_in == NULL){
	    ErrorMessage("hh_channel","Missing v or int_method msg.",channel);
	}
	break;
    }
}

#undef Field
