#include "dev_ext.h"

ExpThresh(thresh,action)
struct expthresh_type *thresh;
Action	*action;
{
MsgIn	*msg;
Buffer 		*buffer;

    SELECT_ACTION(action){
    case PROCESS:
	MSGLOOP(thresh,msg) {
	case 0:				/* buffer */
	    buffer = (Buffer *)MSGPTR(msg,0);
	    break;
	}

	if(ValidEvent(buffer)){
	    thresh->state =
	    thresh->theta_s + (thresh->theta_0 -thresh->theta_s)*
	    exp((CurrentEventTime(buffer) - SimulationTime())/thresh->tau_theta);
	}
	break;
    case RESET:
	thresh->state = thresh->theta_s;
	break;
    case CHECK:
	buffer = NULL;
	MSGLOOP(thresh,msg) {
	case 0:				/* buffer */
	    buffer = (Buffer *)MSGPTR(msg,0);
	    break;
	}
	if(!buffer){
	    ErrorMessage("ExpThresh","No buffer attached.",thresh);
	} else {
	    if(!CheckClass(buffer,BUFFER_ELEMENT)){
		ErrorMessage("ExpThresh","Invalid buffer sent to thresh.",thresh);
	    }
	}
	break;
    }
}
 
