// genesis

/*
*************************************************************************
**                       BUFFER OBJECT TABLE                           **
*************************************************************************
*/
//==========================================================================
//	name		data            function	class	
//==========================================================================

object	graded		graded_type 	GradedEvent  	buffer 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET CHECK \
			*COPY BufferCopy *CREATE BufferCreate \
	-fields		rectify baseline scale \
	-environment	SIGNAL	signal_type \
	-messages	INPUT 1		1 input

object	linear		linear_type 	LinearEvent  	buffer 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	PROCESS RESET CHECK *COPY BufferCopy *CREATE BufferCreate 

object	periodic	periodic_type 	PeriodicEvent  	buffer 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	PROCESS RESET *COPY BufferCopy *CREATE BufferCreate 

object	playback	playback_type 	PlaybackBuffer 	buffer 	\
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	PROCESS RESET *COPY BufferCopy *CREATE BufferCreate 

object	random		random_type 	RandomEvent 	buffer 		\
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	INIT PROCESS RESET *COPY BufferCopy *CREATE BufferCreate \
	-fields		min_amp max_amp rate reset reset_value \
	-messages	RATE 0		1 rate \
			MINMAX 1	2 min max \
	-description	"Generates a time series of events at a rate" \
			"given by the rate parameter. The probability" \
			"of an event for a single time step is given" \
			"by rate*dt where dt is the clock rate of the" \
			"element. When an event has been generated, the" \
			"amplitude of the event is a random variable" \
			"uniformly distributed between min_amp and max_amp." \
			"The state field has the value of the event amplitude" \
			"if an event has been generated. If an event is not" \
			"generated then the value of the state field" \
			"depends on the reset field. If reset is non-zero" \
			"then the state is takes on the value given in" \
			"reset_value. Otherwise the state will behave like a"\
			"latch containing the amplitude of the previous event."

object	sigmoid		sigmoid_type 	SigmoidEvent 	buffer 	segment \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	PROCESS RESET *COPY BufferCopy *CREATE BufferCreate \
	-fields		thresh amplitude input state gain \
	-messages	INPUT 0		1 input \
			THRESH 1	1 threshold \
			GAIN 2		1 gain \
			AMP 3		1 amplitude \
	-description	"computes the sigmoidal tranformation of the input" \
			"and places the result in 'state'"

object	spike		spike_type 	SpikeEvent 	buffer \
	-author 	"M.Wilson Caltech 6/88" \
	-actions 	PROCESS RESET CHECK \
			*COPY BufferCopy *CREATE BufferCreate \
	-messages	INPUT 0		1 input \
			THRESH 1	1 threshold \
	-description	"Performs threshold spike discrimination." \
			"Generates an impulse each time an input crosses the" \
			"spike threshold at a maximal rate set by abs_refract."

addfunc		get_input		do_get_input
addfunc		clear_buffer		do_clear_buffer

