//genesis

create xform /tree [500,0,700,400]

/*
** Creating the draw for the elmtree 
*/

create xdraw /tree/draw -wx 1000 -wy 1000  -cx 500 -cy 500 -cz 0 

/*
** Creating an elmtree to help us move around the simulation
*/
create xelmtree /tree/draw/tree -path /
echo xelmtree created
when /tree/draw click1 do "change_to_elm /tree/draw"
when /tree/draw click2 do "zoom_tree /tree/draw"
when /tree/draw click3 do "truncate /tree/draw"
xtreetrunc /tree/draw /xproto
xtreetrunc /tree/draw /tree
xtreetrunc /tree/draw /xout
xtreetrunc /tree/draw /conn
xtreetrunc /tree/draw /library
xtreetrunc /tree/draw /control
xtreetrunc /tree/draw /xgraphs

function change_to_elm(widget)
str widget
int	show_state
	echo changing to elm {get({widget},value)}
	ce {get({widget},value)}
	show_state = {get(/tree/show_elm,state)}
	if (show_state)
		show *
	end
end

function zoom_tree(widget)
str widget
	if (strcmp({get({widget}/tree,path)},"/") != 0)
		echo zooming tree out to /
		set {widget}/tree path /
	else
		echo zooming in to {get({widget},value)}
		set {widget}/tree path {get({widget},value)}
	end
end

function truncate(widget)
str widget
	xtreetrunc {widget} {get({widget},value)}
end

create xtoggle /tree/show_elm
