//genesis
create xform /xgraphs [0,450,700,450]
ce /xgraphs

/* Viewgraph plots the output from the files set up in lgn_output.g */
create xgraph /xgraphs/viewgraph [2%,50,45%,350] \
	-range [0,-0.09,0.1,0.05] 	
//===================================================================

/* Simgraph plots out the membrane potential of selected cells */
create xgraph /xgraphs/simgraph [52%,50,45%,350] \
	-range [0,-0.5,0.1,0.1] -title "membrane potential Vm (V)"  

/* For some reason one cant set the offset from the creation line */
	set /xgraphs/simgraph yoffset -0.1

	sendmsg /lgn/vert/soma[14] /xgraphs/simgraph PLOT Vm *Vm14 *black
	sendmsg /lgn/vert/soma[13] /xgraphs/simgraph PLOT Vm *Vm13 *blue
	sendmsg /lgn/vert/soma[12] /xgraphs/simgraph PLOT Vm *Vm12 *orange
	sendmsg /lgn/vert/soma[11] /xgraphs/simgraph PLOT Vm *Vm11 *red
	sendmsg /lgn/vert/soma[10] /xgraphs/simgraph PLOT Vm *Vm10 *green
//===================================================================

create xdialog index -script plotindex -value 12 \
	[2%,5,15%,30] -widgets [NULL,viewgraph.bottom,NULL,NULL]
create xdialog filename -script plotindex -value vert_disk \
	[10,5,30%,30] -widgets [index.right,viewgraph.bottom,NULL,NULL]

create xdialog /xgraphs/xmin -script "setxrange" -value 0 \
	[10,5,23%,30] -widgets [filename.right,viewgraph.bottom,NULL,NULL]
create xdialog /xgraphs/xmax -script "setxrange" -value 0.1 \
	[10,5,23%,30] -widgets [xmin.right,viewgraph.bottom,NULL,NULL]
//===================================================================


function setxrange
	set /xgraphs/viewgraph xmin {get(/xgraphs/xmin,value)}
	set /xgraphs/viewgraph xmax {get(/xgraphs/xmax,value)}
	set /xgraphs/simgraph xmin {get(/xgraphs/xmin,value)}
	set /xgraphs/simgraph xmax {get(/xgraphs/xmax,value)}
end

function plotindex
	str index,filename
	index = get(/xgraphs/index,value)
	filename = get(/xgraphs/filename,value)
	xsimplot /xgraphs/viewgraph -c {index} {filename}
end

function plotviewgraph(widget)
str	widget
str elm
int	index
	elm = {get({widget},value)}
	index = {get({elm},index)}
	set /xgraphs/index value {get({elm},index)}
	if (strncmp({elm},/lgn/vert,9) == 0)
		set /xgraphs/filename value vert_disk
	else 
		set /xgraphs/filename value horiz_disk
	end
	plotindex
end
//===================================================================
setxrange // In order to make the graphs appear in the correct size
xshow /xgraphs
