//genesis

// Assigning the retinal parameters.
float	REC_SEPX = 40e-6 // separation of cells in x direction in m
float	REC_SEPY = 40e-6 // m
float	REC_NX = 10		// number of cells in x direction
float	REC_NY = 10		// number of cells in y direction

// creating the retina
create neutral /retina

// creating a receptor cell in the library
create neutral /library/rec
// with a random input module
ce /library/rec
create random	/library/rec/input  
// setting the fields for the random input module
set input rate 1		// spikes /sec
set input min_amp	1
set input max_amp	1

// creating an axon for the receptor cell in the library
create axon		/library/rec/axon

// Connecting the random input module to the axon in the library
// receptor cell.
sendmsg /library/rec/input	/library/rec/axon BUFFER name

// creating a plane (map) of receptor cells on the retina
// based on the /library/rec prototype 
// Usage :
// createmap prototype destination 
// number_in_x_direction number_in_y_direction
// separation_in_x_direction separtion_in_y_direction
// offset_in_x_direction offset_in_y_direction

createmap /library/rec /retina/recplane \
	{REC_NX} {REC_NY} {REC_SEPX} {REC_SEPY} \
	{-REC_NX * REC_SEPX / 2} {-REC_NY * REC_SEPY / 2}
