// genesis
// helpforms.g
// Forms for Neuron Tutorial help display, using  the ximage widget for
// display of GIF files and the xtext widget for scrolling of text files
//
// Currently, must use /usr/local/genesis/genesis on galadrial and its .simrc
// rather than the distribution version in /usr/genesis

// The following two functions should eventually go into xtools.g

//=====================================================================
// makegif(formpath,x,y,image_width,image_height,gif_file,title)
// Creates a form to display a GIF file with label and "DONE" button
// The form will have width=image_width+10 and height=image_height+25
//=====================================================================
function makegif(formpath,x,y,image_width,image_height,gif_file,title)
   str formpath,gif_file,title
   int x,y,image_width,image_height
   create xform {formpath} [{x},{y},{image_width+10},{image_height+25}] \
       -nolabel
   create xlabel {formpath}"/titlebar" [5,0,{image_width},20] \
       -title {title}
   create xbutton {formpath}"/DONE" [15,3,80,15] -script "xhide "{formpath}
   create ximage {formpath}"/image" [5,20,{image_width},{image_height}]
   set ^ wx {image_width} wy {image_height} filename {gif_file}
end

//=====================================================================
// textwindow(formpath,x,y,textfile)
// creates a form 490 pixels wide and 336 pixels high at x,y to display
// the specified text file with scrolling and paging
//=====================================================================
function textwindow(formpath,x,y,textfile)
   str formpath,textfile
   int x,y
   create xform {formpath} [{x},{y},490,336] -nolabel
   push {formpath}
   create xlabel textbar [3,0,484,20] -title \
       "      Right Button: Forward - Left Button: Back - Double Click: Page"
   create xbutton DONE [8,3,50,20] -script "xhide "{formpath}
   create xtext text [3,20,484,316] -file {textfile}
   pop
end

//-------------------------------------------------------------------------

function loadhelp
// create the forms with help screens
   str screens="/output/popups/helpscreens"
   create neutral {screens}
   textwindow({screens}/help,10,370,help.hlp)
   textwindow({screens}/running,10,370,running.hlp)
   makegif({screens}/inputs,0,0,640,350,neuron1.gif,"Neuron Inputs")
   textwindow({screens}/params,10,370,params.hlp)
   textwindow({screens}/totry,10,370,totry.hlp)

// create popup help menu
    str form ="/output/popups/helpmenu"
    create xform {form} [770,10,240,250] \
           -title "Help Menu"
    push {form}
    create xbutton helphelp [0,40,240,30] -title "Using Help" \
           -script "xshow_on_top "{screens}"/help"
    create xbutton running [0,75,240,30] -title "Running the Simulation" \
           -script "xshow_on_top "{screens}"/running"
    create xbutton inputs [0,110,240,30]  -title "Neuron Inputs" \
           -script "xshow_on_top "{screens}"/inputs"
    create xbutton parameters [0,145,240,30] -title "Model Parameters"  \
           -script "xshow_on_top "{screens}"/params"
    create xbutton totry [0,180,240,30] -title "Things to Try"  \
           -script "xshow_on_top "{screens}"/totry"
    create xbutton quit [0,215,240,30] -title "Quit Help" \
           -script "xhide "{form}
    pop
end
