//genesis
// forms.g for Neuron tutorial

include myxtools.g  // modified /usr/genesis/startup/xtools.g
include helpforms.g

// =================================================
//   Functions used for setting dendrite inputs
// =================================================
function togglesource(channel, widget)
// toggles channel input between source A/B
    str channel, widget
    str	Aaxonconn	= "/input/Apulse/axon:@/cell/"
    str	Baxonconn	= "/input/Bpulse/axon:@/cell/"
    if(get({widget},state)==1)  // source B
      set {Baxonconn + channel} weight {get({Aaxonconn + channel},weight)}
      set {Aaxonconn + channel} weight 0
    else                        // source A
      set {Aaxonconn + channel} weight {get({Baxonconn + channel},weight)}
      set {Baxonconn + channel} weight 0
    end
end

function setweight(channel,widget)
    str channel, widget
    str	Aaxonconn	= "/input/Apulse/axon:@/cell/"
    str	Baxonconn	= "/input/Bpulse/axon:@/cell/"
    if(get({widget}/source,state)==1)  // source B
      fieldbutton {Baxonconn + channel} weight {widget}
    else
      fieldbutton {Aaxonconn + channel} weight {widget}
    end
end

// =================================================
//   Functions used for popup parameter menus
// =================================================
function make_comp_menu(compartment)
    str compartment
    str formpath	= "/output/popups/" + compartment
    str comppath	= "/cell/" + compartment
    create xform {formpath} [720,50,240,215] -title {compartment}" parameters"
    disable {formpath}
    push {formpath}
    create xbutton  DONE  [0,40,58,30] \
                    -script "set_comp_params "{compartment}
    create xbutton  Ex_button  [60,40,58,30] -title "Exc. Ch." \
           -script "xshow "{formpath}"/Ex_channel"
    create xbutton  Inh_button  [120,40,58,30] -title "Inh. Ch." \
           -script "xshow "{formpath}"/Inh_channel"
    create xbutton  CANCEL  [180,40,58,30] \
                    -script "xhide "{formpath}
    create xdialog  Em    [0,75,240,30]  \
                    -title "Eleak (mv)"    -value {get({comppath},Em)}
    create xdialog  Rm    [0,110,240,30] \
                    -title "Rmem (KOhm)"   -value {get({comppath},Rm)}
    create xdialog  Cm    [0,145,240,30] \
                    -title "Cmem (uF)"     -value {get({comppath},Cm)}
    create xdialog  Ra    [0,180,240,30] \
                    -title "Raxial (KOhm)" -value {get({comppath},Ra)}
    pop
end

function make_channel_menu(compartment,channel)
    str compartment,channel
    str comp_and_chan = compartment + "/" + channel  // e. g. "soma/Ex_channel"
    str formpath	= "/output/popups/" + comp_and_chan
    str chanpath	= "/cell/" + comp_and_chan
    create xform {formpath} [720,50,240,215] \
           -title {comp_and_chan}" parameters"
    disable {formpath}
    push {formpath}
    create xbutton  DONE  [0,40,118,30] \
                    -script "set_ch_params "{compartment}" "{channel}
    create xbutton  CANCEL  [120,40,118,30] \
                    -script "xhide "{formpath}
    create xdialog  Ek    [0,75,240,30]  \
                    -title "Eequil (mV)"    -value {get({chanpath},Ek)}
    if ({compartment} == "soma")
       create xdialog Gbar    [0,110,240,30] \
                    -title "Gbar (mS)"   -value {get({chanpath},Gbar)}
    else
       create xdialog gmax    [0,110,240,30] \
                    -title "gmax (mS)"   -value {get({chanpath},gmax)}

       create xdialog tau1    [0,145,240,30] \
                    -title "Tau 1 (msec)"     -value {get({chanpath},tau1)}
       create xdialog tau2    [0,180,240,30] \
                    -title "Tau 2 (msec)"     -value {get({chanpath},tau2)}
    end
    pop
end

function set_ch_params(compartment,channel)
    str compartment,channel
    str comp_and_chan = compartment + "/" + channel  // e. g. "soma/Ex_channel"
    str formpath	= "/output/popups/" + comp_and_chan
    str chanpath	= "/cell/" + comp_and_chan
    fieldbutton {chanpath} Ek {formpath}/Ek
    if ({compartment} == "soma")
       fieldbutton {chanpath} Gbar {formpath}/Gbar
    else
       fieldbutton {chanpath} gmax {formpath}/gmax
       fieldbutton {chanpath} tau1 {formpath}/tau1
       fieldbutton {chanpath} tau2 {formpath}/tau2
    end
    xhide {formpath}
end

function set_comp_params(compartment)
    str compartment
    str formpath	= "/output/popups/" + compartment
    str comppath	= "/cell/" + compartment
    fieldbutton {comppath} Em {formpath}/Em
    fieldbutton {comppath} Rm {formpath}/Rm
    fieldbutton {comppath} Cm {formpath}/Cm
    fieldbutton {comppath} Ra {formpath}/Ra
    xhide {formpath}
end

function set_input_timing             // uses setspikes from inputs.g
   str dialog ="/output/popups/inputs"
   setinjection({get({dialog}/Idelay,value)}, \
              {get({dialog}/Iwidth,value)})
   setspikes(Apulse,{get({dialog}/Adelay,value)}, \
              {get({dialog}/Awidth,value)},{get({dialog}/Ainterval,value)})
   setspikes(Bpulse,{get({dialog}/Bdelay,value)}, \
              {get({dialog}/Bwidth,value)},{get({dialog}/Binterval,value)})
   adjustspike  // set spike amplitudes to 1.0/dt
   xhide {dialog}
end

// functions used in MAIN CONTROL PANEL
//
// change_stepsize  -  sets clock 0 and properly normalizes spike plots
//
function change_stepsize
    float dt  = {get(/output/control/stepsize,value)}
    setclock 0 {dt}
    echo dt = {dt}
    adjustspike
    push /output/dend1graphs
    deletemsg input_grf IN 2  // use new scale for plot with unit height
    deletemsg input_grf IN 1  // MSG 0 for injection pulse is left alone
    sendmsg  /input/Apulse/spiketrain  input_grf PLOTSCALE \
                              state *SourceA *black {dt} 2
    sendmsg  /input/Bpulse/spiketrain  input_grf PLOTSCALE \
                              state *SourceB *black {dt} 4
    pop
end

// =======================================================
//  The two main functions, loadgraphs and loadcontrol
//  set up the forms used for graphs and control buttons
// =======================================================
function loadgraphs
    xon				// activate XODUS
// While forms are being loaded, put up some credits
     echo " "
     echo "*************************************************"
     echo "*                                               *"
     echo "*                   NEURON                      *"
     echo "*                                               *"
     echo "*        A simulation of a simple neuron        *"
     echo "*                                               *"
     echo "*                 D. Beeman                     *"
     echo "*                                               *"
     echo "*            Harvey Mudd College                *"
     echo "*                                               *"
     echo "*************************************************"
     echo " "
    xcolorscale hot		// give it color

    // =================================================
    //                     GRAPHICS
    // =================================================
/* NOTE - Another undocumented feature: The neutral element /output is
   prexisting, so I can create a child "/output/dend1graphs" without explictly
   creating the parent. */
   
    create xform /output/dend1graphs [10,10,500,675] -nolabel
    push /output/dend1graphs
    str graphicspath = "/output/dend1graphs" //parameter to makegraphscale
    // =================================================
    //      make input_grf for Input/Output Voltages
    // =================================================
    create xgraph 	input_grf 	[5,0,490,160] \
			-title "Inputs to Cell" 
    set input_grf xmin 0 xmax 80 ymin 0 ymax 6 XUnits "t (msec)"
    useclock input_grf 0                         // spikes need fast clock
    makegraphscale {graphicspath}/input_grf

    // =================================================
    //       make dend1Gk_grf for synaptic conductances
    // =================================================
    create xgraph 	dend1Gk_grf 	[5,162,490,255] \
			-title "Dendrite #1 Gex and Ginh (mS)" 
    set dend1Gk_grf yoffset 0 YUnits "G (mS)"
    set dend1Gk_grf xmin 0 xmax 80 ymin -1e-6 ymax 5e-6 XUnits "t (msec)"
    useclock dend1Gk_grf 1
    makegraphscale {graphicspath}/dend1Gk_grf 
    // =================================================
    //      make dend1Vm_grf for intracellular potentials
    // =================================================
    create xgraph 	dend1Vm_grf 	[5,419,490,255] \
			-title "Dendrite #1 membrane potential Vm (mV)" 
    set dend1Vm_grf xmin 0 xmax 80 ymin -100 ymax 50 XUnits "t (msec)" \
                    YUnits "Vm (mV)"
    useclock dend1Vm_grf 0                     // also use fast clock for Vm
    makegraphscale {graphicspath}/dend1Vm_grf
    pop

    // =================================================
    //  make graphs for soma Vm and conductances
    // =================================================
    create xform	/output/somagraphs [510,10,500,675] -nolabel
    push /output/somagraphs
    create xgraph       activation_grf       [5,0,490,160] \
                        -title "Hodgkin-Huxley Activation Parameters"
    set activation_grf yoffset 2
    set activation_grf xmin 0 xmax 80 ymin 0 ymax 6 XUnits "t (msec)"
    useclock activation_grf 1
    makegraphscale /output/somagraphs/activation_grf

    create xgraph 	somaGk_grf 	[5,162,490,255] \
			-title "Soma GNa and GK (mS)" 
    set somaGk_grf yoffset 0 YUnits "G (mS)"
    set somaGk_grf xmin 0 xmax 80 ymin 0 ymax 1e-3 XUnits "t (msec)"
    useclock somaGk_grf 1
    makegraphscale /output/somagraphs/somaGk_grf

    create xgraph 	somaVm_grf 	[5,419,490,255] \
			-title "Soma membrane potential Vm (mV)" 
    set somaVm_grf xmin 0 xmax 80 ymin -100 ymax 50 XUnits "t (msec)" \
                   YUnits "Vm (mV)"
    useclock somaVm_grf 0
    makegraphscale /output/somagraphs/somaVm_grf
    pop

    // =================================================
    //       make dend2Gk_grf for synaptic conductances
    // =================================================
    create xform /output/dend2graphs [510,10,500,675] -nolabel
    push /output/dend2graphs
    str graphicspath = "/output/dend2graphs" //parameter to makegraphscale
    create xgraph 	dend2Gk_grf 	[5,162,490,255] \
			-title "Dendrite #2 Gex and Ginh (mS)" 
    set dend2Gk_grf yoffset 0 YUnits "G (mS)"
    set dend2Gk_grf xmin 0 xmax 80 ymin -1e-6 ymax 5e-6 XUnits "t (msec)"
    useclock dend2Gk_grf 1
    makegraphscale {graphicspath}/dend2Gk_grf 
    // =================================================
    //      make dend2Vm_grf for intracellular potentials
    // =================================================
    create xgraph 	dend2Vm_grf 	[5,419,490,255] \
			-title "Dendrite #2 membrane potential Vm (mV)" 
    set dend2Vm_grf xmin 0 xmax 80 ymin -100 ymax 50 XUnits "t (msec)" \
                    YUnits "Vm (mV)"
    useclock dend2Vm_grf 0
    makegraphscale {graphicspath}/dend2Vm_grf
    pop

    xshow /output/dend1graphs
    xshow /output/somagraphs
end     // loadgraphs

    // =================================================
    //                MAIN CONTROL PANEL
    // =================================================
function loadcontrol
    create xform 	/output/control [10,690,1000,140] -nolabel
    push /output/control
    create xbutton 	HELP	    [10,5,78,30]   \
                        -script "xshow /output/popups/helpmenu"
    create xbutton 	reset 	    [91,5,78,30]   -title RESET -script reset
    create xbutton 	stop 	    [172,5,78,30]  -title STOP  -script stop
    create xbutton 	quit 	    [253,5,78,30]  -title QUIT \
				    -script "quitbutton <widget>"
    makeconfirm(quit,"Quit Neuron?","quit","cancelquit <widget>",91,730)
    create xbutton	addcable    [10,40,78,30] -title "Add Cable" \
    			-script "xshow /output/control/cableform"
    create xtoggle 	overlay     [91,40,78,30]  -title "" \
				    -script "overlaytoggle <widget>"
    set overlay label0 "Overlay OFF" label1 "Overlay ON" state 0
    overlaytoggle /output/control/overlay
// be sure that it is in state 0 after Reset Defaults
    create xbutton	inputs	    [172,40,78,30] -title "Inputs" \
    			-script "xshow /output/popups/inputs"
    create xbutton	resetdefaults [253,40,78,30] -title "Reset Deflts" \
			-script "ResetDefaults"
    create xdialog 	step 	    [10,75,150,30] -title "STEP (msec)" \
			-script "stepbutton <widget>"  -value 80
    create xtoggle	plotsoma    [165,75,85,30]  -title "" \
           -script "formtoggle <widget> /output/somagraphs /output/dend2graphs"
    set plotsoma label0 "Plot Soma" label1 "Plot Dend2" state 0
    create xdialog 	stepsize    [10,110,240,30] -title "dt (msec)" \
			-script "change_stepsize"   -value {getclock(0)}
    create xlabel	cellparms  [835, 5,160,30] -title "Cell Parameters"
    create xbutton	somaparms  [835,40,160,30] -title "Soma" \
				   -script "xshow /output/popups/soma"
    create xbutton	dend1parms  [835,75,160,30] -title "Dendrite 1" \
				   -script "xshow /output/popups/dend1"
    create xbutton	dend2parms  [835,110,160,30] -title "Dendrite 2" \
				   -script "xshow /output/popups/dend2"

// dialog box to enter number of passive cable sections between dend2 and dend1
    create xform	cableform   [210,550,125,110] -nolabel
    create xlabel	cableform/sections [5,5,115,30] -title "Cable Sections"
    create xdialog	cableform/nsections [5,40,115,30] -title "N:" \
			-value 0
    create xbutton	cableform/DONE [5,75,115,30] -label "DONE" \
    			-script "add_cable"   // defined in make_cable.g
    pop
    
// dialog boxes to set dendrite connections
    str	inparms		= "/output/control/inparms"
    create xlabel {inparms} [545,5,280,25] -title "Dendrite Inputs"
    push {inparms}

// I need a more general way to do this when there are several dendrites
// The dialog boxes are initialized to 0 - check inputs.g for consistency

    create xdialog dend1_exwt [545,32,200,25]  -title "Dend #1 Exc. Wt." \
	-script "setweight dend1/Ex_channel <widget>" \
	-value 0
    create xtoggle dend1_exwt/source [748,32,77,25]  -title ""  \
    	-script "togglesource dend1/Ex_channel <widget>"
    set  dend1_exwt/source label0 "Source A" label1 "Source B" state 0

    create xdialog dend1_inhwt [545,59,200,25] -title "Dend #1 Inh. Wt." \
	-script "setweight dend1/Inh_channel <widget>" \
	-value 0
    create xtoggle dend1_inhwt/source [748,59,77,25]  -title ""  \
    	-script "togglesource dend1/Inh_channel <widget>"
    // Initialize inhibitory connections to source B
    set  dend1_inhwt/source label0 "Source A" label1 "Source B" state 1

    create xdialog dend2_exwt [545,86,200,25]  -title "Dend #2 Exc. Wt." \
	-script "setweight dend2/Ex_channel <widget>" \
	-value 0
    create xtoggle dend2_exwt/source [748,86,77,25]  -title ""  \
    	-script "togglesource dend2/Ex_channel <widget>"
    set  dend2_exwt/source label0 "Source A" label1 "Source B" state 0

    create xdialog dend2_inhwt [545,113,200,25] -title "Dend #2 Inh. Wt." \
	-script "setweight dend2/Inh_channel <widget>" \
	-value 0
    create xtoggle dend2_inhwt/source [748,113,77,25]  -title ""  \
    	-script "togglesource dend2/Inh_channel <widget>"
    // Initialize inhibitory connections to source B
    set  dend2_inhwt/source label0 "Source A" label1 "Source B" state 1

    pop

// Dialog boxes for injection currents
    
    create xlabel /output/control/injection [335,5,200,30] \
           -title "Injection Current (uA)"
    push /output/control/injection
    create xdialog soma_inj [335,40,200,30] -title "Soma Inj" \
	   -script "fieldbutton /input/injectpulse/somacurr gain <widget>" \
	   -value {get(/input/injectpulse/somacurr, gain)}

    create xdialog dend1_inj [335,75,200,30] -title "Dend 1 Inj" \
	   -script "fieldbutton /input/injectpulse/dend1curr gain <widget>" \
	   -value {get(/input/injectpulse/dend1curr, gain)}

    create xdialog dend2_inj [335,110,200,30] -title "Dend 2 Inj" \
	   -script "fieldbutton /input/injectpulse/dend2curr gain <widget>" \
	   -value {get(/input/injectpulse/dend2curr, gain)}

    pop

    // =================================================
    //                   Popup Menus
    // =================================================
// Popup Menus for Cell Parameters
    create neutral /output/popups
    make_comp_menu(soma)
    make_channel_menu(soma,Ex_channel)
    make_channel_menu(soma,Inh_channel)
    make_comp_menu(dend1)
    make_channel_menu(dend1,Ex_channel)
    make_channel_menu(dend1,Inh_channel)
    make_comp_menu(dend2)
    make_channel_menu(dend2,Ex_channel)
    make_channel_menu(dend2,Inh_channel)
// Popup Menu for Timing of Inputs
// More dependencies on inputs.g - dialog box initial values are hard-coded
    create xform /output/popups/inputs [745,10,265,370] \
		 -title "Input Timing (msec)"
    push /output/popups/inputs
    create xbutton DONE [5,40,125,30] -script "set_input_timing"
    create xbutton CANCEL [135,40,125,30] -script "xhide /output/popups/inputs"

    create xlabel  sourceA [5,75,100,100]  -title "Source A"
    create xdialog Adelay  [110,75,150,30]  -title "Delay" -value 10
    create xdialog Awidth  [110,110,150,30] -title "Width" -value 50
    create xdialog Ainterval  [110,145,150,30] -title "Interval" -value 10

    create xlabel  sourceB [5,185,100,100] -title "Source B"
    create xdialog Bdelay  [110,185,150,30]  -title "Delay" -value 30
    create xdialog Bwidth  [110,220,150,30] -title "Width" -value 20
    create xdialog Binterval  [110,255,150,30] -title "Interval" -value 10

    create xlabel  injection [5,295,100,65] -title "Injection"
    create xdialog Idelay  [110,295,150,30] -title "Delay" -value 20
    create xdialog Iwidth  [110,330,150,30] -title "Width" -value 40
    pop
// popup help menu
    xshow /output/control
    loadhelp		// set up the help screens and menu (helpforms.g)
//    showintro		// show a big GIF image (in helpforms.g)
end			// loadcontrol

//kludge for fixing screwed-up graph labels
function fixdend1
  xhide /output/dend1graphs
  xshow /output/dend1graphs
end
