//genesis
/* 
	functions defined in this script
=============================================================================
	FUNCTION NAME		ARGUMENTS
=============================================================================
	makecompartment		(path,l,d,Eleak)
=============================================================================
*/

//=================================================
//                    COMPARTMENT
//=================================================
function makecompartment(path,l,d,Erest)
    str path
    float l,d
    float Erest
    float area = l*PI*d
    float xarea = PI*d*d/4
    float rm = 10.0				// Kohm-cm^2
    float cm = 1.0				// uF/cm^2
    float ra = 0.05				// Kohm-cm

    create 	compartment	{path}
    set		{path} \
		Em	{ Erest } \  		// mV
		Rm	{ rm/area } \  		// Kohm
		Cm	{ cm*area } \  		// uF
		Ra	{ ra*l/xarea } 		// Kohm
end
