//genesis

function do_xselect_funcs
	int channo

	create xform /compt_display [480,30,520,400]
	disable /compt_display
	create xdraw /compt_display/draw [0,2,100%,365] \
		-transform z2d -wx 18 -wy 18 -cx 9 -cy 9 -refresh_flag FALSE
	ce ^
	copy /xproto/draw/hhna.icon hh.icon
		set hh.icon pixcolor Orange linewidth 2
	copy /xproto/draw/excsyn.icon syn.icon
		set syn.icon pixcolor Green linewidth 2
	copy /xproto/draw/soma.icon rec.icon
	copy /xproto/draw/fillbox.icon vdep.icon
	copy /xproto/draw/comptshape compt
	copy /xproto/draw/hilight hilight
	create xshape dummy.icon
	create xshape comptpath -tx 10 -ty 10
	for (channo = 0 ; channo < 10 ; channo = channo + 1)
		create xshape chan{channo} \
			-tx { 6 + 2.2 * (channo%5)} -ty {3.5 + 0.82 * channo}
	end
	create xtoggle /compt_display/mouse_mode \
		-script "set_compt_disp_mode "<widget>
		set /compt_display/mouse_mode	label0	"Cut-n-Paste" \
										label1	"Select"
	setup_mouse(/compt_display/draw,0,0, \
		select,"do_channelselect /compt_display/draw", \
		dummy,do_dummy,dummy,do_dummy)
	setup_mouse(/compt_display/draw,0,0,paste,do_chanpaste,cut,do_chancut,copy,do_chancopy)


	create xform /compt_select [0,430,480,450]
	disable /compt_select
	create xdraw /compt_select/draw [0,2,100%,415] \
		-transform ortho3d -wx 0.0015 -wy 0.0015 \
		-cz 0.2e-3 -vx 10 -vy -15 -vz 7
	create xtoggle /compt_select/scope [0,5,49%,20] \
		-widgets [NULL,draw.bottom,NULL,NULL]
		set /compt_select/scope	label0 "Select One Compartment" \
								label1 "Select Sub Tree"
	create xtoggle /compt_select/mouse_mode [51%,5,49%,20] \
		-widgets [NULL,draw.bottom,NULL,NULL] \
		-script "set_compt_sel_mode "<widget>
		set /compt_select/mouse_mode	label0	"Cut-n-Paste" \
										label1	"Edit Shape"
	setup_mouse(/compt_select/draw,0,0,select,do_comptselect,stretch,do_stretch,rotate,do_rotate)
	setup_mouse(/compt_select/draw,0,0,paste,do_comptpaste,cut,do_comptcut,copy,do_comptcopy)
	create xcell /compt_select/draw/cell \
		-colfield activation \
		-colmin -1 -colmax 2 -fatfield calc_dia -autocol FALSE
end

function sub_hilight(name)
	str name

	int nmsgs
	int i
	str child

	set {name} activation 1

	nmsgs = getmsg({name},IN,-count)

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({name},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({name},IN,{i},src)
			sub_hilight {child}
		end
	end
end

function hilight_compt(name)
	str name

	int scope = get(/compt_select/scope,state)

	set {cellpath}/##[TYPE=compartment] activation 0
	if ({scope} == 0) // local
		set {name} activation 1
	else
		sub_hilight({name})
	end

	xupdatepix /compt_select/draw cell
end

function display_compt(name)
	str name
	str chan
	int channo = 0

	foreach chan ({element_list(/compt_display/draw/chan#)})
		set {chan} text " " iconname dummy.icon
	end

	push /compt_display/draw

	foreach chan ({element_list({name}/#[TYPE=hh_channel])})
		set chan{channo} text {get({chan},name)} iconname hh.icon
		channo = channo + 1
	end
	foreach chan ({element_list({name}/#[TYPE=channelC2])})
		set chan{channo} text {get({chan},name)} iconname syn.icon
		channo = channo + 1
	end
	foreach chan ({element_list({name}/#[TYPE=vdep_channel])})
		set chan{channo} text {get({chan},name)} iconname vdep.icon
		channo = channo + 1
	end
	foreach chan ({element_list({name}/#[TYPE=receptor2])})
		set chan{channo} text {get({chan},name)} iconname rec.icon
		channo = channo + 1
	end

	set comptpath text {comptpath}

	foreach chan ({element_list(/compt_display/draw/chan#)})
		if (strcmp({get({chan},text)},{channelname}) == 0)
			echo text = {get({chan},text)}, channelname = {channelname}
			set hilight tx {get({chan},tx)} ty {get({chan},ty)}
			xupdate /compt_display/draw
			pop
			return
		end
	end

	xupdate .
	pop
end


function do_comptcut
	str src = get(/compt_select/draw,value)

	hilight_compt({src})
	cut_to_lib(compt_lib,{src},{get(/compt_select/scope,state)})
	set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
end


function do_comptcopy
	str src = get(/compt_select/draw,value)

	hilight_compt({src})
	copy_to_lib(compt_lib,{src},{get(/compt_select/scope,state)})
end

function do_comptpaste
	str dst = get(/compt_select/draw,value)
	str elm = get(/compt_lib_form/sel,value)
	str elmname = get({elm},name) + "[" + get({elm},index) + "]"
	str src = {cellpath} + "/" + {elmname}
	float x,y,z
	int rename_flag = get(/compt_lib_form/auto_rename,state)
	str newname

	if (strcmp({get({elm}/{elmname},object->name)},"compartment") != 0)
		echo Only compartments may be pasted onto the cell.
		return
	end

	hilight_compt({dst})

	if ({!rename_flag} && {exists({cellpath}/{elmname})})
		echo Element {elmname} already exists. Paste not done.
		return
	end
	if (exists(/buffer/temp2))
		delete /buffer/temp2
	end
	copy {elm} /buffer/temp2
	if (rename_flag)
		newname = do_child_rename(/buffer/temp2/{elmname},{dst})
		src = {cellpath} + "/" + {newname}
		subtree_move(/buffer/temp2/{newname},{cellpath})
	else
		subtree_move(/buffer/temp2/{elmname},{cellpath});
	end

	sendmsg {dst} {src} AXIAL Vm
	sendmsg {src} {dst} RAXIAL Ra Vm
	x = get({dst},x)
	y = get({dst},y)
	z = get({dst},z)
	position {src} R{x} R{y} R{z}
	// refresh the cell display

	set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	set {cellpath}xout/draw/cell path {cellpath}/##[TYPE=compartment]
end


function do_chancut
	str src = get(/compt_display/draw,value)

	hilight_channel
	cut_to_lib(compt_lib,{src},{get(/compt_select/scope,state)})
	xupdate /compt_display/draw
end


function do_chancopy
	str src = get(/compt_display/draw,value)

	hilight_channel
	copy_to_lib(compt_lib,{src},{get(/compt_select/scope,state)})
end

function do_chanpaste
	str elm = get(/compt_lib_form/sel,value)
	str elmname = get({elm},name) + "[" + get({elm},index) + "]"
	str src = "/compt_lib/" + {elmname} + "/" + {elmname}
	str chtype = get({src},object->name)
	float x,y,z
	int i,nmsgs,doit
	str gate

	if (strcmp({chtype},"compartment") == 0)
		echo element {elmname} is not a channel
		return
	end

	if (exists({comptpath}/{elmname}))
		echo Element {elmname} already exists. Paste not done.
		return
	end
		
	hilight_compt({comptpath})

	if (exists(/buffer/temp2))
		delete /buffer/temp2
	end

	if ({strcmp({chtype},"channelC2") == 0} || \
		{strcmp({chtype},"hh_channel") == 0} || \
		{strcmp({chtype},"channelA") == 0} || \
		{strcmp({chtype},"channelB") == 0} || \
		{strcmp({chtype},"channelC") == 0} || \
		{strcmp({chtype},"receptor2") == 0})
		copy {elm}/{elmname} {comptpath}
		sendmsg {comptpath}/{elmname} {comptpath} CHANNEL Gk Ek
		sendmsg {comptpath} {comptpath}/{elmname} VOLTAGE Vm
	end
	if ({strcmp({chtype},"vdep_channel") == 0})
		copy {elm}/{elmname} {comptpath}
		src = {comptpath} + "/" + {elmname}
		sendmsg {comptpath}/{elmname} {comptpath} CHANNEL Gk Ek
		/*  This loop will assign any remaining VOLTAGE slots in
		** tabgates and vdep_gates to Vm of the parent compartment.
		** Similarly, any open INPUT slots in tables will be linked in.
		*/
		foreach gate ({element_list({src}/##)})
			chtype = get({gate},object->name)

			if ({strcmp({chtype},"vdep_gate") == 0} || \
				{strcmp({chtype},"tabgate") == 0})
				doit = 1
				for (i = 0 ; i < nmsgs ; i = i + 1)
					if (strcmp({getmsg({src},IN,{i},type)},VOLTAGE) == 0)
						doit = 0 /* there already is a VOLTAGE input */
					end
				end
				if ({doit})
					sendmsg {comptpath} {gate} VOLTAGE Vm
				end
			end

			if ({strcmp({chtype},"table") == 0})
				doit = 1
				for (i = 0 ; i < nmsgs ; i = i + 1)
					if (strcmp({getmsg({src},IN,{i},type)},VOLTAGE) == 0)
						doit = 0 /* there already is a VOLTAGE input */
					end
				end
				if ({doit})
					sendmsg {comptpath} {gate} INPUT Vm
				end
			end
		end
	end
	if ({strcmp({chtype},"Ca_concen") == 0})
		copy {elm}/{elmname} {comptpath}
		echo Ca_concens normally get input from Ca channels.
		echo Messages will have to be done explicitly
	end
	if ({strcmp({chtype},"axon") == 0})
		copy {elm}/{elmname} {comptpath}
		echo Axons normally get input from spikes.
		echo Messages will have to be done explicitly
	end
	if ({strcmp({chtype},"spike") == 0})
		copy {elm}/{elmname} {comptpath}
		sendmsg {comptpath} {comptpath}/{elmname} INPUT Vm
	end
	if ({strcmp({chtype},"graded") == 0})
		copy {elm}/{elmname} {comptpath}
		sendmsg {comptpath} {comptpath}/{elmname} INPUT Vm
	end

	x = get({comptpath},x)
	y = get({comptpath},y)
	z = get({comptpath},z)

	position {comptpath}/{elmname} x y z
	display_compt({comptpath})
end



function do_comptselect
	str name

	name = get(/compt_select/draw,value)
	if ({exists({name})})
		comptpath = name
		comptname = get({name},name)
		channelpath = {comptpath} + "/" + {channelname}
		hilight_compt({comptpath})
		// hilight_compt({comptpath},{get(/compt_select/scope,state)})
		if ({strcmp({analysis_level},neuron)} == 0)
			update_neuron_params
		end
		if ({strcmp({analysis_level},compt)} == 0)
			update_compt_params
		end
		if ({strcmp({analysis_level},channel)} == 0)
			update_channel_params
		end
		display_compt({comptpath})
	end
end

function do_channelselect(widget)
	str widget

	str icon = get({widget},pixchoose)

	channelname = {get({widget}/{icon},text)}
	channelpath = {comptpath} + "/" + {channelname}
	hilight_channel
	if ({exists({channelpath})})
		if ({strcmp({analysis_level},neuron)} == 0)
			update_neuron_params
		end
		/*
		if ({strcmp({analysis_level},compt)} == 0)
			update_compt_params
		end
		*/
		if ({strcmp({analysis_level},channel)} == 0)
			update_channel_params
		end
	end
end

function set_compt_sel_mode(widget)
    str widget

    int state = get({widget},state)

    if (state == 0)
        select_mouse(/compt_select/draw,paste,do_comptpaste, \
			cut,do_comptcut,copy,do_comptcopy)
    else
        select_mouse(/compt_select/draw,select,do_comptselect, \
			stretch,do_stretch,rotate,do_rotate)
    end
end

function set_compt_disp_mode(widget)
    str widget

    int state = get({widget},state)

    if (state == 0)
        select_mouse(/compt_display/draw,paste,do_chanpaste, \
			cut,do_chancut,copy,do_chancopy)
    else
        select_mouse(/compt_display/draw, \
			select,"do_channelselect /compt_display/draw", \
			dummy,do_dummy,dummy,do_dummy)
    end
end
