//genesis

str lastinjectsite = "none"

// This function is accessed from the 'when' command in the xsout file
function set_field(widget,view)
str widget
str view
	set {view} field {get({widget},value)}
end

// This function is accessed from the 'when' command in the xsout file
function autoscale_toggle(widget,view)
str widget
	if ({get({widget},state)} == 1)
		set {view} autoscale TRUE
	else
		set {view} autoscale FALSE
	end
end

function do_inject
	str widget = {cellpath} + "xout/draw"

	str name = get({widget},value)
	str iname = get({name},name) + get({name},index)

	if (!{exists({name})})
		echo Could not find compartment '{name}' on click
		return
	end

	set {name} inject {get(/cell_run_control/"inject (nanoAmps)",value) / 1e9}
	lastinjectsite = name
	echo Setting injection on {name} to  {get(/cell_run_control/"inject (nanoAmps)",value)} nA.
	if ({exists({widget}/Inj{iname})})
		return
	end

	copy /xproto/draw/Inj {widget}/Inj{iname}
	set {widget}/Inj{iname} \
		tx {get({name},x)} ty {get({name},y)} \
		tz {get({name},z)}
end

function clear_inject
	str widget = {cellpath} + "xout/draw"

str name = get({widget},value)
str iname = get({name},name) + get({name},index)

	if (!{exists({name})})
		echo Could not find compartment '{name}' on click
		return
	end

	set {name} inject {0.0}
	lastinjectsite = "none"
	echo Setting injection on {name} to  0 nA.
	if ({exists({widget}/Inj{iname})})
		delete {widget}/Inj{iname}
	end
end


function do_vclamp
	str widget = {cellpath} + "xout/draw"
	float temp

	str name = get({widget},value)
	str iname = get({name},name) + get({name},index)
	lastinjectsite = name

	if (!{exists({name})})
		echo Could not find compartment '{name}' on click
		return
	end

	if ({exists({widget}/Vclamp{iname})})
		temp = get({widget}/Vclamp{iname}/Vclamp,x)
		temp = temp * 1e3
		set /cell_run_control/"Clamp voltage (mV)" value {temp}
		return
	end

	copy /xproto/draw/Vclamp {widget}/Vclamp{iname}
	set {widget}/Vclamp{iname} \
		tx {get({name},x)} ty {get({name},y)} \
		tz {get({name},z)}

	copy /library/Vclamp {widget}/Vclamp{iname}
	push {widget}/Vclamp{iname}/Vclamp

	temp = get(/cell_run_control/"Clamp voltage (mV)",value)
	echo Setting clamp Voltage on {name} to  {temp} mV.
	set . x {temp/1e3}
	sendmsg	.		lowpass	INJECT	x
	sendmsg	{name}	PID		SNS		Vm
	sendmsg	PID		{name}	INJECT	output
	reschedule
	pop
end


function clear_vclamp
	str widget = {cellpath} + "xout/draw"

str name = get({widget},value)
str iname = get({name},name) + get({name},index)

	if (!{exists({name})})
		echo Could not find compartment '{name}' on click
		return
	end

	set {name} inject {0.0}
	lastinjectsite = "none"
	echo Removing Voltage clamp from {name}
	if ({exists({widget}/Vclamp{iname})})
		delete {widget}/Vclamp{iname}
	end
end

function setup_mouse(draw,x,y,but1,func1,but2,func2,but3,func3)
	str draw,but1,but2,but3,func1,func2,func3
	int	x,y

	if ({exists({draw})} == 0)
		le /
		le {cellpath}xout
		echo draw widget '{draw}' does not exist.
		return
	end

	/*
	x = get({draw},x) + x
	y = get({draw},y) + y
	*/

	if (!{exists({draw}/../MOUSE)})
		push {draw}/..
		create xlabel MOUSE [{x},{y},250,32] \
			-title "MOUSE                          "
	else
		push {draw}/..
	end

	if (!{exists({but1})})
		create xbutton {but1} [{x + 70},{y + 2},47,25] 
	end

	if (!{exists({but2})})
		create xbutton {but2} [{x + 136},{y + 2},47,25] 
	end
	if (!{exists({but3})})
		create xbutton {but3} [{x + 204},{y + 2},47,25] 
	end

	dropwhen {draw} all
	when {draw} click1 do {func1}
	when {draw} click2 do {func2}
	when {draw} click3 do {func3}

	pop
end

function select_mouse(draw,but1,func1,but2,func2,but3,func3)
	str draw,but1,but2,but3
	str func1,func2,func3

	if (!{exists({draw})})
		echo draw widget '{draw}' does not exist.
		return
	end

	push {draw}/..

	if ({exists({but1})} && {exists({but2})} && {exists({but3})})
		xraise {but1}
		xraise {but2}
		xraise {but3}

		dropwhen {draw} all
		when {draw} click1 do {func1}
		when {draw} click2 do {func2}
		when {draw} click3 do {func3}
	end
	pop
end

function do_xout
	create xform {cellpath}xout [430,30,600,470]
	push {cellpath}xout
	disable .
	create xlabel "CELL GEOMETRY" [1%,2,98%,30] 
	create xdraw draw [1%,35,98%,2] \
		-widgets [NULL,NULL,NULL,NULL.bottom] \
	     -wx {1.4e-3} -wy {1.4e-3} -cz 0.2e-3 \
		 -vx 10 -vy -15 -vz 7 -transform ortho3d
	create xcell draw/cell -path {cellpath}/##[TYPE=compartment] \
		-fatfield calc_dia \
		-colfield Vm -autocol FALSE -colmin -0.1 -colmax 0.05
	set draw/cell fatfix TRUE

    setup_mouse({cellpath}xout/draw,350,0,inject,do_inject, \
        unject,clear_inject,dummy,do_dummy)
	setup_mouse({cellpath}xout/draw,350,0,Vclamp,do_vclamp, \
		unclamp,clear_vclamp,dummy,do_dummy)
    setup_mouse({cellpath}xout/draw,350,0,add_plot,add_plot, \
        drop_plot,drop_plot,dummy,do_dummy)
    setup_mouse({cellpath}xout/draw,350,0,glu,"do_transmitter glu", \
        GABA,"do_transmitter GABA",ACh,"do_transmitter ACh")

	useclock draw/cell 9
//	draw_control draw 0 0
	pop
end
