//genesis

function do_xchannel_funcs
	create xform /channel_params [480,430,520,450]
	disable /channel_params
end

function calc_cond(name)
	str name
	float len,dia,gmax

	len = calc_len({comptpath})
	dia = calc_dia({comptpath})
	if (strcmp({get({channelpath},object->name)},hh_channel) == 0)
		gmax = get({name},Gbar)
	else
		gmax = get({name},gmax)
	end

	return({gmax/(len * dia * PI)})
end

function calc_reversal(name)
	str name
	float rev
	if (strcmp({get({channelpath},object->name)},hh_channel) == 0)
		rev = get({name},Ek)
	else
		rev = get({name},Ek)
	end

	return({rev})
end

function set_cond(widget)
	str widget

	float len,dia
	float gmax = get({widget},value)

	len = calc_len({comptpath})
	dia = calc_dia({comptpath})

	gmax = gmax * len * dia * PI

	if (strcmp({get({channelpath},object->name)},hh_channel) == 0)
		set {channelpath} Gbar {gmax}
	else
		set {channelpath} gmax {gmax}
	end
end

function set_revpotl(widget)
	str widget

	float rev = get({widget},value)

	if (strcmp({get({channelpath},object->name)},hh_channel) == 0)
		set {channelpath} Ek {rev}
	else
		set {channelpath} Ek {rev}
	end
end

function update_channel_params
	echo updating channel parameters
end

function hilight_channel
	float x,y
	str pix

	push /compt_display/draw
	pix = get(.,pixchoose) 
	set hilight tx {get({pix},tx)} ty {get({pix},ty)} 
	xupdate .
	pop
end
