				SIMULATOR SHELL			3/2/89 (MW)

INTRODUCTION
------------
    The simulator shell is an interpretive operating environment 
which allows the user to execute commands, define variables,
create functions, evaluate expressions, and invoke control structures such
as conditionals and loops using an interpreted simulation language called
SLI. The user can perform these operations directly from 
the keyboard (the 'command line') or read them from text files ('scripts').
The shell contains a library of basic commands which can be augmented by
the user through the addition of compiled C commands or interpreted SLI
functions.

SHELL LANGUAGE INTERPRETER (SLI)
--------------------------------
Under the shell language interpreter (SLI) the user can 
perform the following operations:
1) define integer, floating point, and string variables.
2) evaluate arithmetic expressions
3) define and execute SLI functions
3) execute C functions compiled into the simulation library
Example:
    print hello
    help genesis
    quit

4) execute UNIX shell commands
Example:
    ls
    cat file
    vi file

5) use the following control structures:
    i) if/then/else
    ii) while loops
    iii) for loops
    iv) foreach loops

SLI INSTRUCTION SYNTAX
----------------------
All SLI instructions have basic syntactical rules. If these rules are
violated the interpreter will respond with 'syntax error' and the 
instruction will be ignored.

The basic form of an SLI instruction is either

identifier arg1 arg2 ...
identifier(arg1,arg2,...)

An identifier is a string which can consist of any combination
of alphabetic (A-Z or a-z) or numeric (0-9) characters. All other
symbols are invalid characters in an identifier.

DEFINING VARIABLES
------------------
Under SLI the user may create three types of variables - integers, floating
point, and string. Variables are created by giving a variable type
specifier followed by the variable name. This can be optionally followed
by a value assignment to the variable.

    type name [= value]

    Example:
    int a
    int b = 10
    float f = 100.5
    str name = "shell language interpreter"

Once a variable has been defined it can be assigned (or reassigned) a value
using the form

    name = value

    Example:
    a = 40
    f = 100.5
    name = "SLI"

EXPRESSION EVALUATION
---------------------
As the SLI interpreter reads or 'parses' a line of input, it interprets
arguments based on two modes: literal and expression modes.
In literal mode all characters are taken literally with no evaluation 
or transformation of the character string.

Example:
    int a = 10

    echo a * 20.1

would be interpreted as containing an identifier (in this case a built in
shell command) with 3 literal arguments. The command 'echo' would then
invoked with the arguments 'a', '*', and '20.1'.

In expression mode arguments are not taken as literal strings but are
evaluated and the resulting value substituted.
An expression consists of a sequence of arguments and operators.
The arguments can be integer or floating point numbers, strings, 
or C/SLI functions which return values. Expression mode is generally
indicated by matched curly braces { expression }. Any arguments contained
within these braces will evaluated and the complete result of the 
expression will be replaced as the argument at that location.
Some SLI operations (such as variable assignment, conditional and 
looping functins) go directly into expression mode without the 
normal expression delimiters. These will be treated individually.

Example:
    int a = 10

    echo {a * 20.1}

would be interpreted as containing the identifier 'echo' followed by
an expression. This expression would be evaluated and the command 'echo' 
would then invoked with the argument '210'.

Example:
    int a = 10 * 87

    echo a = {a}

would display

    a = 870

Note that the int a = assignment operation defaults to the expression
mode and does not require expression braces. In fact including braces in
this context will result in a syntax error.

Within an expression the following operators are valid:
+ - * / %		binary algebraic operators
- 			unary minus
== != > < >= <=		comparison operators
&& || !			boolean and/or
& | ~			logical and or not
( )			parentheses

note that while unary minus is supported, unary plus is not. Therefore
-10 is a valid argument while +10 is not.

SLI FUNCTION DEFINITION/EXECUTION
---------------------
Under SLI new functions can be created which can then be immediately 
invoked without additional processing or compilation.
The keyword 'function' is used to begin a function definition followed
by the function name and optionally by a named argument list.
The function definition is ended with the 'end keyword. The operations
placed between the 'function' and the 'end' statements will not be 
immediately executed but will go into the function for later execution.

Example:
    function test
	.
	statements
	.
	.
    end

    or

    function test(arg1,arg2,...)
	.
	statements
	.
	.
    end

After a function has been declared it can be subsequently invoked using
the assigned function name.  Arguments can be passed to the function when 
it is invoked by placing them either in a space separated argument list
(command line form), or in a comma separated list (function call form).

Example:
    function test(arg1,arg2,arg3)
    int arg1,arg2
    int arg3
	echo arguments = {arg1} {arg2 * arg3}
    end

    test(5,6,7)
	arguments = 5 42
    test 5 6 7
	arguments = 5 42

RETURN
Functions can also return values which can be used in expressions.
This is accomplished using the 'return' statement. Return goes directly
into expression mode and all arguments to it are evaluated.

Example:
    function test(arg1,arg2,arg3)
    int arg1,arg2
    int arg3
	return(arg1 + arg2 * arg3)
    end

    echo value = test(5,6,7)
	value = test(5,6,7)

    echo value = {test(5,6,7)}
	value = 47	

    test 5 6 7

Note that the return value of a function does not need to be used as in the
case of 'test 5 6 7'. Also note the use of {} to evaluate the 'value' of
the function test as opposed to the literal string 'test(5,6,7)'. In the
first case the function test is actually invoked or evaluted with the 
given arguments while the second case treats the apparent function
invocation as a simple string.

BASIC SHELL COMMANDS
----------------------
This section contains brief descriptions of the basic shell commands. For
more detailed descriptions refer to the command documentation section or
use the online 'help' facility of the simulator.

PROMPT
    When starting up GENESIS the command line will appear as a prompt waiting
for user input.

genesis #0 > 

The number contained in the prompt refers to the index of the command which
is incremented for each line entered from the keyboard. This number can
be used in conjunction with the 'history' recall mechanism to re-execute
commands based on their index.
This prompt can be changed using the 'prompt' command.

